#ifndef morpheo_Tostring
#define morpheo_Tostring

/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include <iosfwd>
#include <sstream>
#include <iomanip>
#include <string>
#include <limits>

using std::setprecision ; 
using std::ostringstream ; 
using std::boolalpha ;

namespace morpheo              {
  
  template<typename T> inline std::string toString(const T& x)
  {
    ostringstream out;
    out << x;
    return out.str();
  }
  
  template<> inline std::string toString<bool>       (const bool& x)
  {
    ostringstream out;
    //out << boolalpha << x;
    out << x;
    return out.str();
  }
  
  template<> inline std::string toString<float>      (const float& x)
  {
    const int sigdigits = std::numeric_limits<float>::digits10;
    ostringstream out;
    out << setprecision(sigdigits) << x;
    return out.str();
  }
  
  template<> inline std::string toString<double>     (const double& x)
  {
    const int sigdigits = std::numeric_limits<double>::digits10;
    ostringstream out;
    out << setprecision(sigdigits) << x;
    return out.str();
  }
  
  template<> inline std::string toString<long double>(const long double& x)
  {
    const int sigdigits = std::numeric_limits<long double>::digits10;
    ostringstream out;
    out << setprecision(sigdigits) << x;
    return out.str();
  }
  
}; // end namespace morpheo              

#endif
