/*
 * $Id: Parameters.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Icache_Access/include/Parameters.h"
#include "Common/include/Max.h"
#include "Common/include/BitManipulation.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace icache_access {


#undef  FUNCTION
#define FUNCTION "Icache_Access::Parameters"
  Parameters::Parameters (uint32_t             nb_thread                  ,
			  uint32_t             nb_front_end               ,
			  uint32_t           * nb_context                 ,
			  uint32_t             nb_icache_port             ,
			  uint32_t             size_address               ,
                          uint32_t             size_icache_thread_id      ,
                          uint32_t             size_icache_packet_id      ,
			  uint32_t          ** nb_instruction             ,
			  uint32_t          ** size_packet_id             ,
			  uint32_t          ** table_routing              ,
			  Tpriority_t          priority                   ,
			  Tload_balancing_t    load_balancing             ,
                          uint32_t          ** translate_context_to_thread,
                          bool                 is_toplevel   )
  {
    log_begin(Icache_Access,FUNCTION);
    
    _nb_thread                     = nb_thread     ;
    _nb_front_end                  = nb_front_end  ;
    _nb_context                    = nb_context    ;
    _nb_icache_port                = nb_icache_port;
    _size_address                  = size_address  ;
    _size_icache_thread_id         = size_icache_thread_id;
    _size_icache_packet_id         = size_icache_packet_id;
    _nb_instruction                = nb_instruction;
    _size_packet_id                = size_packet_id;
    _table_routing                 = table_routing ;
    _priority                      = priority      ;
    _load_balancing                = load_balancing;
    _translate_context_to_thread   = translate_context_to_thread;

    test();

    _have_port_icache_thread_id    = _size_icache_thread_id>0;
    _have_port_icache_packet_id    = _size_icache_packet_id>0;


    _translate_thread_to_context   = new Tcontext_t [_nb_thread];
    _translate_thread_to_front_end = new Tcontext_t [_nb_thread];

    for (uint32_t i=0; i<_nb_front_end; ++i)
      for (uint32_t j=0; j<_nb_context[i]; ++j)
        {
          uint32_t num_thread = translate_context_to_thread[i][j];
          
          _translate_thread_to_context   [num_thread] = i;
          _translate_thread_to_front_end [num_thread] = j;
        }

    _icache_nb_instruction   = new uint32_t [_nb_icache_port];
    for (uint32_t i=0; i<_nb_icache_port; ++i)
      _icache_nb_instruction [i] = 0;
    for (uint32_t i=0; i<_nb_front_end; i++)
      for (uint32_t j=0; j<_nb_context[i]; j++)
        {
          uint32_t port = _table_routing [i][j];

          // Take the greater
          if (_icache_nb_instruction[port] < _nb_instruction [i][j])
            _icache_nb_instruction[port] = _nb_instruction [i][j];
        }
    
    _have_port_packet_id     = new bool * [_nb_front_end];
    for (uint32_t i=0; i<_nb_front_end; i++)
      {
	_have_port_packet_id [i] = new bool [_nb_context [i]];
	
	for (uint32_t j=0; j<_nb_context[i]; j++)
	  _have_port_packet_id [i][j] = _size_packet_id [i][j] > 0;
      }
   
    _max_nb_context          = max<uint32_t>(_nb_context,_nb_front_end);
    _max_nb_instruction      = max<uint32_t>(_nb_instruction,_nb_front_end,_nb_context);
    _size_thread_id          = log2(_nb_front_end) + log2(_max_nb_context);
    _max_size_packet_id      = max<uint32_t>(_size_packet_id,_nb_front_end, _nb_context);
    
    _shift_num_front_end     = log2(_max_nb_context);
    _mask_size_context       = gen_mask<Tcontext_t>(log2(_max_nb_context));
  
    if (is_toplevel)
      {
        copy ();
      }

    log_end(Icache_Access,FUNCTION);
  };
  
// #undef  FUNCTION
// #define FUNCTION "Icache_Access::Parameters (copy)"
//   Parameters::Parameters (Parameters & param)
//   {
//     log_begin(Icache_Access,FUNCTION);
//     test();
//     log_end(Icache_Access,FUNCTION);
//   };

#undef  FUNCTION
#define FUNCTION "Icache_Access::~Parameters"
  Parameters::~Parameters (void) 
  {
    log_begin(Icache_Access,FUNCTION);

    for (uint32_t i=0; i<_nb_front_end; i++)
      delete [] _have_port_packet_id [i];
    delete [] _have_port_packet_id;
    delete [] _icache_nb_instruction;

    delete [] _translate_thread_to_front_end;
    delete [] _translate_thread_to_context  ;

    log_end(Icache_Access,FUNCTION);
  };

#undef  FUNCTION
#define FUNCTION "Icache_Access::copy"
  void Parameters::copy (void) 
  {
    log_begin(Icache_Access,FUNCTION);
    log_end(Icache_Access,FUNCTION);
  };

}; // end namespace icache_access
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
