#include "../include/Segment.h"
#include "../../Common/include/Debug.h"

namespace environment {
namespace data {
  
  bool Segment::test (std::string name)
  {
    return (this->name == name);
  }
  
  bool Segment::test (uint32_t address, uint32_t size)
  {
//     _cout(DATA,"  * Segment::test\n");
//     _cout(DATA,"    * address      : %.8x\n",address   );
//     _cout(DATA,"    * size         : %d\n"  ,size      );
//     _cout(DATA,"    * segment base : %.8x\n",this->base);
//     _cout(DATA,"    * segment size : %.8x\n",this->size);

    bool res = (((address     ) >= (this->base           )) and
		((address+size) <= (this->base+this->size)));
    
    return res;
  }
  
};
};
