/*
 * $Id: test.cpp 112 2009-03-18 22:36:26Z rosiere $
 *
 * [ Description ]
 * 
 * Test
 */

#define NB_ITERATION  16
#define CYCLE_MAX     (1024*NB_ITERATION)

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Read_unit/Read_unit/SelfTest/include/test.h"
#include "Common/include/Test.h"
#include "Common/include/BitManipulation.h"
#include "Behavioural/include/Allocation.h"

class write_req_t
{
  public : uint32_t ooo;
  public : uint32_t reg;

  write_req_t (uint32_t ooo,
	       uint32_t reg)
  {
    this->ooo = ooo;
    this->reg = reg;
  }
};

void test (string name,
	   morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_read_unit::read_unit::Parameters * _param)
{
  msg(_("<%s> : Simulation SystemC.\n"),name.c_str());

#ifdef STATISTICS
  morpheo::behavioural::Parameters_Statistics * _parameters_statistics = new morpheo::behavioural::Parameters_Statistics (5,50);
#endif

  Tusage_t _usage = USE_ALL;

//   _usage = usage_unset(_usage,USE_SYSTEMC              );
//   _usage = usage_unset(_usage,USE_VHDL                 );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH       );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH_ASSERT);
//   _usage = usage_unset(_usage,USE_POSITION             );
//   _usage = usage_unset(_usage,USE_STATISTICS           );
//   _usage = usage_unset(_usage,USE_INFORMATION          );

  Read_unit * _Read_unit = new Read_unit 
    (name.c_str(),
#ifdef STATISTICS
     _parameters_statistics,
#endif
     _param,
     _usage);
  
#ifdef SYSTEMC
  /*********************************************************************
   * Dclarations des signaux
   *********************************************************************/
  string rename;

  sc_clock              *  in_CLOCK  = new sc_clock ("clock", 1.0, 0.5);	 
  sc_signal<Tcontrol_t> *  in_NRESET = new sc_signal<Tcontrol_t> ("NRESET");

  ALLOC0_SC_SIGNAL( in_READ_UNIT_IN_VAL                   ," in_READ_UNIT_IN_VAL                   ",Tcontrol_t        );
  ALLOC0_SC_SIGNAL(out_READ_UNIT_IN_ACK                   ,"out_READ_UNIT_IN_ACK                   ",Tcontrol_t        );
  ALLOC0_SC_SIGNAL( in_READ_UNIT_IN_CONTEXT_ID            ," in_READ_UNIT_IN_CONTEXT_ID            ",Tcontext_t        );
  ALLOC0_SC_SIGNAL( in_READ_UNIT_IN_FRONT_END_ID          ," in_READ_UNIT_IN_FRONT_END_ID          ",Tcontext_t        );
  ALLOC0_SC_SIGNAL( in_READ_UNIT_IN_OOO_ENGINE_ID         ," in_READ_UNIT_IN_OOO_ENGINE_ID         ",Tcontext_t        );
  ALLOC0_SC_SIGNAL( in_READ_UNIT_IN_PACKET_ID             ," in_READ_UNIT_IN_PACKET_ID             ",Tpacket_t         );
  ALLOC0_SC_SIGNAL( in_READ_UNIT_IN_OPERATION             ," in_READ_UNIT_IN_OPERATION             ",Toperation_t      );
  ALLOC0_SC_SIGNAL( in_READ_UNIT_IN_TYPE                  ," in_READ_UNIT_IN_TYPE                  ",Ttype_t           );
  ALLOC0_SC_SIGNAL( in_READ_UNIT_IN_STORE_QUEUE_PTR_WRITE ," in_READ_UNIT_IN_STORE_QUEUE_PTR_WRITE ",Tlsq_ptr_t        );
  ALLOC0_SC_SIGNAL( in_READ_UNIT_IN_LOAD_QUEUE_PTR_WRITE  ," in_READ_UNIT_IN_LOAD_QUEUE_PTR_WRITE  ",Tlsq_ptr_t        );
  ALLOC0_SC_SIGNAL( in_READ_UNIT_IN_HAS_IMMEDIAT          ," in_READ_UNIT_IN_HAS_IMMEDIAT          ",Tcontrol_t        );
  ALLOC0_SC_SIGNAL( in_READ_UNIT_IN_IMMEDIAT              ," in_READ_UNIT_IN_IMMEDIAT              ",Tgeneral_data_t   );
  ALLOC0_SC_SIGNAL( in_READ_UNIT_IN_READ_RA               ," in_READ_UNIT_IN_READ_RA               ",Tcontrol_t        );
  ALLOC0_SC_SIGNAL( in_READ_UNIT_IN_NUM_REG_RA            ," in_READ_UNIT_IN_NUM_REG_RA            ",Tgeneral_address_t);
  ALLOC0_SC_SIGNAL( in_READ_UNIT_IN_READ_RB               ," in_READ_UNIT_IN_READ_RB               ",Tcontrol_t        );
  ALLOC0_SC_SIGNAL( in_READ_UNIT_IN_NUM_REG_RB            ," in_READ_UNIT_IN_NUM_REG_RB            ",Tgeneral_address_t);
  ALLOC0_SC_SIGNAL( in_READ_UNIT_IN_READ_RC               ," in_READ_UNIT_IN_READ_RC               ",Tcontrol_t        );
  ALLOC0_SC_SIGNAL( in_READ_UNIT_IN_NUM_REG_RC            ," in_READ_UNIT_IN_NUM_REG_RC            ",Tspecial_address_t);
  ALLOC0_SC_SIGNAL( in_READ_UNIT_IN_WRITE_RD              ," in_READ_UNIT_IN_WRITE_RD              ",Tcontrol_t        );
  ALLOC0_SC_SIGNAL( in_READ_UNIT_IN_NUM_REG_RD            ," in_READ_UNIT_IN_NUM_REG_RD            ",Tgeneral_address_t);
  ALLOC0_SC_SIGNAL( in_READ_UNIT_IN_WRITE_RE              ," in_READ_UNIT_IN_WRITE_RE              ",Tcontrol_t        );
  ALLOC0_SC_SIGNAL( in_READ_UNIT_IN_NUM_REG_RE            ," in_READ_UNIT_IN_NUM_REG_RE            ",Tspecial_address_t);
  ALLOC1_SC_SIGNAL(out_READ_UNIT_OUT_VAL                  ,"out_READ_UNIT_OUT_VAL                  ",Tcontrol_t        ,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL( in_READ_UNIT_OUT_ACK                  ," in_READ_UNIT_OUT_ACK                  ",Tcontrol_t        ,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL(out_READ_UNIT_OUT_CONTEXT_ID           ,"out_READ_UNIT_OUT_CONTEXT_ID           ",Tcontext_t        ,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL(out_READ_UNIT_OUT_FRONT_END_ID         ,"out_READ_UNIT_OUT_FRONT_END_ID         ",Tcontext_t        ,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL(out_READ_UNIT_OUT_OOO_ENGINE_ID        ,"out_READ_UNIT_OUT_OOO_ENGINE_ID        ",Tcontext_t        ,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL(out_READ_UNIT_OUT_PACKET_ID            ,"out_READ_UNIT_OUT_PACKET_ID            ",Tpacket_t         ,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL(out_READ_UNIT_OUT_OPERATION            ,"out_READ_UNIT_OUT_OPERATION            ",Toperation_t      ,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL(out_READ_UNIT_OUT_TYPE                 ,"out_READ_UNIT_OUT_TYPE                 ",Ttype_t           ,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL(out_READ_UNIT_OUT_STORE_QUEUE_PTR_WRITE,"out_READ_UNIT_OUT_STORE_QUEUE_PTR_WRITE",Tlsq_ptr_t        ,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL(out_READ_UNIT_OUT_LOAD_QUEUE_PTR_WRITE ,"out_READ_UNIT_OUT_LOAD_QUEUE_PTR_WRITE ",Tlsq_ptr_t        ,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL(out_READ_UNIT_OUT_HAS_IMMEDIAT         ,"out_READ_UNIT_OUT_HAS_IMMEDIAT         ",Tcontrol_t        ,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL(out_READ_UNIT_OUT_IMMEDIAT             ,"out_READ_UNIT_OUT_IMMEDIAT             ",Tgeneral_data_t   ,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL(out_READ_UNIT_OUT_DATA_RA              ,"out_READ_UNIT_OUT_DATA_RA              ",Tgeneral_data_t   ,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL(out_READ_UNIT_OUT_DATA_RB              ,"out_READ_UNIT_OUT_DATA_RB              ",Tgeneral_data_t   ,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL(out_READ_UNIT_OUT_DATA_RC              ,"out_READ_UNIT_OUT_DATA_RC              ",Tspecial_data_t   ,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL(out_READ_UNIT_OUT_WRITE_RD             ,"out_READ_UNIT_OUT_WRITE_RD             ",Tcontrol_t        ,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL(out_READ_UNIT_OUT_NUM_REG_RD           ,"out_READ_UNIT_OUT_NUM_REG_RD           ",Tgeneral_address_t,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL(out_READ_UNIT_OUT_WRITE_RE             ,"out_READ_UNIT_OUT_WRITE_RE             ",Tcontrol_t        ,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL(out_READ_UNIT_OUT_NUM_REG_RE           ,"out_READ_UNIT_OUT_NUM_REG_RE           ",Tspecial_address_t,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL(out_GPR_READ_VAL                       ,"out_GPR_READ_VAL                       ",Tcontrol_t        ,_param->_nb_gpr_read);
  ALLOC1_SC_SIGNAL( in_GPR_READ_ACK                       ," in_GPR_READ_ACK                       ",Tcontrol_t        ,_param->_nb_gpr_read);
  ALLOC1_SC_SIGNAL(out_GPR_READ_OOO_ENGINE_ID             ,"out_GPR_READ_OOO_ENGINE_ID             ",Tcontext_t        ,_param->_nb_gpr_read);
  ALLOC1_SC_SIGNAL(out_GPR_READ_NUM_REG                   ,"out_GPR_READ_NUM_REG                   ",Tgeneral_address_t,_param->_nb_gpr_read);
  ALLOC1_SC_SIGNAL( in_GPR_READ_DATA                      ," in_GPR_READ_DATA                      ",Tgeneral_data_t   ,_param->_nb_gpr_read);
  ALLOC1_SC_SIGNAL( in_GPR_READ_DATA_VAL                  ," in_GPR_READ_DATA_VAL                  ",Tcontrol_t        ,_param->_nb_gpr_read);
  ALLOC1_SC_SIGNAL(out_SPR_READ_VAL                       ,"out_SPR_READ_VAL                       ",Tcontrol_t        ,_param->_nb_spr_read);
  ALLOC1_SC_SIGNAL( in_SPR_READ_ACK                       ," in_SPR_READ_ACK                       ",Tcontrol_t        ,_param->_nb_spr_read);
  ALLOC1_SC_SIGNAL(out_SPR_READ_OOO_ENGINE_ID             ,"out_SPR_READ_OOO_ENGINE_ID             ",Tcontext_t        ,_param->_nb_spr_read);
  ALLOC1_SC_SIGNAL(out_SPR_READ_NUM_REG                   ,"out_SPR_READ_NUM_REG                   ",Tspecial_address_t,_param->_nb_spr_read);
  ALLOC1_SC_SIGNAL( in_SPR_READ_DATA                      ," in_SPR_READ_DATA                      ",Tspecial_data_t   ,_param->_nb_spr_read);
  ALLOC1_SC_SIGNAL( in_SPR_READ_DATA_VAL                  ," in_SPR_READ_DATA_VAL                  ",Tcontrol_t        ,_param->_nb_spr_read);
  ALLOC1_SC_SIGNAL( in_GPR_WRITE_VAL                      ," in_GPR_WRITE_VAL                      ",Tcontrol_t        ,_param->_nb_gpr_write);
  ALLOC1_SC_SIGNAL( in_GPR_WRITE_OOO_ENGINE_ID            ," in_GPR_WRITE_OOO_ENGINE_ID            ",Tcontext_t        ,_param->_nb_gpr_write);
  ALLOC1_SC_SIGNAL( in_GPR_WRITE_NUM_REG                  ," in_GPR_WRITE_NUM_REG                  ",Tgeneral_address_t,_param->_nb_gpr_write);
  ALLOC1_SC_SIGNAL( in_GPR_WRITE_DATA                     ," in_GPR_WRITE_DATA                     ",Tgeneral_data_t   ,_param->_nb_gpr_write);
  ALLOC1_SC_SIGNAL( in_SPR_WRITE_VAL                      ," in_SPR_WRITE_VAL                      ",Tcontrol_t        ,_param->_nb_spr_write);
  ALLOC1_SC_SIGNAL( in_SPR_WRITE_OOO_ENGINE_ID            ," in_SPR_WRITE_OOO_ENGINE_ID            ",Tcontext_t        ,_param->_nb_spr_write);
  ALLOC1_SC_SIGNAL( in_SPR_WRITE_NUM_REG                  ," in_SPR_WRITE_NUM_REG                  ",Tspecial_address_t,_param->_nb_spr_write);
  ALLOC1_SC_SIGNAL( in_SPR_WRITE_DATA                     ," in_SPR_WRITE_DATA                     ",Tspecial_data_t   ,_param->_nb_spr_write);
  ALLOC1_SC_SIGNAL( in_BYPASS_WRITE_OOO_ENGINE_ID         ," in_BYPASS_WRITE_OOO_ENGINE_ID         ",Tcontext_t        ,_param->_nb_bypass_write);
  ALLOC1_SC_SIGNAL( in_BYPASS_WRITE_GPR_VAL               ," in_BYPASS_WRITE_GPR_VAL               ",Tcontrol_t        ,_param->_nb_bypass_write);
  ALLOC1_SC_SIGNAL( in_BYPASS_WRITE_GPR_NUM_REG           ," in_BYPASS_WRITE_GPR_NUM_REG           ",Tgeneral_address_t,_param->_nb_bypass_write);
  ALLOC1_SC_SIGNAL( in_BYPASS_WRITE_GPR_DATA              ," in_BYPASS_WRITE_GPR_DATA              ",Tgeneral_data_t   ,_param->_nb_bypass_write);
  ALLOC1_SC_SIGNAL( in_BYPASS_WRITE_SPR_VAL               ," in_BYPASS_WRITE_SPR_VAL               ",Tcontrol_t        ,_param->_nb_bypass_write);
  ALLOC1_SC_SIGNAL( in_BYPASS_WRITE_SPR_NUM_REG           ," in_BYPASS_WRITE_SPR_NUM_REG           ",Tspecial_address_t,_param->_nb_bypass_write);
  ALLOC1_SC_SIGNAL( in_BYPASS_WRITE_SPR_DATA              ," in_BYPASS_WRITE_SPR_DATA              ",Tspecial_data_t   ,_param->_nb_bypass_write);
  ALLOC1_SC_SIGNAL( in_BYPASS_MEMORY_VAL                  ," in_BYPASS_MEMORY_VAL                  ",Tcontrol_t        ,_param->_nb_bypass_memory);
  ALLOC1_SC_SIGNAL( in_BYPASS_MEMORY_OOO_ENGINE_ID        ," in_BYPASS_MEMORY_OOO_ENGINE_ID        ",Tcontext_t        ,_param->_nb_bypass_memory);
  ALLOC1_SC_SIGNAL( in_BYPASS_MEMORY_NUM_REG              ," in_BYPASS_MEMORY_NUM_REG              ",Tgeneral_address_t,_param->_nb_bypass_memory);
  ALLOC1_SC_SIGNAL( in_BYPASS_MEMORY_DATA                 ," in_BYPASS_MEMORY_DATA                 ",Tgeneral_data_t   ,_param->_nb_bypass_memory);
  
  /********************************************************
   * Instanciation
   ********************************************************/
  
  msg(_("<%s> : Instanciation of _Read_unit.\n"),name.c_str());

  (*(_Read_unit->in_CLOCK))        (*(in_CLOCK));
  (*(_Read_unit->in_NRESET))       (*(in_NRESET));

  INSTANCE0_SC_SIGNAL(_Read_unit, in_READ_UNIT_IN_VAL                   );
  INSTANCE0_SC_SIGNAL(_Read_unit,out_READ_UNIT_IN_ACK                   );
  if (_param->_have_port_context_id)
  INSTANCE0_SC_SIGNAL(_Read_unit, in_READ_UNIT_IN_CONTEXT_ID            );
  if (_param->_have_port_front_end_id)
  INSTANCE0_SC_SIGNAL(_Read_unit, in_READ_UNIT_IN_FRONT_END_ID          );
  if (_param->_have_port_ooo_engine_id)
  INSTANCE0_SC_SIGNAL(_Read_unit, in_READ_UNIT_IN_OOO_ENGINE_ID         );
  if (_param->_have_port_rob_ptr)
  INSTANCE0_SC_SIGNAL(_Read_unit, in_READ_UNIT_IN_PACKET_ID             );
  INSTANCE0_SC_SIGNAL(_Read_unit, in_READ_UNIT_IN_OPERATION             );
  INSTANCE0_SC_SIGNAL(_Read_unit, in_READ_UNIT_IN_TYPE                  );
  INSTANCE0_SC_SIGNAL(_Read_unit, in_READ_UNIT_IN_STORE_QUEUE_PTR_WRITE );
  if (_param->_have_port_load_queue_ptr)
  INSTANCE0_SC_SIGNAL(_Read_unit, in_READ_UNIT_IN_LOAD_QUEUE_PTR_WRITE  );
  INSTANCE0_SC_SIGNAL(_Read_unit, in_READ_UNIT_IN_HAS_IMMEDIAT          );
  INSTANCE0_SC_SIGNAL(_Read_unit, in_READ_UNIT_IN_IMMEDIAT              );
  INSTANCE0_SC_SIGNAL(_Read_unit, in_READ_UNIT_IN_READ_RA               );
  INSTANCE0_SC_SIGNAL(_Read_unit, in_READ_UNIT_IN_NUM_REG_RA            );
  INSTANCE0_SC_SIGNAL(_Read_unit, in_READ_UNIT_IN_READ_RB               );
  INSTANCE0_SC_SIGNAL(_Read_unit, in_READ_UNIT_IN_NUM_REG_RB            );
  INSTANCE0_SC_SIGNAL(_Read_unit, in_READ_UNIT_IN_READ_RC               );
  INSTANCE0_SC_SIGNAL(_Read_unit, in_READ_UNIT_IN_NUM_REG_RC            );
  INSTANCE0_SC_SIGNAL(_Read_unit, in_READ_UNIT_IN_WRITE_RD              );
  INSTANCE0_SC_SIGNAL(_Read_unit, in_READ_UNIT_IN_NUM_REG_RD            );
  INSTANCE0_SC_SIGNAL(_Read_unit, in_READ_UNIT_IN_WRITE_RE              );
  INSTANCE0_SC_SIGNAL(_Read_unit, in_READ_UNIT_IN_NUM_REG_RE            );
  INSTANCE1_SC_SIGNAL(_Read_unit,out_READ_UNIT_OUT_VAL                  ,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Read_unit, in_READ_UNIT_OUT_ACK                  ,_param->_nb_inst_retire);
  if (_param->_have_port_context_id)
  INSTANCE1_SC_SIGNAL(_Read_unit,out_READ_UNIT_OUT_CONTEXT_ID           ,_param->_nb_inst_retire);
  if (_param->_have_port_front_end_id)
  INSTANCE1_SC_SIGNAL(_Read_unit,out_READ_UNIT_OUT_FRONT_END_ID         ,_param->_nb_inst_retire);
  if (_param->_have_port_ooo_engine_id)
  INSTANCE1_SC_SIGNAL(_Read_unit,out_READ_UNIT_OUT_OOO_ENGINE_ID        ,_param->_nb_inst_retire);
  if (_param->_have_port_rob_ptr)
  INSTANCE1_SC_SIGNAL(_Read_unit,out_READ_UNIT_OUT_PACKET_ID            ,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Read_unit,out_READ_UNIT_OUT_OPERATION            ,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Read_unit,out_READ_UNIT_OUT_TYPE                 ,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Read_unit,out_READ_UNIT_OUT_STORE_QUEUE_PTR_WRITE,_param->_nb_inst_retire);
  if (_param->_have_port_load_queue_ptr)
  INSTANCE1_SC_SIGNAL(_Read_unit,out_READ_UNIT_OUT_LOAD_QUEUE_PTR_WRITE ,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Read_unit,out_READ_UNIT_OUT_HAS_IMMEDIAT         ,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Read_unit,out_READ_UNIT_OUT_IMMEDIAT             ,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Read_unit,out_READ_UNIT_OUT_DATA_RA              ,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Read_unit,out_READ_UNIT_OUT_DATA_RB              ,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Read_unit,out_READ_UNIT_OUT_DATA_RC              ,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Read_unit,out_READ_UNIT_OUT_WRITE_RD             ,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Read_unit,out_READ_UNIT_OUT_NUM_REG_RD           ,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Read_unit,out_READ_UNIT_OUT_WRITE_RE             ,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Read_unit,out_READ_UNIT_OUT_NUM_REG_RE           ,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Read_unit,out_GPR_READ_VAL                       ,_param->_nb_gpr_read);
  INSTANCE1_SC_SIGNAL(_Read_unit, in_GPR_READ_ACK                       ,_param->_nb_gpr_read);
  if (_param->_have_port_ooo_engine_id)
  INSTANCE1_SC_SIGNAL(_Read_unit,out_GPR_READ_OOO_ENGINE_ID             ,_param->_nb_gpr_read);
  INSTANCE1_SC_SIGNAL(_Read_unit,out_GPR_READ_NUM_REG                   ,_param->_nb_gpr_read);
  INSTANCE1_SC_SIGNAL(_Read_unit, in_GPR_READ_DATA                      ,_param->_nb_gpr_read);
  INSTANCE1_SC_SIGNAL(_Read_unit, in_GPR_READ_DATA_VAL                  ,_param->_nb_gpr_read);
  INSTANCE1_SC_SIGNAL(_Read_unit,out_SPR_READ_VAL                       ,_param->_nb_spr_read);
  INSTANCE1_SC_SIGNAL(_Read_unit, in_SPR_READ_ACK                       ,_param->_nb_spr_read);
  if (_param->_have_port_ooo_engine_id)
  INSTANCE1_SC_SIGNAL(_Read_unit,out_SPR_READ_OOO_ENGINE_ID             ,_param->_nb_spr_read);
  INSTANCE1_SC_SIGNAL(_Read_unit,out_SPR_READ_NUM_REG                   ,_param->_nb_spr_read);
  INSTANCE1_SC_SIGNAL(_Read_unit, in_SPR_READ_DATA                      ,_param->_nb_spr_read);
  INSTANCE1_SC_SIGNAL(_Read_unit, in_SPR_READ_DATA_VAL                  ,_param->_nb_spr_read);
  INSTANCE1_SC_SIGNAL(_Read_unit, in_GPR_WRITE_VAL                      ,_param->_nb_gpr_write);
  if (_param->_have_port_ooo_engine_id)
  INSTANCE1_SC_SIGNAL(_Read_unit, in_GPR_WRITE_OOO_ENGINE_ID            ,_param->_nb_gpr_write);
  INSTANCE1_SC_SIGNAL(_Read_unit, in_GPR_WRITE_NUM_REG                  ,_param->_nb_gpr_write);
  INSTANCE1_SC_SIGNAL(_Read_unit, in_GPR_WRITE_DATA                     ,_param->_nb_gpr_write);
  INSTANCE1_SC_SIGNAL(_Read_unit, in_SPR_WRITE_VAL                      ,_param->_nb_spr_write);
  if (_param->_have_port_ooo_engine_id)
  INSTANCE1_SC_SIGNAL(_Read_unit, in_SPR_WRITE_OOO_ENGINE_ID            ,_param->_nb_spr_write);
  INSTANCE1_SC_SIGNAL(_Read_unit, in_SPR_WRITE_NUM_REG                  ,_param->_nb_spr_write);
  INSTANCE1_SC_SIGNAL(_Read_unit, in_SPR_WRITE_DATA                     ,_param->_nb_spr_write);
  if (_param->_have_port_ooo_engine_id)
  INSTANCE1_SC_SIGNAL(_Read_unit, in_BYPASS_WRITE_OOO_ENGINE_ID         ,_param->_nb_bypass_write);
  INSTANCE1_SC_SIGNAL(_Read_unit, in_BYPASS_WRITE_GPR_VAL               ,_param->_nb_bypass_write);
  INSTANCE1_SC_SIGNAL(_Read_unit, in_BYPASS_WRITE_GPR_NUM_REG           ,_param->_nb_bypass_write);
  INSTANCE1_SC_SIGNAL(_Read_unit, in_BYPASS_WRITE_GPR_DATA              ,_param->_nb_bypass_write);
  INSTANCE1_SC_SIGNAL(_Read_unit, in_BYPASS_WRITE_SPR_VAL               ,_param->_nb_bypass_write);
  INSTANCE1_SC_SIGNAL(_Read_unit, in_BYPASS_WRITE_SPR_NUM_REG           ,_param->_nb_bypass_write);
  INSTANCE1_SC_SIGNAL(_Read_unit, in_BYPASS_WRITE_SPR_DATA              ,_param->_nb_bypass_write);
  INSTANCE1_SC_SIGNAL(_Read_unit, in_BYPASS_MEMORY_VAL                  ,_param->_nb_bypass_memory);
  if (_param->_have_port_ooo_engine_id)
  INSTANCE1_SC_SIGNAL(_Read_unit, in_BYPASS_MEMORY_OOO_ENGINE_ID        ,_param->_nb_bypass_memory);
  INSTANCE1_SC_SIGNAL(_Read_unit, in_BYPASS_MEMORY_NUM_REG              ,_param->_nb_bypass_memory);
  INSTANCE1_SC_SIGNAL(_Read_unit, in_BYPASS_MEMORY_DATA                 ,_param->_nb_bypass_memory);
  
  msg(_("<%s> : Start Simulation ............\n"),name.c_str());
    
  // Initialisation
  const uint32_t seed = 0;
//const uint32_t seed = static_cast<uint32_t>(time(NULL));

  srand(seed);

  SC_START(0);

  Time * _time = new Time();

  /********************************************************
   * Simulation - Begin
   ********************************************************/
  {
  // Initialisation

  const uint32_t nb_request = _param->_nb_packet;

  Tcontext_t         _ooo_engine_id [nb_request];
  Tcontrol_t         _read_ra    [nb_request];
  Tgeneral_address_t _num_reg_ra [nb_request];
  Tcontrol_t         _read_rb    [nb_request];
  Tgeneral_address_t _num_reg_rb [nb_request];
  Tcontrol_t         _read_rc    [nb_request];
  Tspecial_address_t _num_reg_rc [nb_request];

  // emulation of registerFile
  Tcontrol_t         _gpr_val    [_param->_nb_general_register][_param->_nb_ooo_engine];
  Tgeneral_data_t    _gpr        [_param->_nb_general_register][_param->_nb_ooo_engine];
  Tcontrol_t         _spr_val    [_param->_nb_special_register][_param->_nb_ooo_engine];
  Tspecial_data_t    _spr        [_param->_nb_special_register][_param->_nb_ooo_engine];

  LABEL("Initialisation");
  in_READ_UNIT_IN_VAL ->write(0);
  for (uint32_t i=0; i<_param->_nb_inst_retire  ; i++)
    in_READ_UNIT_OUT_ACK [i]->write(0);
  for (uint32_t i=0; i<_param->_nb_gpr_write    ; i++)
    in_GPR_WRITE_VAL               [i]->write(0);
  for (uint32_t i=0; i<_param->_nb_spr_write    ; i++)
    in_SPR_WRITE_VAL               [i]->write(0);
  for (uint32_t i=0; i<_param->_nb_bypass_write ; i++)
    {
      in_BYPASS_WRITE_GPR_VAL      [i]->write(0);
      in_BYPASS_WRITE_SPR_VAL      [i]->write(0);
    }
  for (uint32_t i=0; i<_param->_nb_bypass_memory; i++)
    in_BYPASS_MEMORY_VAL           [i]->write(0);

  in_NRESET->write(0);
  SC_START(5);
  in_NRESET->write(1);

  LABEL("Loop of Test");

  for (uint32_t iteration=0; iteration<NB_ITERATION; iteration ++)
    {
      LABEL("Iteration %d",iteration);

      int32_t percent_transaction_queue_in     = (rand()%50)+25;
      int32_t percent_transaction_queue_out    = (rand()%50)+25;
      int32_t percent_registerfile_valid       = (rand()%50)+25;
      int32_t percent_transaction_registerfile = (rand()%50)+25;
      int32_t percent_transaction_bypass       = (rand()%50)+25;
      
      LABEL("Initialisation");

      for (uint32_t i=0; i<nb_request; i++)
	{
	  _ooo_engine_id   [i] = rand()% _param->_nb_ooo_engine            ;
	  _read_ra         [i] = rand()% 2                              ;
	  _num_reg_ra      [i] = rand()% _param->_nb_general_register   ;
	  _read_rb         [i] = rand()% 2                              ;
	  _num_reg_rb      [i] = rand()% _param->_nb_general_register   ;
	  _read_rc         [i] = rand()% 2                              ;
	  _num_reg_rc      [i] = rand()% _param->_nb_special_register   ;
	}
      
      // emulation of registerFile
      for (uint32_t j=0; j<_param->_nb_ooo_engine; j++)
	{
	  for (uint32_t i=0; i<_param->_nb_general_register; i++)
	    {
	      _gpr_val      [i][j] = ((rand()%100) < percent_registerfile_valid);
	      _gpr          [i][j] = range<Tgeneral_data_t>(rand(),_param->_size_general_data);
	    }
	  for (uint32_t i=0; i<_param->_nb_special_register; i++)
	    {
	      _spr_val      [i][j] = ((rand()%100) < percent_registerfile_valid);
	      _spr          [i][j] = range<Tspecial_data_t>(rand(),_param->_size_special_data);
	    }
	}
      // End initialisation .......

      uint32_t request_in  = 0;
      uint32_t request_out = 0;
      bool     request_out_wait [nb_request];

      for (uint32_t i=0; i<nb_request; i++)
	request_out_wait [i] = true;
      
//       bool can_gpr_use [_param->_nb_ooo_engine][_param->_nb_general_register];
//       bool can_spr_use [_param->_nb_ooo_engine][_param->_nb_special_register];

      list<write_req_t> write_req_gpr;
      list<write_req_t> write_req_spr;

      while (request_out < nb_request)
	{
	  LABEL("request_in         : %d",request_in );
	  LABEL("request_out        : %d",request_out);
	  for (uint32_t i=0; i<nb_request; i++)
	    if (request_out_wait [i])
	      LABEL("request_out_wait   : %d",i);
	  LABEL("write_req_gpr size : %d",write_req_gpr.size());
	  LABEL("write_req_spr size : %d",write_req_spr.size());

// 	  for (uint32_t j=0; j<_param->_nb_ooo_engine; j++)
// 	    {
// 	      for (uint32_t i=0; i<_param->_nb_general_register; i++)
// 		can_gpr_use [j][i] = true;
// 	      for (uint32_t i=0; i<_param->_nb_special_register; i++)
// 		can_spr_use [j][i] = true;
// 	    }

	  Tcontrol_t         read_unit_in_val = (request_in < nb_request) and ((rand()%100) < percent_transaction_queue_in);
	  Tcontext_t         read_unit_in_ooo_engine_id;
	  Tgeneral_address_t read_unit_in_num_reg_ra;
	  Tgeneral_address_t read_unit_in_num_reg_rb;
	  Tspecial_address_t read_unit_in_num_reg_rc;

	  in_READ_UNIT_IN_VAL         ->write(read_unit_in_val);
	  if (read_unit_in_val)
	    {
	      bool               data_val;
	      read_unit_in_ooo_engine_id = _ooo_engine_id [request_in];
	      read_unit_in_num_reg_ra    = _num_reg_ra [request_in];
	      read_unit_in_num_reg_rb    = _num_reg_rb [request_in];
	      read_unit_in_num_reg_rc    = _num_reg_rc [request_in];

	      if (_param->_have_port_context_id)
              in_READ_UNIT_IN_CONTEXT_ID     ->write((2*read_unit_in_ooo_engine_id)%_param->_nb_context  );
	      if (_param->_have_port_front_end_id)
              in_READ_UNIT_IN_FRONT_END_ID   ->write((3*read_unit_in_ooo_engine_id)%_param->_nb_front_end);
   	      if (_param->_have_port_ooo_engine_id)
              in_READ_UNIT_IN_OOO_ENGINE_ID  ->write(read_unit_in_ooo_engine_id);
   	      if (_param->_have_port_rob_ptr)
              in_READ_UNIT_IN_PACKET_ID   ->write(request_in);
   	      in_READ_UNIT_IN_OPERATION   ->write(0);
   	      in_READ_UNIT_IN_TYPE        ->write(0);
   	      in_READ_UNIT_IN_STORE_QUEUE_PTR_WRITE->write(0);
	      if (_param->_have_port_load_queue_ptr)
   	      in_READ_UNIT_IN_LOAD_QUEUE_PTR_WRITE ->write(0);
   	      in_READ_UNIT_IN_HAS_IMMEDIAT->write(0);
   	      in_READ_UNIT_IN_IMMEDIAT    ->write(0);
	      in_READ_UNIT_IN_READ_RA     ->write(_read_ra[request_in]);
	      data_val = not(_read_ra[request_in]) or _gpr_val[read_unit_in_num_reg_ra][read_unit_in_ooo_engine_id];

 	      if (not data_val)
		if (rand ()%2)
		  write_req_gpr.push_back (write_req_t(read_unit_in_ooo_engine_id,read_unit_in_num_reg_ra));
		else
		  write_req_gpr.push_front(write_req_t(read_unit_in_ooo_engine_id,read_unit_in_num_reg_ra));


	      in_READ_UNIT_IN_NUM_REG_RA  ->write(read_unit_in_num_reg_ra);
//    	      in_READ_UNIT_IN_DATA_RA_VAL ->write(data_val);
//    	      in_READ_UNIT_IN_DATA_RA     ->write((data_val)?_gpr[read_unit_in_num_reg_ra][read_unit_in_ooo_engine_id]:0);
	      in_READ_UNIT_IN_READ_RB     ->write(_read_rb[request_in]);
	      data_val = not(_read_rb[request_in]) or _gpr_val[read_unit_in_num_reg_rb][read_unit_in_ooo_engine_id];

 	      if (not data_val)
  		if (rand ()%2)
		  write_req_gpr.push_back (write_req_t(read_unit_in_ooo_engine_id,read_unit_in_num_reg_rb));
		else
		  write_req_gpr.push_front(write_req_t(read_unit_in_ooo_engine_id,read_unit_in_num_reg_rb));


   	      in_READ_UNIT_IN_NUM_REG_RB  ->write(read_unit_in_num_reg_rb);			       
//    	      in_READ_UNIT_IN_DATA_RB_VAL ->write(data_val);			       
//    	      in_READ_UNIT_IN_DATA_RB     ->write((data_val)?_gpr[read_unit_in_num_reg_rb][read_unit_in_ooo_engine_id]:0);
	      in_READ_UNIT_IN_READ_RC     ->write(_read_rc[request_in]);
	      data_val = not(_read_rc[request_in]) or _spr_val[read_unit_in_num_reg_rc][read_unit_in_ooo_engine_id];

	      if (not data_val)
		if (rand ()%2)
		  write_req_spr.push_back (write_req_t(read_unit_in_ooo_engine_id,read_unit_in_num_reg_rc));
		else
		  write_req_spr.push_front(write_req_t(read_unit_in_ooo_engine_id,read_unit_in_num_reg_rc));

   	      in_READ_UNIT_IN_NUM_REG_RC  ->write(read_unit_in_num_reg_rc);			       
//    	      in_READ_UNIT_IN_DATA_RC_VAL ->write(data_val);			       
//    	      in_READ_UNIT_IN_DATA_RC     ->write((data_val)?_spr[read_unit_in_num_reg_rc][read_unit_in_ooo_engine_id]:0);
   	      in_READ_UNIT_IN_WRITE_RD    ->write(0);
   	      in_READ_UNIT_IN_NUM_REG_RD  ->write(0);
   	      in_READ_UNIT_IN_WRITE_RE    ->write(0);
   	      in_READ_UNIT_IN_NUM_REG_RE  ->write(0);

// 	      can_gpr_use [read_unit_in_ooo_engine_id][read_unit_in_num_reg_ra] = false;
// 	      can_gpr_use [read_unit_in_ooo_engine_id][read_unit_in_num_reg_rb] = false;
// 	      can_spr_use [read_unit_in_ooo_engine_id][read_unit_in_num_reg_rc] = false;
	    }
	  	  
	  for (uint32_t i=0; i<_param->_nb_inst_retire; i++)
	    in_READ_UNIT_OUT_ACK[i]->write((rand()%100)<percent_transaction_queue_out);

	  // RegisterFile access
	  for (uint32_t i=0; i<_param->_nb_gpr_read ; i++)
	    {
	      Tcontrol_t ack = (rand()%100) < percent_transaction_registerfile;
	      in_GPR_READ_ACK      [i]->write(ack);

	      SC_START(0);

	      if (out_GPR_READ_VAL [i]->read())
		{
		  Tgeneral_address_t num_reg    = out_GPR_READ_NUM_REG       [i]->read();
		  Tcontext_t         ooo_engine = (_param->_have_port_ooo_engine_id)?out_GPR_READ_OOO_ENGINE_ID [i]->read():0;
		  Tgeneral_data_t    data       = _gpr    [num_reg][ooo_engine];
		  Tcontrol_t         data_val   = _gpr_val[num_reg][ooo_engine];
		  
		  if (ack)
		    LABEL(" * GPR_READ      [%d] - gpr[%d][%d] ->  (%d) 0x%x",i,num_reg,ooo_engine,data_val,data);
		  
		  in_GPR_READ_DATA     [i]->write(data);
		  in_GPR_READ_DATA_VAL [i]->write(data_val);
		}
	    }

	  for (uint32_t i=0; i<_param->_nb_spr_read ; i++)
	    {
	      Tcontrol_t ack = (rand()%100) < percent_transaction_registerfile;
	      in_SPR_READ_ACK      [i]->write(ack);

	      SC_START(0);

	      if (out_SPR_READ_VAL [i]->read())
		{
		  Tspecial_address_t num_reg    = out_SPR_READ_NUM_REG       [i]->read();
		  Tcontext_t         ooo_engine = (_param->_have_port_ooo_engine_id)?out_SPR_READ_OOO_ENGINE_ID [i]->read():0;
		  Tspecial_data_t    data       = _spr    [num_reg][ooo_engine];
		  Tcontrol_t         data_val   = _spr_val[num_reg][ooo_engine];
		  
		  if (ack)
		    LABEL(" * SPR_READ      [%d] - spr[%d][%d] ->  (%d) 0x%x",i,num_reg,ooo_engine,data_val,data);
		  
		  in_SPR_READ_DATA     [i]->write(data);
		  in_SPR_READ_DATA_VAL [i]->write(data_val);
		}
	    }

	  list<write_req_t>::iterator it_gpr = write_req_gpr.begin();
	  list<write_req_t>::iterator it_spr = write_req_spr.begin();

	  LABEL("Bypass Network :");
	  for (uint32_t i=0; i<_param->_nb_gpr_write; i++)
	    {
	      Tcontext_t         ooo_engine = (it_gpr != write_req_gpr.end())?(*it_gpr).ooo:0;
	      Tgeneral_address_t num_reg    = (it_gpr != write_req_gpr.end())?(*it_gpr).reg:0;
	      Tcontrol_t         val     = (_gpr_val [num_reg][ooo_engine]== 0)?((rand()%100) < percent_transaction_registerfile):0;
	      Tgeneral_data_t    data    = range<Tgeneral_data_t>(rand(),_param->_size_general_data);
	    
	      val = (val// and can_spr_use [ooo_engine][num_reg]
		     and (it_gpr != write_req_gpr.end()));

	      in_GPR_WRITE_VAL            [i]->write(val);	      
	      if (_param->_have_port_ooo_engine_id)
              in_GPR_WRITE_OOO_ENGINE_ID  [i]->write(ooo_engine);
	      in_GPR_WRITE_NUM_REG        [i]->write(num_reg);
	      in_GPR_WRITE_DATA           [i]->write(data);

	      if (val)
		{
		  LABEL(" * GPR_WRITE     [%d] - gpr[%d][%d] <- 0x%x",i,num_reg,ooo_engine,data);

// 		  can_gpr_use [ooo_engine][num_reg] = false;

		  _gpr     [num_reg][ooo_engine] = data;
		  _gpr_val [num_reg][ooo_engine] = 1;
		}

	      if (it_gpr != write_req_gpr.end())
		it_gpr ++;
	    }
	  for (uint32_t i=0; i<_param->_nb_spr_write; i++)
	    {
	      Tcontext_t         ooo_engine = (it_spr != write_req_spr.end())?(*it_spr).ooo:0;
	      Tgeneral_address_t num_reg    = (it_spr != write_req_spr.end())?(*it_spr).reg:0;

	      Tcontrol_t         val     = (_spr_val [num_reg][ooo_engine]== 0)?((rand()%100) < percent_transaction_registerfile):0;
	      Tspecial_data_t    data    = range<Tspecial_data_t>(rand(),_param->_size_special_data);

	      val = (val // and can_spr_use [ooo_engine][num_reg]
		     and (it_spr != write_req_spr.end()));

	      in_SPR_WRITE_VAL            [i]->write(val);	      
	      if (_param->_have_port_ooo_engine_id)
              in_SPR_WRITE_OOO_ENGINE_ID  [i]->write(ooo_engine);
	      in_SPR_WRITE_NUM_REG        [i]->write(num_reg);
	      in_SPR_WRITE_DATA           [i]->write(data);

	      if (val == 1)
		{
		  LABEL(" * SPR_WRITE     [%d] - spr[%d][%d] <- 0x%x",i,num_reg,ooo_engine,data);
		  
// 		  can_spr_use [ooo_engine][num_reg] = false;

		  _spr     [num_reg][ooo_engine] = data;
		  _spr_val [num_reg][ooo_engine] = 1;
		}

	      if (it_spr != write_req_spr.end())
		it_spr ++;

	    }

	  for (uint32_t i=0; i<_param->_nb_bypass_write; i++)
	    {
	      Tcontext_t         ooo_engine = (it_gpr != write_req_gpr.end())?(*it_gpr).ooo:0;
	      Tgeneral_address_t gpr_num_reg= (it_gpr != write_req_gpr.end())?(*it_gpr).reg:0;

	      if (_param->_have_port_ooo_engine_id)
              in_BYPASS_WRITE_OOO_ENGINE_ID [i]->write(ooo_engine);

	      Tcontrol_t         gpr_val     = (_gpr_val [gpr_num_reg][ooo_engine]== 0)?((rand()%100) < percent_transaction_bypass):0;
	      Tgeneral_data_t    gpr_data    = range<Tgeneral_data_t>(rand(),_param->_size_general_data);
	      
	      gpr_val = (gpr_val // and can_gpr_use [ooo_engine][gpr_num_reg]
			 and (it_gpr != write_req_gpr.end()));

	      in_BYPASS_WRITE_GPR_VAL    [i]->write(gpr_val);	      
	      in_BYPASS_WRITE_GPR_NUM_REG[i]->write(gpr_num_reg);
	      in_BYPASS_WRITE_GPR_DATA   [i]->write(gpr_data);

	      if (gpr_val)
		{
		  LABEL(" * BYPASS_WRITE  [%d] - gpr[%d][%d] <- 0x%x",i,gpr_num_reg,ooo_engine,gpr_data);
// 		  can_gpr_use [ooo_engine][gpr_num_reg] = false;

		  _gpr     [gpr_num_reg][ooo_engine] = gpr_data;
		  _gpr_val [gpr_num_reg][ooo_engine] = 1;
		}

 	      if (it_gpr != write_req_gpr.end())
		it_gpr ++;

	      Tspecial_address_t spr_num_reg = (it_spr != write_req_spr.end())?(*it_spr).reg:0;
	      Tcontrol_t         spr_val     = (_spr_val [spr_num_reg][ooo_engine]== 0)?((rand()%100) < percent_transaction_bypass):0;
	      Tspecial_data_t    spr_data    = range<Tspecial_data_t>(rand(),_param->_size_special_data);
	      
	      spr_val = (spr_val // and can_spr_use [ooo_engine][spr_num_reg]
			 and (it_spr != write_req_spr.end()) and ((*it_spr).ooo == ooo_engine));

	      in_BYPASS_WRITE_SPR_VAL    [i]->write(spr_val);	      
	      in_BYPASS_WRITE_SPR_NUM_REG[i]->write(spr_num_reg);
	      in_BYPASS_WRITE_SPR_DATA   [i]->write(spr_data);

	      if (spr_val)
		{
		  LABEL(" * BYPASS_WRITE  [%d] - spr[%d][%d] <- 0x%x",i,spr_num_reg,ooo_engine,spr_data);

// 		  can_spr_use [ooo_engine][spr_num_reg] = false;

		  _spr     [spr_num_reg][ooo_engine] = spr_data;
		  _spr_val [spr_num_reg][ooo_engine] = 1;
		}

	      if (it_spr != write_req_spr.end())
		it_spr ++;
	    }

	  for (uint32_t i=0; i<_param->_nb_bypass_memory; i++)
	    {
	      Tcontext_t         ooo_engine = (it_gpr != write_req_gpr.end())?(*it_gpr).ooo:0;
	      Tgeneral_address_t num_reg    = (it_gpr != write_req_gpr.end())?(*it_gpr).reg:0;

	      if (_param->_have_port_ooo_engine_id)
              in_BYPASS_MEMORY_OOO_ENGINE_ID [i]->write(ooo_engine);

	      Tcontrol_t         val     = (_gpr_val [num_reg][ooo_engine]== 0)?((rand()%100) < percent_transaction_bypass):0;
	      Tgeneral_data_t    data    = range<Tgeneral_data_t>(rand(),_param->_size_general_data);
	      
	      val = (val // and can_gpr_use [ooo_engine][num_reg]
		     and (it_gpr != write_req_gpr.end()));

	      in_BYPASS_MEMORY_VAL    [i]->write(val);	      
	      in_BYPASS_MEMORY_NUM_REG[i]->write(num_reg);
	      in_BYPASS_MEMORY_DATA   [i]->write(data);

	      if (val)
		{
		  LABEL(" * BYPASS_MEMORY [%d] - gpr[%d][%d] <- 0x%x",i,num_reg,ooo_engine,data);
		  
// 		  can_gpr_use [ooo_engine][num_reg] = false;

		  _gpr     [num_reg][ooo_engine] = data;
		  _gpr_val [num_reg][ooo_engine] = 1;
		}

	      if (it_gpr != write_req_gpr.end())
		it_gpr ++;
	    }

	  SC_START(0); // to mealy function
	  
// 	  LABEL("Test     READ_UNIT_IN  : "+toString(in_READ_UNIT_IN_VAL->read())+","+toString(out_READ_UNIT_IN_ACK->read()));
	  if (( in_READ_UNIT_IN_VAL->read() == 1) and
	      (out_READ_UNIT_IN_ACK->read() == 1))
	    {
	      LABEL("Accepted READ_UNIT_IN  number : %d",request_in);
	      request_in  ++;
	    }

	  for (uint32_t i=0; i<_param->_nb_inst_retire; i++)
	    {
 	      LABEL("Test     READ_UNIT_OUT %d : %d,%d",i,out_READ_UNIT_OUT_VAL[i]->read(),in_READ_UNIT_OUT_ACK[i]->read());
	      if ((out_READ_UNIT_OUT_VAL [i]->read() == 1) and
		  ( in_READ_UNIT_OUT_ACK [i]->read() == 1))
		{
		  Tpacket_t  packet_id;
		  if (_param->_have_port_rob_ptr)
		    packet_id = out_READ_UNIT_OUT_PACKET_ID [i]->read();
		  else
		    packet_id = 0;
		  LABEL("Accepted READ_UNIT_OUT [%d] number : %d, request number : %d",i,packet_id,request_out);
		  TEST(bool, request_out_wait [packet_id] , true);

		  request_out ++;
		  request_out_wait [packet_id] = false;

		  Tcontext_t ooo_engine_id = _ooo_engine_id [packet_id];
		  
		  if (_param->_have_port_context_id)
		  TEST(Tcontext_t        ,out_READ_UNIT_OUT_CONTEXT_ID   [i]->read(),(2*ooo_engine_id)%_param->_nb_context  );
		  if (_param->_have_port_front_end_id)
		  TEST(Tcontext_t        ,out_READ_UNIT_OUT_FRONT_END_ID [i]->read(),(3*ooo_engine_id)%_param->_nb_front_end);
		  if (_param->_have_port_ooo_engine_id)
		  TEST(Tcontext_t        ,out_READ_UNIT_OUT_OOO_ENGINE_ID[i]->read(),ooo_engine_id);

		  if (_read_ra [packet_id])
		  TEST(Tgeneral_data_t   ,out_READ_UNIT_OUT_DATA_RA   [i]->read(),_gpr[_num_reg_ra[packet_id]][ooo_engine_id]);
		  
		  if (_read_rb [packet_id])
		  TEST(Tgeneral_data_t   ,out_READ_UNIT_OUT_DATA_RB   [i]->read(),_gpr[_num_reg_rb[packet_id]][ooo_engine_id]);
		  
		  if (_read_rc [packet_id])
		  TEST(Tspecial_data_t   ,out_READ_UNIT_OUT_DATA_RC   [i]->read(),_spr[_num_reg_rc[packet_id]][ooo_engine_id]);
		}
	    }
	  
	  SC_START(1);	  

	  for (list<write_req_t>::iterator it = write_req_gpr.begin();
	       it != write_req_gpr.end();
	       )
	    {
	      if (_gpr_val [(*it).reg][(*it).ooo] == 1)
		it = write_req_gpr.erase(it);
	      else
		it ++;
	    }

	  for (list<write_req_t>::iterator it = write_req_spr.begin();
	       it != write_req_spr.end();
	       )
	    {
	      if (_spr_val [(*it).reg][(*it).ooo] == 1)
		it = write_req_spr.erase(it);
	      else
		it ++;
	    }
	}

      for (uint32_t i=0; i<nb_request; i++)
	TEST(bool, request_out_wait [i] , false);
    }
  }

  /********************************************************
   * Simulation - End
   ********************************************************/

  TEST_OK ("End of Simulation");
  delete _time;

  msg(_("<%s> : ............ Stop Simulation\n"),name.c_str());

  delete in_CLOCK;
  delete in_NRESET;
#endif

  delete _Read_unit;
#ifdef STATISTICS
  delete _parameters_statistics;
#endif
}
