/*
 * $Id: Decod_unit.cpp 123 2009-06-08 20:43:30Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Decod_unit/include/Decod_unit.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace decod_unit {


#undef  FUNCTION
#define FUNCTION "Decod_unit::Decod_unit"
  Decod_unit::Decod_unit 
  (
#ifdef SYSTEMC
   sc_module_name name,
#else
   string name,
#endif
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   morpheo::behavioural::core::multi_front_end::front_end::decod_unit::Parameters * param,
   morpheo::behavioural::Tusage_t usage
   ):
    _name              (name)
    ,_param            (param)
    ,_usage            (usage)
  {
    log_begin(Decod_unit,FUNCTION);

    usage_environment(_usage);

// #if DEBUG_Decod_unit == true
//     log_printf(INFO,Decod_unit,FUNCTION,_("<%s> Parameters"),_name.c_str());

//     std::cout << *param << std::endl;
// #endif    

    log_printf(INFO,Decod_unit,FUNCTION,_("Allocation"));

    allocation (
#ifdef STATISTICS
		param_statistics
#endif
		);

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {	
	log_printf(INFO,Decod_unit,FUNCTION,_("Allocation of statistics"));

	statistics_allocation(param_statistics);
      }
#endif

#ifdef VHDL
    if (usage_is_set(_usage,USE_VHDL))
      {
	// generate the vhdl
	log_printf(INFO,Decod_unit,FUNCTION,_("Generate the vhdl"));
	
	vhdl();
      }
#endif

#ifdef SYSTEMC
    if (usage_is_set(_usage,USE_SYSTEMC))
      {
	log_printf(INFO,Decod_unit,FUNCTION,_("Method - transition"));

	SC_METHOD (transition);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).pos();
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    
	
#endif
      }
    log_end(Decod_unit,FUNCTION);
  };
    
#undef  FUNCTION
#define FUNCTION "Decod_unit::~Decod_unit"
  Decod_unit::~Decod_unit (void)
  {
    log_begin(Decod_unit,FUNCTION);

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {
	statistics_deallocation();
      }
#endif

    log_printf(INFO,Decod_unit,FUNCTION,_("Deallocation"));
    deallocation ();

    log_end(Decod_unit,FUNCTION);
  };

}; // end namespace decod_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
