#ifdef SYSTEMC
/*
 * $Id: Branch_Target_Buffer_Register_constant.cpp 131 2009-07-08 18:40:08Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Branch_Target_Buffer/Branch_Target_Buffer_Register/include/Branch_Target_Buffer_Register.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace branch_target_buffer {
namespace branch_target_buffer_register {

#undef  FUNCTION
#define FUNCTION "Branch_Target_Buffer_Register::constant"
  void Branch_Target_Buffer_Register::constant (void)
  {
    log_begin(Branch_Target_Buffer_Register,FUNCTION);
    log_function(Branch_Target_Buffer_Register,FUNCTION,_name.c_str());

    for (uint32_t i=0; i<_param->_nb_inst_predict; i++)
      {
        PORT_WRITE(out_PREDICT_ACK [i],1);
      }
    for (uint32_t i=0; i<_param->_nb_inst_decod; i++)
      {
        internal_DECOD_ACK [i] = 1;
        PORT_WRITE(out_DECOD_ACK [i], internal_DECOD_ACK [i]);
      }
    for (uint32_t i=0; i<_param->_nb_inst_update; i++)
      {
        internal_UPDATE_ACK [i] = 1;
        PORT_WRITE(out_UPDATE_ACK [i], internal_UPDATE_ACK [i]);
      }
    
    log_end(Branch_Target_Buffer_Register,FUNCTION);
  };

}; // end namespace branch_target_buffer_register
}; // end namespace branch_target_buffer
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
