/*
 * $Id: Branch_Target_Buffer.cpp 123 2009-06-08 20:43:30Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Branch_Target_Buffer/include/Branch_Target_Buffer.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace branch_target_buffer {


#undef  FUNCTION
#define FUNCTION "Branch_Target_Buffer::Branch_Target_Buffer"
  Branch_Target_Buffer::Branch_Target_Buffer 
  (
#ifdef SYSTEMC
   sc_module_name name,
#else
   string name,
#endif
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::branch_target_buffer::Parameters * param,
   morpheo::behavioural::Tusage_t usage
   ):
    _name              (name)
    ,_param            (param)
    ,_usage            (usage)
  {
    log_printf(FUNC,Branch_Target_Buffer,FUNCTION,"Begin");

    log_printf(INFO,Branch_Target_Buffer,FUNCTION,"Allocation");

// #if DEBUG_Branch_Target_Buffer == true
//     log_printf(INFO,Branch_Target_Buffer,FUNCTION,_("<%s> Parameters"),_name.c_str());

//     std::cout << *param << std::endl;
// #endif    

    allocation (
#ifdef STATISTICS
		param_statistics
#endif
		);

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {	
	log_printf(INFO,Branch_Target_Buffer,FUNCTION,"Allocation of statistics");

	statistics_allocation(param_statistics);
      }
#endif

#ifdef VHDL
    if (usage_is_set(_usage,USE_VHDL))
      {
	// generate the vhdl
	log_printf(INFO,Branch_Target_Buffer,FUNCTION,"Generate the vhdl");
	
	vhdl();
      }
#endif

#ifdef SYSTEMC
    if (usage_is_set(_usage,USE_SYSTEMC))
      {
	log_printf(INFO,Branch_Target_Buffer,FUNCTION,_("Method - transition"));

	SC_METHOD (transition);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).pos();
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    
	
#endif
      }
    log_printf(FUNC,Branch_Target_Buffer,FUNCTION,"End");
  };
    
#undef  FUNCTION
#define FUNCTION "Branch_Target_Buffer::~Branch_Target_Buffer"
  Branch_Target_Buffer::~Branch_Target_Buffer (void)
  {
    log_printf(FUNC,Branch_Target_Buffer,FUNCTION,"Begin");

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {
	statistics_deallocation();
      }
#endif

    log_printf(INFO,Branch_Target_Buffer,FUNCTION,"Deallocation");
    deallocation ();

    log_printf(FUNC,Branch_Target_Buffer,FUNCTION,"End");
  };

}; // end namespace branch_target_buffer
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
