/*
 * $Id: Two_Level_Branch_Predictor.cpp 131 2009-07-08 18:40:08Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Direction/Meta_Predictor/Two_Level_Branch_Predictor/include/Two_Level_Branch_Predictor.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace direction {
namespace meta_predictor {
namespace two_level_branch_predictor {


#undef  FUNCTION
#define FUNCTION "Two_Level_Branch_Predictor::Two_Level_Branch_Predictor"
  Two_Level_Branch_Predictor::Two_Level_Branch_Predictor 
  (
#ifdef SYSTEMC
   sc_module_name name,
#else
   string name,
#endif
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::direction::meta_predictor::two_level_branch_predictor::Parameters * param,
   morpheo::behavioural::Tusage_t usage
   ):
    _name              (name)
    ,_param            (param)
    ,_usage            (usage)
  {
    log_begin(Two_Level_Branch_Predictor,FUNCTION);

    usage_environment(_usage);

    log_printf(INFO,Two_Level_Branch_Predictor,FUNCTION,_("<%s> : Allocation"),_name.c_str());

    allocation (
#ifdef STATISTICS
		param_statistics
#endif
		);

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {	
	log_printf(INFO,Two_Level_Branch_Predictor,FUNCTION,_("<%s> : Allocation of statistics"),_name.c_str());

	statistics_allocation(param_statistics);
      }
#endif

#ifdef VHDL
    if (usage_is_set(_usage,USE_VHDL))
      {
	// generate the vhdl
	log_printf(INFO,Two_Level_Branch_Predictor,FUNCTION,_("<%s> : Generate the vhdl"),_name.c_str());
	
	vhdl();
      }
#endif

#ifdef SYSTEMC
    if (usage_is_set(_usage,USE_SYSTEMC))
      {
#ifdef SYSTEMCASS_SPECIFIC
        constant();
#else
	log_printf(INFO,Two_Level_Branch_Predictor,FUNCTION,_("<%s> : Method - constant"),_name.c_str());

	SC_METHOD (constant);
// 	dont_initialize ();
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    
#endif

	log_printf(INFO,Two_Level_Branch_Predictor,FUNCTION,_("<%s> : Method - transition"),_name.c_str());

	SC_METHOD (transition);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).pos();
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    

	log_printf(INFO,Two_Level_Branch_Predictor,FUNCTION,_("<%s> : Method - genMealy_predict"),_name.c_str());

	SC_METHOD (genMealy_predict);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).neg(); // need internal register

        for (uint32_t i=0; i<_param->_nb_inst_predict; ++i)
          sensitive 
//             << (*(in_PREDICT_VAL     [i]))
            << (*(in_PREDICT_ADDRESS [i]));
        	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    
	
#endif
      }
    log_end(Two_Level_Branch_Predictor,FUNCTION);
  };
    
#undef  FUNCTION
#define FUNCTION "Two_Level_Branch_Predictor::~Two_Level_Branch_Predictor"
  Two_Level_Branch_Predictor::~Two_Level_Branch_Predictor (void)
  {
    log_begin(Two_Level_Branch_Predictor,FUNCTION);

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {
	statistics_deallocation();
      }
#endif

    log_printf(INFO,Two_Level_Branch_Predictor,FUNCTION,_("<%s> : Deallocation"),_name.c_str());
    deallocation ();

    log_end(Two_Level_Branch_Predictor,FUNCTION);
  };

}; // end namespace two_level_branch_predictor
}; // end namespace meta_predictor
}; // end namespace direction
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
