#ifdef SYSTEMC
/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Prediction_unit_Glue/include/Prediction_unit_Glue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace prediction_unit_glue {


#undef  FUNCTION
#define FUNCTION "Prediction_unit_Glue::transition"
  void Prediction_unit_Glue::transition (void)
  {
    log_begin(Prediction_unit_Glue,FUNCTION);

    if (PORT_READ(in_NRESET) == 0)
      {
	reg_PREDICT_PRIORITY = 0;
	reg_DECOD_PRIORITY   = 0;
      }
    else
      {
	// Round robin priority
	reg_PREDICT_PRIORITY = (reg_PREDICT_PRIORITY+_param->_nb_inst_branch_predict)%_param->_nb_context; 
	reg_DECOD_PRIORITY   = (reg_DECOD_PRIORITY  +1)%_param->_nb_decod_unit;
      }
#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
    end_cycle ();
#endif

    log_end(Prediction_unit_Glue,FUNCTION);
  };

}; // end namespace prediction_unit_glue
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
