#ifdef SYSTEMC
/*
 * $Id: OOO_Engine_Glue_transition.cpp 110 2009-02-19 16:31:47Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/OOO_Engine_Glue/include/OOO_Engine_Glue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace ooo_engine_glue {


#undef  FUNCTION
#define FUNCTION "OOO_Engine_Glue::transition"
  void OOO_Engine_Glue::transition (void)
  {
    log_begin(OOO_Engine_Glue,FUNCTION);

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {
        uint32_t x=0;
        for (uint32_t i=0; i<_param->_nb_rename_unit; ++i)
          for (uint32_t j=0; j<_param->_nb_inst_insert[i]; ++j)
            {
              if (PORT_READ(in_INSERT_RENAME_UNIT_VAL [i][j]))
                {
                  if (PORT_READ(in_INSERT_ACK [x]) == 0)
                    (*_stat_nb_inst_issue_stall_by_registerfile) ++;
                  if (PORT_READ(in_INSERT_COMMIT_UNIT_ACK [i][j]) == 0)
                    (*_stat_nb_inst_issue_stall_by_commit_unit ) ++;
                  if (PORT_READ(in_INSERT_ISSUE_QUEUE_ACK [i][j]) == 0)
                    (*_stat_nb_inst_issue_stall_by_issue_queue ) ++;
                }
              x++;
            }
      }
#endif

#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
    end_cycle ();
#endif

    log_end(OOO_Engine_Glue,FUNCTION);
  };

}; // end namespace ooo_engine_glue
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
