/*
 * $Id: Special_Register_unit.cpp 131 2009-07-08 18:40:08Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Special_Register_unit/include/Special_Register_unit.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace special_register_unit {


#undef  FUNCTION
#define FUNCTION "Special_Register_unit::Special_Register_unit"
  Special_Register_unit::Special_Register_unit 
  (
#ifdef SYSTEMC
   sc_module_name name,
#else
   string name,
#endif
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   morpheo::behavioural::core::multi_ooo_engine::ooo_engine::special_register_unit::Parameters * param,
   morpheo::behavioural::Tusage_t usage
   ):
    _name              (name)
    ,_param            (param)
    ,_usage            (usage)
  {
    log_begin(Special_Register_unit,FUNCTION);

    usage_environment(_usage);

// #if DEBUG_Core == true
//     log_printf(INFO,Core,FUNCTION,_("<%s> Parameters"),_name.c_str());

//     std::cout << *param << std::endl;
// #endif    

    log_printf(INFO,Special_Register_unit,FUNCTION,_("<%s> : Allocation"),_name.c_str());

    allocation (
#ifdef STATISTICS
		param_statistics
#endif
		);

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {	
	log_printf(INFO,Special_Register_unit,FUNCTION,_("<%s> : Allocation of statistics"),_name.c_str());

	statistics_allocation(param_statistics);
      }
#endif

#ifdef VHDL
    if (usage_is_set(_usage,USE_VHDL))
      {
	// generate the vhdl
	log_printf(INFO,Special_Register_unit,FUNCTION,_("<%s> : Generate the vhdl"),_name.c_str());
	
	vhdl();
      }
#endif

#ifdef SYSTEMC
    if (usage_is_set(_usage,USE_SYSTEMC))
      {
#ifdef SYSTEMCASS_SPECIFIC
        constant();
#else
	log_printf(INFO,Special_Register_unit,FUNCTION,_("<%s> : Method - constant"),_name.c_str());

	SC_METHOD (constant);
// 	dont_initialize ();
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    
#endif

	log_printf(INFO,Special_Register_unit,FUNCTION,_("<%s> : Method - transition"),_name.c_str());

	SC_METHOD (transition);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).pos();
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    

	log_printf(INFO,Special_Register_unit,FUNCTION,_("<%s> : Method - genMoore"),_name.c_str());

	SC_METHOD (genMoore);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).neg(); // need internal register
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    

	log_printf(INFO,Special_Register_unit,FUNCTION,_("<%s> : Method - genMealy_spr_access"),_name.c_str());

	SC_METHOD (genMealy_spr_access);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).neg(); // need internal register
	
	for (uint32_t i=0; i<_param->_nb_inst_reexecute; i++)
	  {
	    sensitive << (*(in_SPR_ACCESS_NUM_GROUP    [i]))
		      << (*(in_SPR_ACCESS_NUM_REG      [i]))
// 		      << (*(in_SPR_ACCESS_VAL          [i]))
// 		      << (*(in_SPR_ACCESS_WEN          [i]))
	      ;
	    if (_param->_have_port_front_end_id)
	    sensitive << (*(in_SPR_ACCESS_FRONT_END_ID [i]));
	    if (_param->_have_port_context_id)
	    sensitive << (*(in_SPR_ACCESS_CONTEXT_ID   [i]));
	  }


# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    
	
#endif
      }
    log_end(Special_Register_unit,FUNCTION);
  };
    
#undef  FUNCTION
#define FUNCTION "Special_Register_unit::~Special_Register_unit"
  Special_Register_unit::~Special_Register_unit (void)
  {
    log_begin(Special_Register_unit,FUNCTION);

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {
	statistics_deallocation();
      }
#endif

    log_printf(INFO,Special_Register_unit,FUNCTION,_("<%s> : Deallocation"),_name.c_str());
    deallocation ();

    log_end(Special_Register_unit,FUNCTION);
  };

}; // end namespace special_register_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
