#ifndef morpheo_behavioural_generic_queue_Parameters_h
#define morpheo_behavioural_generic_queue_Parameters_h

/*
 * $Id: Parameters.h 101 2009-01-15 17:19:08Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Common/include/Debug.h"
#include "Behavioural/include/Parameters.h"
#include <math.h>

namespace morpheo {
namespace behavioural {
namespace generic {
namespace queue {


  class Parameters : public morpheo::behavioural::Parameters
  {
    //-----[ fields ]------------------------------------------------------------
  public : const uint32_t _size_queue         ;
  public : const uint32_t _size_data          ;
  public : const uint32_t _nb_port_slot       ;
  public : const bool     _have_port_ptr_write;
  public : const bool     _have_port_ptr_read ;

  public : const uint32_t _size_ptr           ;
  public : const bool     _have_port_ptr      ;

    //-----[ methods ]-----------------------------------------------------------
  public : Parameters  (uint32_t size_queue         ,
			uint32_t size_data          ,
                        uint32_t nb_port_slot       ,
                        bool     have_port_ptr_write,
                        bool     have_port_ptr_read );

//   public : Parameters  (Parameters & param) ;
  public : ~Parameters () ;

  public :        void            copy       (void);

  public :        Parameters_test msg_error  (void);

  public :        std::string   print      (uint32_t depth);
  public : friend std::ostream& operator<< (std::ostream& output_stream,
					    morpheo::behavioural::generic::queue::Parameters & x);
  };

}; // end namespace queue
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
