#ifdef SYSTEMC
//#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
/*
 * $Id: RegisterFile_Multi_Banked_transition.cpp 128 2009-06-26 08:43:23Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/RegisterFile/RegisterFile_Multi_Banked/include/RegisterFile_Multi_Banked.h"

namespace morpheo                    {
namespace behavioural {
namespace generic {
namespace registerfile {
namespace registerfile_multi_banked {

#undef  FUNCTION
#define FUNCTION "RegisterFile_Multi_Banked::transition"
  void RegisterFile_Multi_Banked::transition (void)
  {
    log_begin(RegisterFile_Multi_Banked,FUNCTION);
    log_function(RegisterFile_Multi_Banked,FUNCTION,_name.c_str());
    
    // call function pointer
//     (this->*function_transition) ();
    if (PORT_READ(in_NRESET) == 0)
      {
        if (_param->_have_init_value)
          {
            for (uint32_t i=0; i<_param->_nb_bank; ++i)
              for (uint32_t j=0; j<_param->_nb_word; ++j)
                reg_DATA[i][j] = fromString<Tdata_t>(_param->_init_value);
          }
        else
          {
            for (uint32_t i=0; i<_param->_nb_bank; ++i)
              for (uint32_t j=0; j<_param->_nb_word; ++j)
                reg_DATA[i][j] = 0;
          }
      }
    else
      {
        for (uint32_t i=0; i<_param->_nb_port_write; i++)
          {
            if (internal_WRITE_VAL [i] == 1)
              {
                Tdata_t data = PORT_READ(in_WRITE_DATA   [i]);
                
                // Write in registerFile
                reg_DATA[internal_WRITE_BANK[i]][internal_WRITE_NUM_REG[i]] = data;
              }
          }
      }

#if defined(DEBUG_RegisterFile_Multi_Banked) and DEBUG_RegisterFile_Multi_Banked and (DEBUG >= DEBUG_TRACE)
    if (0)
    {
      log_printf(TRACE,RegisterFile,FUNCTION,"  * Dump RegisterFile");

      uint32_t limit = 4;
      
      for (uint32_t i=0; i<_param->_nb_bank; i++)
        {
          
          log_printf(TRACE,RegisterFile,FUNCTION,"  Bank %d",i);

          for (uint32_t j=0; j<_param->_nb_word_by_bank; j+=limit)
            {
              std::string str = "";
              
              for (uint32_t k=0; k<limit; k++)
                {
                  uint32_t index = j+k;
                  if (index >= _param->_nb_word)
                    break;
                  else
                    str+=toString("[%.4d] %.8x ",index,reg_DATA[i][index]);
                }
              
              log_printf(TRACE,RegisterFile,FUNCTION,"  %s",str.c_str());
            }
        }
    }
#endif

#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
    end_cycle();
#endif

    log_end(RegisterFile_Multi_Banked,FUNCTION);
  };

}; // end namespace registerfile_multi_banked
}; // end namespace registerfile
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
//#endif
