#include "Behavioural/include/SPR_access_mode.h"

namespace morpheo {
namespace behavioural {

  SPR_access_mode::SPR_access_mode()
  {
    
    _max_register_by_group = new uint32_t [NB_GROUP];

    _spr_generic = new spr_access_mode_t * [NB_GROUP];

    for (uint32_t i=0; i<NB_GROUP; i++)
      {
	_spr_generic [i] = NULL;
	_max_register_by_group [i] = 0;
      }
  }

  SPR_access_mode::~SPR_access_mode()
  {
    for (uint32_t i=0; i<NB_GROUP; i++)
      if (_spr_generic [i] != NULL)
        delete [] _spr_generic [i];

    delete [] _spr_generic;

    delete [] _max_register_by_group;
  }

}; // end namespace behavioural
}; // end namespace morpheo              
