#ifdef VHDL

/*
 * $Id: Vhdl_set_constant.cpp 113 2009-04-14 18:39:12Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/include/Vhdl.h"

#include <sstream>

namespace morpheo              {
namespace behavioural          {
  
#undef  FUNCTION
#define FUNCTION "Vhdl::set_constant"
  void Vhdl::set_constant (std::string      name     ,
			   std::string      type     ,
			   std::string      init)
  {
    log_printf(FUNC,Behavioural,FUNCTION,"Begin");

    test_architecture();
    
    set_list(_architecture[_name_architecture]._list_type, "constant "+ name+"\t: "+type+"\t:= "+init);
    
    log_printf(FUNC,Behavioural,FUNCTION,"End");
  };

  void Vhdl::set_constant (std::string      name     ,
			   uint32_t         size     ,
			   std::string      init)
  {
    log_printf(FUNC,Behavioural,FUNCTION,"Begin");
    set_constant(name,std_logic(size),init);
    log_printf(FUNC,Behavioural,FUNCTION,"End");
  };

  void Vhdl::set_constant (std::string name     ,
			   uint32_t    size     ,
			   uint32_t    init)
  {
    log_printf(FUNC,Behavioural,FUNCTION,"Begin");
    set_constant(name,std_logic(size),std_logic_cst(size,init));
    log_printf(FUNC,Behavioural,FUNCTION,"End");
  };
  
}; // end namespace behavioural          
}; // end namespace morpheo              

#endif
