/*
 * Test_008
 *
 * end_ko : infinite_loop
 * end_ok : Write in R1 the stop address and stop an data
 *          The store in the destination of an jump
 * start  : write an value in special register (epcr), and read this special register
 */
	
	.file	"crt0.s"
	/*
	.section .vector
	*/
	.section .text
	.align	4	

/* ---[ 0x0  : Print a error ]------------------------------------------- */

	.org 0x0
_end_ko        :        
	l.movhi r1,     hi(_tty)
	l.ori   r1, r1, lo(_tty)
        l.sw    4(r1), r1 /* stop address */
_infinite_loop :        
        l.j	_infinite_loop
        l.nop

_end_ok :
	l.movhi r1,     hi(_tty)
	l.ori   r1, r1, lo(_tty)
        l.sw    4(r1), r0 /* stop address */


/* ---[ 0x100: RESET exception ]----------------------------------------- */
        .org 0x100
	.global _start
_start:
        /* r1 : data */
	l.movhi r1,     hi(0xdeadbeef)
	l.ori   r1, r1, lo(0xdeadbeef)
        /* EPCR <- r1 */
        l.mtspr r0, r1, 32
        /* r2 <- EPCR */
        l.mfspr r2, r0, 32
        /* test if two register is same */
        l.sfeq  r2, r1
        l.bnf   _end_ko
        l.nop
        l.j     _end_ok
        l.nop

