/*
 * $Id: Write_queue.cpp 118 2009-05-20 22:01:32Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Write_unit/Write_unit/Write_queue/include/Write_queue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_write_unit {
namespace write_unit {
namespace write_queue {


#undef  FUNCTION
#define FUNCTION "Write_queue::Write_queue"
  Write_queue::Write_queue 
  (
#ifdef SYSTEMC
   sc_module_name name,
#else
   string name,
#endif
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_write_unit::write_unit::write_queue::Parameters * param,
   morpheo::behavioural::Tusage_t usage
   ):
    _name              (name)
    ,_param            (param)
    ,_usage            (usage)
  {
    log_begin(Write_queue,FUNCTION);

// #if DEBUG_Write_queue == true
//     log_printf(INFO,Write_queue,FUNCTION,_("<%s> Parameters"),_name.c_str());

//     std::cout << *param << std::endl;
// #endif    

    log_printf(INFO,Write_queue,FUNCTION,_("<%s> Allocation"),_name.c_str());
    allocation ();

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {	
	log_printf(INFO,Write_queue,FUNCTION,_("<%s> Allocation of statistics"),_name.c_str());

	statistics_declaration(param_statistics);
      }
#endif

#ifdef VHDL
    if (usage_is_set(_usage,USE_VHDL))
      {
	// generate the vhdl
	log_printf(INFO,Write_queue,FUNCTION,_("<%s> Generate the vhdl"),_name.c_str());
	
	vhdl();
      }
#endif

#ifdef SYSTEMC
    if (usage_is_set(_usage,USE_SYSTEMC))
      {
	log_printf(INFO,Write_queue,FUNCTION,_("<%s> Method - transition"),_name.c_str());

	SC_METHOD (transition);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).pos();
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    

	log_printf(INFO,Write_queue,FUNCTION,_("<%s> Method - genMoore"),_name.c_str());

	SC_METHOD (genMoore);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).neg(); // need internal register
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    

	if (_param->_queue_scheme == WRITE_QUEUE_SCHEME_MEALY)
	  {
	log_printf(INFO,Write_queue,FUNCTION,"Method - genMealy_write");

	SC_METHOD (genMealy_write);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).neg(); // need internal register
	for (uint32_t i=0; i<_param->_nb_gpr_write; ++i)
	  sensitive << (*(in_GPR_WRITE_ACK [i]));
	for (uint32_t i=0; i<_param->_nb_spr_write; ++i)
	  sensitive << (*(in_SPR_WRITE_ACK [i]));	

# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    
	  }

        if ((_param->_bypass_write_scheme == BYPASS_WRITE_FROM_ALU) and
            (_param->_nb_bypass_write > 0))
          {
	log_printf(INFO,Write_queue,FUNCTION,"Method - genMealy_bypass");

	SC_METHOD (genMealy_bypass);
	dont_initialize ();
// 	sensitive << (*(in_CLOCK)).neg(); // don't need internal register
        sensitive << (*(in_WRITE_QUEUE_IN_VAL          ))
                  << (*(in_WRITE_QUEUE_IN_WRITE_RD     ))
                  << (*(in_WRITE_QUEUE_IN_NUM_REG_RD   ))
                  << (*(in_WRITE_QUEUE_IN_DATA_RD      ))
                  << (*(in_WRITE_QUEUE_IN_WRITE_RE     ))
                  << (*(in_WRITE_QUEUE_IN_NUM_REG_RE   ))
                  << (*(in_WRITE_QUEUE_IN_DATA_RE      ));
        if (_param->_have_port_ooo_engine_id)
        sensitive << (*(in_WRITE_QUEUE_IN_OOO_ENGINE_ID));


# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    
          }

#endif
      }
    log_end(Write_queue,FUNCTION);
  };
    
#undef  FUNCTION
#define FUNCTION "Write_queue::~Write_queue"
  Write_queue::~Write_queue (void)
  {
    log_begin(Write_queue,FUNCTION);

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {
	log_printf(INFO,Write_queue,FUNCTION,_("<%s> Generate Statistics file"),_name.c_str());
	
	delete _stat;
      }
#endif

    log_printf(INFO,Write_queue,FUNCTION,_("<%s> Deallocation"),_name.c_str());
    deallocation ();

    log_end(Write_queue,FUNCTION);
  };

}; // end namespace write_queue
}; // end namespace write_unit
}; // end namespace multi_write_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
