/*
 * $Id: main.cpp 111 2009-02-27 18:37:40Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Direction/Meta_Predictor/Meta_Predictor_Glue/SelfTest/include/test.h"
#include "Behavioural/include/Selftest.h"

#define NB_PARAMS 3

void usage (int argc, char * argv[])
{
  err (_("<Usage> %s name_instance list_params.\n"),argv[0]);
  err (_("list_params is :\n"));
  err (_(" * nb_inst_predict                               (uint32_t)\n"));
  err (_(" * nb_inst_update                                (uint32_t)\n"));
  err (_(" * nb_predictor                                  (uint32_t)\n"));
  err (_(" * predictor_size_history         [nb_predictor] (uint32_t)\n"));
  err (_(" * predictor_update_on_prediction [nb_predictor] (bool    )\n"));

  exit (1);
}

#ifndef SYSTEMC
int main    (int argc, char * argv[])
#else
int sc_main (int argc, char * argv[])
#endif
{
  if (argc <= static_cast<int>(2+NB_PARAMS))
    usage (argc, argv);

  uint32_t x = 1;

  string name = argv[x++];

  uint32_t   _nb_inst_predict               ;
  uint32_t   _nb_inst_update                ;
  uint32_t   _nb_predictor                  ;
  uint32_t * _predictor_size_history        ;//[nb_predictor]
  bool     * _predictor_update_on_prediction;//[nb_predictor]

  SELFTEST0(_nb_inst_predict               ,uint32_t,argv,x);
  SELFTEST0(_nb_inst_update                ,uint32_t,argv,x);
  SELFTEST0(_nb_predictor                  ,uint32_t,argv,x);

  if (argc != static_cast<int>(2+NB_PARAMS+2*_nb_predictor))
    usage (argc, argv);

  SELFTEST1(_predictor_size_history        ,uint32_t,argv,x,_nb_predictor);
  SELFTEST1(_predictor_update_on_prediction,bool    ,argv,x,_nb_predictor);
 
  int _return = EXIT_SUCCESS;
  try 
    {
      morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::direction::meta_predictor::meta_predictor_glue::Parameters * param = new morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::direction::meta_predictor::meta_predictor_glue::Parameters
	(
         _nb_inst_predict               ,
         _nb_inst_update                ,
         _nb_predictor                  ,
         _predictor_size_history        ,
         _predictor_update_on_prediction,
         true //is_toplevel
        );
      
      msg(_("%s"),param->print(0).c_str());
      
      test (name,param);
    }
  catch (morpheo::ErrorMorpheo & error)
    {
      msg (_("<%s> :\n%s"),name.c_str(), error.what ());
      _return = EXIT_FAILURE;
    }
  
  try 
    {
      if (_return == EXIT_SUCCESS)
	TEST_OK("Meta_Predictor_Glue : no error");
      else
	TEST_KO("Meta_Predictor_Glue : a lot of error");
    }
  catch (morpheo::ErrorMorpheo & error)
    {
//       msg (_("<%s> :\n%s"),name.c_str(), error.what ());
      _return = EXIT_FAILURE;
    }

  DELETE1(_predictor_update_on_prediction,_param->_nb_predictor);
  DELETE1(_predictor_size_history        ,_param->_nb_predictor);

  return (_return);
}
