/*
 * $Id: Load_Store_pointer_unit.cpp 131 2009-07-08 18:40:08Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Load_Store_pointer_unit/include/Load_Store_pointer_unit.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace rename_unit {
namespace load_store_pointer_unit {


#undef  FUNCTION
#define FUNCTION "Load_Store_pointer_unit::Load_Store_pointer_unit"
  Load_Store_pointer_unit::Load_Store_pointer_unit 
  (
#ifdef SYSTEMC
   sc_module_name name,
#else
   string name,
#endif
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   morpheo::behavioural::core::multi_ooo_engine::ooo_engine::rename_unit::load_store_pointer_unit::Parameters * param,
   morpheo::behavioural::Tusage_t usage
   ):
    _name              (name)
    ,_param            (param)
    ,_usage            (usage)
  {
    log_printf(FUNC,Load_Store_pointer_unit,FUNCTION,"Begin");

// #if DEBUG_Load_Store_pointer_unit == true
//     log_printf(INFO,Load_Store_pointer_unit,FUNCTION,_("<%s> Parameters"),_name.c_str());

//     std::cout << *param << std::endl;
// #endif    

    log_printf(INFO,Load_Store_pointer_unit,FUNCTION,"Allocation");

    allocation (
#ifdef STATISTICS
		param_statistics
#endif
		);

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {	
	log_printf(INFO,Load_Store_pointer_unit,FUNCTION,"Allocation of statistics");

	statistics_declaration(param_statistics);
      }
#endif

#ifdef VHDL
    if (usage_is_set(_usage,USE_VHDL))
      {
	// generate the vhdl
	log_printf(INFO,Load_Store_pointer_unit,FUNCTION,"Generate the vhdl");
	
	vhdl();
      }
#endif

#ifdef SYSTEMC
    if (usage_is_set(_usage,USE_SYSTEMC))
      {
#ifdef SYSTEMCASS_SPECIFIC
        constant();
#else
	log_printf(INFO,Load_Store_pointer_unit,FUNCTION,"Method - constant");

	SC_METHOD (constant);
// 	dont_initialize ();
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    
#endif

	log_printf(INFO,Load_Store_pointer_unit,FUNCTION,"Method - transition");

	SC_METHOD (transition);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).pos();
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    

	log_printf(INFO,Load_Store_pointer_unit,FUNCTION,"Method - genMealy_insert");

	SC_METHOD (genMealy_insert);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).neg();
	for (uint32_t i=0; i<_param->_nb_inst_insert; i++)
	  {
	    if (_param->_have_port_front_end_id)
	    sensitive << (*(in_INSERT_FRONT_END_ID [i]));
	    if (_param->_have_port_context_id)
	    sensitive << (*(in_INSERT_CONTEXT_ID   [i]));
	    sensitive << (*(in_INSERT_VAL          [i]))
		      << (*(in_INSERT_TYPE         [i]))
		      << (*(in_INSERT_OPERATION    [i]));
	  }

# ifdef SYSTEMCASS_SPECIFIC
// 	// List dependency information
// 	for (uint32_t i=0; i<_param->_nb_inst_insert; i++)
// 	  {
// 	    (*(out_INSERT_ACK                   [i])) (*( in_INSERT_VAL                   [i]));
// 	    if (_param->_have_port_front_end_id)
// 	    (*(out_INSERT_ACK                   [i])) (*( in_INSERT_FRONT_END_ID          [i]));
// 	    if (_param->_have_port_context_id)
// 	    (*(out_INSERT_ACK                   [i])) (*( in_INSERT_CONTEXT_ID            [i]));
// 	    (*(out_INSERT_ACK                   [i])) (*( in_INSERT_TYPE                  [i]));
// 	    (*(out_INSERT_ACK                   [i])) (*( in_INSERT_OPERATION             [i]));
  
// 	    (*(out_INSERT_STORE_QUEUE_PTR_WRITE [i])) (*( in_INSERT_VAL                   [i]));
// 	    if (_param->_have_port_front_end_id)
// 	    (*(out_INSERT_STORE_QUEUE_PTR_WRITE [i])) (*( in_INSERT_FRONT_END_ID          [i]));
// 	    if (_param->_have_port_context_id)
// 	    (*(out_INSERT_STORE_QUEUE_PTR_WRITE [i])) (*( in_INSERT_CONTEXT_ID            [i]));
// 	    (*(out_INSERT_STORE_QUEUE_PTR_WRITE [i])) (*( in_INSERT_TYPE                  [i]));
// 	    (*(out_INSERT_STORE_QUEUE_PTR_WRITE [i])) (*( in_INSERT_OPERATION             [i]));
  
// 	    if (_param->_have_port_load_queue_ptr)
// 	      {
// 	    (*(out_INSERT_LOAD_QUEUE_PTR_WRITE  [i])) (*( in_INSERT_VAL                   [i]));
// 	    if (_param->_have_port_front_end_id)
// 	    (*(out_INSERT_LOAD_QUEUE_PTR_WRITE  [i])) (*( in_INSERT_FRONT_END_ID          [i]));
// 	    if (_param->_have_port_context_id)
// 	    (*(out_INSERT_LOAD_QUEUE_PTR_WRITE  [i])) (*( in_INSERT_CONTEXT_ID            [i]));
// 	    (*(out_INSERT_LOAD_QUEUE_PTR_WRITE  [i])) (*( in_INSERT_TYPE                  [i]));
// 	    (*(out_INSERT_LOAD_QUEUE_PTR_WRITE  [i])) (*( in_INSERT_OPERATION             [i]));
// 	      }
// 	  }
# endif

	log_printf(INFO,Load_Store_pointer_unit,FUNCTION,"Method - genMealy_retire");

	SC_METHOD (genMealy_retire);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).neg();
	for (uint32_t i=0; i<_param->_nb_inst_retire; i++)
	  {
	    if (_param->_have_port_front_end_id)
	    sensitive << (*(in_RETIRE_FRONT_END_ID          [i]));
	    if (_param->_have_port_context_id)
	    sensitive << (*(in_RETIRE_CONTEXT_ID            [i]));
	    if (_param->_have_port_load_queue_ptr)
	    sensitive << (*(in_RETIRE_LOAD_QUEUE_PTR_WRITE  [i]));
	    sensitive << (*(in_RETIRE_VAL                   [i]))
// 		      << (*(in_RETIRE_TYPE                  [i]))
// 		      << (*(in_RETIRE_OPERATION             [i]))
 		      << (*(in_RETIRE_USE_STORE_QUEUE       [i]))
 		      << (*(in_RETIRE_USE_LOAD_QUEUE        [i]))
		      << (*(in_RETIRE_STORE_QUEUE_PTR_WRITE [i]));;
	  }

# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
	for (uint32_t i=0; i<_param->_nb_inst_retire; i++)
	  {
	    (*(out_RETIRE_ACK                   [i])) (*( in_RETIRE_VAL                   [i]));
	    if (_param->_have_port_front_end_id)
	    (*(out_RETIRE_ACK                   [i])) (*( in_RETIRE_FRONT_END_ID          [i]));
	    if (_param->_have_port_context_id)
	    (*(out_RETIRE_ACK                   [i])) (*( in_RETIRE_CONTEXT_ID            [i]));
// 	    (*(out_RETIRE_ACK                   [i])) (*( in_RETIRE_TYPE                  [i]));
// 	    (*(out_RETIRE_ACK                   [i])) (*( in_RETIRE_OPERATION             [i]));
	    (*(out_RETIRE_ACK                   [i])) (*( in_RETIRE_USE_STORE_QUEUE       [i]));
	    (*(out_RETIRE_ACK                   [i])) (*( in_RETIRE_USE_LOAD_QUEUE        [i]));
  	    if (_param->_have_port_load_queue_ptr)
	    (*(out_RETIRE_ACK                   [i])) (*( in_RETIRE_LOAD_QUEUE_PTR_WRITE  [i]));
	    (*(out_RETIRE_ACK                   [i])) (*( in_RETIRE_STORE_QUEUE_PTR_WRITE [i]));
	  }
# endif

#endif
      }
    log_printf(FUNC,Load_Store_pointer_unit,FUNCTION,"End");
  };
    
#undef  FUNCTION
#define FUNCTION "Load_Store_pointer_unit::~Load_Store_pointer_unit"
  Load_Store_pointer_unit::~Load_Store_pointer_unit (void)
  {
    log_printf(FUNC,Load_Store_pointer_unit,FUNCTION,"Begin");

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {
	log_printf(INFO,Load_Store_pointer_unit,FUNCTION,"Generate Statistics file");
	
	delete _stat;
      }
#endif

    log_printf(INFO,Load_Store_pointer_unit,FUNCTION,"Deallocation");
    deallocation ();

    log_printf(FUNC,Load_Store_pointer_unit,FUNCTION,"End");
  };

}; // end namespace load_store_pointer_unit
}; // end namespace rename_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
