#ifndef morpheo_behavioural_core_multi_front_end_front_end_prediction_unit_prediction_unit_glue_Prediction_unit_Glue_h
#define morpheo_behavioural_core_multi_front_end_front_end_prediction_unit_prediction_unit_glue_Prediction_unit_Glue_h

/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#ifdef SYSTEMC
#include "systemc.h"
#endif

#include <iostream>
#include "Common/include/ToString.h"
#include "Common/include/Debug.h"

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Prediction_unit_Glue/include/Types.h"
#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Prediction_unit_Glue/include/Parameters.h"
#ifdef STATISTICS
#include "Behavioural/include/Stat.h"
#endif
#include "Behavioural/include/Component.h"
#ifdef VHDL
#include "Behavioural/include/Vhdl.h"
#endif
#include "Behavioural/include/Usage.h"

namespace morpheo {
namespace behavioural {

namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace prediction_unit_glue {


  class Prediction_unit_Glue 
#if SYSTEMC
    : public sc_module
#endif
  {
    // -----[ fields ]----------------------------------------------------
    // Parameters
  protected : const std::string  _name;
  protected : const Parameters * _param;
  private   : const Tusage_t     _usage;

#ifdef STATISTICS
  public    : Stat                           * _stat;
#endif

  public    : Component                      * _component;
  private   : Interfaces                     * _interfaces;

#ifdef SYSTEMC
    // ~~~~~[ Interface ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_CLOCK                      *  in_CLOCK        ;
  public    : SC_IN (Tcontrol_t)            *  in_NRESET       ;

    // ~~~~~[ Interface : "predict" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t         )  **  in_PREDICT_VAL                         ; //[nb_context]
  public    : SC_OUT(Tcontrol_t         )  ** out_PREDICT_ACK                         ; //[nb_context]
  public    : SC_IN (Taddress_t         )  **  in_PREDICT_PC_PREVIOUS                 ; //[nb_context]
  public    : SC_IN (Taddress_t         )  **  in_PREDICT_PC_CURRENT                  ; //[nb_context]
  public    : SC_IN (Tcontrol_t         )  **  in_PREDICT_PC_CURRENT_IS_DS_TAKE       ; //[nb_context]
  public    : SC_OUT(Taddress_t         )  ** out_PREDICT_PC_NEXT                     ; //[nb_context]
  public    : SC_OUT(Tcontrol_t         )  ** out_PREDICT_PC_NEXT_IS_DS_TAKE          ; //[nb_context]
  public    : SC_OUT(Tcontrol_t         ) *** out_PREDICT_INSTRUCTION_ENABLE          ; //[nb_context][nb_instruction]
  public    : SC_OUT(Tinst_ifetch_ptr_t )  ** out_PREDICT_INST_IFETCH_PTR             ; //[nb_context]
  public    : SC_OUT(Tbranch_state_t    )  ** out_PREDICT_BRANCH_STATE                ; //[nb_context]
  public    : SC_OUT(Tprediction_ptr_t  )  ** out_PREDICT_BRANCH_UPDATE_PREDICTION_ID ; //[nb_context]

  public    : SC_OUT(Tcontrol_t         )  ** out_PREDICT_BTB_VAL                     ; //[nb_inst_branch_predict] 
  public    : SC_IN (Tcontrol_t         )  **  in_PREDICT_BTB_ACK                     ; //[nb_inst_branch_predict] 
  public    : SC_OUT(Tcontext_t         )  ** out_PREDICT_BTB_CONTEXT_ID              ; //[nb_inst_branch_predict]
  public    : SC_OUT(Taddress_t         )  ** out_PREDICT_BTB_ADDRESS                 ; //[nb_inst_branch_predict]
  public    : SC_IN (Tcontrol_t         )  **  in_PREDICT_BTB_HIT                     ; //[nb_inst_branch_predict] 
  public    : SC_IN (Taddress_t         )  **  in_PREDICT_BTB_ADDRESS_SRC             ; //[nb_inst_branch_predict] 
  public    : SC_IN (Taddress_t         )  **  in_PREDICT_BTB_ADDRESS_DEST            ; //[nb_inst_branch_predict] 
  public    : SC_IN (Tbranch_condition_t)  **  in_PREDICT_BTB_CONDITION               ; //[nb_inst_branch_predict] 
//public    : SC_IN (Tcontrol_t         )  **  in_PREDICT_BTB_LAST_TAKE               ; //[nb_inst_branch_predict]  DIR.LAST_TAKE
  public    : SC_IN (Tcontrol_t         )  **  in_PREDICT_BTB_IS_ACCURATE             ; //[nb_inst_branch_predict]
										      		        
  public    : SC_OUT(Tcontrol_t         )  ** out_PREDICT_DIR_VAL                     ; //[nb_inst_branch_predict] 
  public    : SC_IN (Tcontrol_t         )  **  in_PREDICT_DIR_ACK                     ; //[nb_inst_branch_predict] 
  public    : SC_OUT(Taddress_t         )  ** out_PREDICT_DIR_ADDRESS_SRC             ; //[nb_inst_branch_predict] 
  public    : SC_OUT(Tcontrol_t         )  ** out_PREDICT_DIR_STATIC                  ; //[nb_inst_branch_predict] 
//public    : SC_OUT(Tcontrol_t         )  ** out_PREDICT_DIR_LAST_TAKE               ; //[nb_inst_branch_predict]  BTB.LAST_TAKE
//public    : SC_IN (Thistory_t         )  **  in_PREDICT_DIR_HISTORY                 ; //[nb_inst_branch_predict]  UPT.DIR_HISTORY
  public    : SC_IN (Tcontrol_t         )  **  in_PREDICT_DIR_DIRECTION               ; //[nb_inst_branch_predict] 

  public    : SC_OUT(Tcontrol_t         )  ** out_PREDICT_RAS_VAL                     ; //[nb_inst_branch_predict] 
  public    : SC_IN (Tcontrol_t         )  **  in_PREDICT_RAS_ACK                     ; //[nb_inst_branch_predict] 
  public    : SC_OUT(Tcontext_t         )  ** out_PREDICT_RAS_CONTEXT_ID              ; //[nb_inst_branch_predict]
  public    : SC_IN (Tcontrol_t         )  **  in_PREDICT_RAS_HIT                     ; //[nb_inst_branch_predict]  
  public    : SC_OUT(Tcontrol_t         )  ** out_PREDICT_RAS_PUSH                    ; //[nb_inst_branch_predict] 
  public    : SC_OUT(Taddress_t         )  ** out_PREDICT_RAS_ADDRESS_PUSH            ; //[nb_inst_branch_predict] 
  public    : SC_IN (Taddress_t         )  **  in_PREDICT_RAS_ADDRESS_POP             ; //[nb_inst_branch_predict] 
//public    : SC_IN (Tptr_t             )  **  in_PREDICT_RAS_INDEX                   ; //[nb_inst_branch_predict]  UPT.RAS_INDEX
										      		        
  public    : SC_OUT(Tcontrol_t         )  ** out_PREDICT_UPT_VAL                     ; //[nb_inst_branch_predict] 
  public    : SC_IN (Tcontrol_t         )  **  in_PREDICT_UPT_ACK                     ; //[nb_inst_branch_predict] 
  public    : SC_OUT(Tcontext_t         )  ** out_PREDICT_UPT_CONTEXT_ID              ; //[nb_inst_branch_predict]
  public    : SC_IN (Tprediction_ptr_t  )  **  in_PREDICT_UPT_BRANCH_UPDATE_PREDICTION_ID; //[nb_inst_branch_predict]

  public    : SC_OUT(Taddress_t         )  ** out_PREDICT_UPT_BTB_ADDRESS_SRC         ; //[nb_inst_branch_predict]* BTB.ADDRESS_SRC
  public    : SC_OUT(Taddress_t         )  ** out_PREDICT_UPT_BTB_ADDRESS_DEST        ; //[nb_inst_branch_predict] 
  public    : SC_OUT(Tbranch_condition_t)  ** out_PREDICT_UPT_BTB_CONDITION           ; //[nb_inst_branch_predict]* BTB.CONDITION
  public    : SC_OUT(Tcontrol_t         )  ** out_PREDICT_UPT_BTB_LAST_TAKE           ; //[nb_inst_branch_predict] 
  public    : SC_OUT(Tcontrol_t         )  ** out_PREDICT_UPT_BTB_IS_ACCURATE         ; //[nb_inst_branch_predict]
//public    : SC_OUT(Thistory_t         )  ** out_PREDICT_UPT_DIR_HISTORY             ; //[nb_inst_branch_predict]  DIR.HISTORY
  public    : SC_OUT(Taddress_t         )  ** out_PREDICT_UPT_RAS_ADDRESS             ; //[nb_inst_branch_predict]* RAS.ADDRESS_POP
//public    : SC_OUT(Tptr_t             )  ** out_PREDICT_UPT_RAS_INDEX               ; //[nb_inst_branch_predict]  RAS.INDEX
										      
    // ~~~~~[ Interface : "decod" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	      
  public    : SC_IN (Tcontrol_t         ) ***  in_DECOD_VAL                           ; //[nb_decod_unit][nb_inst_decod]
  public    : SC_OUT(Tcontrol_t         ) *** out_DECOD_ACK                           ; //[nb_decod_unit][nb_inst_decod]
  public    : SC_IN (Tcontext_t         ) ***  in_DECOD_CONTEXT_ID                    ; //[nb_decod_unit][nb_inst_decod]
  public    : SC_IN (Tcontrol_t         ) ***  in_DECOD_MATCH_INST_IFETCH_PTR         ; //[nb_decod_unit][nb_inst_decod]
  public    : SC_IN (Tbranch_state_t    ) ***  in_DECOD_BRANCH_STATE                  ; //[nb_decod_unit][nb_inst_decod]
  public    : SC_IN (Tprediction_ptr_t  ) ***  in_DECOD_BRANCH_UPDATE_PREDICTION_ID   ; //[nb_decod_unit][nb_inst_decod]
  public    : SC_IN (Tbranch_condition_t) ***  in_DECOD_BRANCH_CONDITION              ; //[nb_decod_unit][nb_inst_decod]
  public    : SC_IN (Tcontrol_t         ) ***  in_DECOD_BRANCH_DIRECTION              ; //[nb_decod_unit][nb_inst_decod]
  public    : SC_IN (Taddress_t         ) ***  in_DECOD_ADDRESS_SRC                   ; //[nb_decod_unit][nb_inst_decod]
  public    : SC_IN (Taddress_t         ) ***  in_DECOD_ADDRESS_DEST                  ; //[nb_decod_unit][nb_inst_decod]
  public    : SC_OUT(Tcontrol_t         ) *** out_DECOD_CAN_CONTINUE                  ; //[nb_decod_unit][nb_inst_decod]

  public    : SC_OUT(Tcontrol_t         )  ** out_DECOD_BTB_VAL                       ; //[nb_inst_branch_decod]
  public    : SC_IN (Tcontrol_t         )  **  in_DECOD_BTB_ACK                       ; //[nb_inst_branch_decod]
  public    : SC_OUT(Tcontext_t         )  ** out_DECOD_BTB_CONTEXT_ID                ; //[nb_inst_branch_decod]
  public    : SC_OUT(Taddress_t         )  ** out_DECOD_BTB_ADDRESS_SRC               ; //[nb_inst_branch_decod]
  public    : SC_OUT(Taddress_t         )  ** out_DECOD_BTB_ADDRESS_DEST              ; //[nb_inst_branch_decod]
  public    : SC_OUT(Tbranch_condition_t)  ** out_DECOD_BTB_CONDITION                 ; //[nb_inst_branch_decod]
  public    : SC_OUT(Tcontrol_t         )  ** out_DECOD_BTB_LAST_TAKE                 ; //[nb_inst_branch_decod]
  public    : SC_OUT(Tcontrol_t         )  ** out_DECOD_BTB_MISS_PREDICTION           ; //[nb_inst_branch_decod]
  public    : SC_OUT(Tcontrol_t         )  ** out_DECOD_BTB_IS_ACCURATE               ; //[nb_inst_branch_decod]
									              
  public    : SC_OUT(Tcontrol_t         )  ** out_DECOD_RAS_VAL                       ; //[nb_inst_branch_decod]
  public    : SC_IN (Tcontrol_t         )  **  in_DECOD_RAS_ACK                       ; //[nb_inst_branch_decod]
  public    : SC_OUT(Tcontext_t         )  ** out_DECOD_RAS_CONTEXT_ID                ; //[nb_inst_branch_decod] 
  public    : SC_IN (Tcontrol_t         )  **  in_DECOD_RAS_HIT                       ; //[nb_inst_branch_decod] 
  public    : SC_OUT(Tcontrol_t         )  ** out_DECOD_RAS_PUSH                      ; //[nb_inst_branch_decod]
  public    : SC_OUT(Taddress_t         )  ** out_DECOD_RAS_ADDRESS_PUSH              ; //[nb_inst_branch_decod]
  public    : SC_IN (Taddress_t         )  **  in_DECOD_RAS_ADDRESS_POP               ; //[nb_inst_branch_decod]
//public    : SC_IN (Tptr_t             )  **  in_DECOD_RAS_INDEX                     ; //[nb_inst_branch_decod] UPT.RAS_INDEX
  public    : SC_OUT(Tcontrol_t         )  ** out_DECOD_RAS_MISS_PREDICTION           ; //[nb_inst_branch_decod]
										      
  public    : SC_OUT(Tcontrol_t         )  ** out_DECOD_UPT_VAL                       ; //[nb_inst_branch_decod]
  public    : SC_IN (Tcontrol_t         )  **  in_DECOD_UPT_ACK                       ; //[nb_inst_branch_decod]
  public    : SC_OUT(Tcontext_t         )  ** out_DECOD_UPT_CONTEXT_ID                ; //[nb_inst_branch_decod]
  public    : SC_OUT(Taddress_t         )  ** out_DECOD_UPT_BTB_ADDRESS_SRC           ; //[nb_inst_branch_decod]
  public    : SC_OUT(Taddress_t         )  ** out_DECOD_UPT_BTB_ADDRESS_DEST          ; //[nb_inst_branch_decod]
  public    : SC_OUT(Tbranch_condition_t)  ** out_DECOD_UPT_BTB_CONDITION             ; //[nb_inst_branch_decod]
  public    : SC_OUT(Tcontrol_t         )  ** out_DECOD_UPT_BTB_LAST_TAKE             ; //[nb_inst_branch_decod]
  public    : SC_OUT(Taddress_t         )  ** out_DECOD_UPT_RAS_ADDRESS               ; //[nb_inst_branch_decod]
//public    : SC_OUT(Tptr_t             )  ** out_DECOD_UPT_RAS_INDEX                 ; //[nb_inst_branch_decod] RAS.INDEX
  public    : SC_OUT(Tcontrol_t         )  ** out_DECOD_UPT_MISS_IFETCH               ; //[nb_inst_branch_decod] 
  public    : SC_OUT(Tcontrol_t         )  ** out_DECOD_UPT_MISS_DECOD                ; //[nb_inst_branch_decod] 
  public    : SC_OUT(Tprediction_ptr_t  )  ** out_DECOD_UPT_UPDATE_PREDICTION_ID      ; //[nb_inst_branch_decod]
  public    : SC_OUT(Tcontrol_t         )  ** out_DECOD_UPT_IS_ACCURATE               ; //[nb_inst_branch_decod] 
  public    : SC_IN (Tcontrol_t         )  **  in_DECOD_UPT_CAN_CONTINUE              ; //[nb_inst_branch_decod] 
										      
    // ~~~~~[ Interface : "update" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	      
  public    : SC_OUT(Tcontrol_t         )  ** out_UPDATE_BTB_VAL                      ; //[nb_inst_branch_update]
  public    : SC_IN (Tcontrol_t         )  **  in_UPDATE_BTB_ACK                      ; //[nb_inst_branch_update]
//public    : SC_OUT(Tcontext_t         )  ** out_UPDATE_BTB_CONTEXT_ID               ; //[nb_inst_branch_update] UPT.CONTEXT_ID
//public    : SC_OUT(Taddress_t         )  ** out_UPDATE_BTB_ADDRESS_SRC              ; //[nb_inst_branch_update] UPT.BTB_ADDRESS_SRC
//public    : SC_OUT(Taddress_t         )  ** out_UPDATE_BTB_ADDRESS_DEST             ; //[nb_inst_branch_update] UPT.BTB_ADDRESS_DEST
//public    : SC_OUT(Tbranch_condition_t)  ** out_UPDATE_BTB_CONDITION                ; //[nb_inst_branch_update]*UPT.BTB_CONDITION
//public    : SC_OUT(Tcontrol_t         )  ** out_UPDATE_BTB_LAST_TAKE                ; //[nb_inst_branch_update] UPT.DIRECTION_GOOD
//public    : SC_OUT(Tcontrol_t         )  ** out_UPDATE_BTB_MISS_PREDICTION          ; //[nb_inst_branch_update] UPT.MISS_PREDICTION
										      
  public    : SC_OUT(Tcontrol_t         )  ** out_UPDATE_DIR_VAL                      ; //[nb_inst_branch_update]
  public    : SC_IN (Tcontrol_t         )  **  in_UPDATE_DIR_ACK                      ; //[nb_inst_branch_update]
//public    : SC_OUT(Taddress_t         )  ** out_UPDATE_DIR_ADDRESS                  ; //[nb_inst_branch_update] UPT.BTB_ADDRESS_SRC
//public    : SC_OUT(Thistory_t         )  ** out_UPDATE_DIR_HISTORY                  ; //[nb_inst_branch_update] UPT.DIR_HISTORY
//public    : SC_OUT(Tcontrol_t         )  ** out_UPDATE_DIR_DIRECTION                ; //[nb_inst_branch_update] UPT.DIRECTION_GOOD
										      
  public    : SC_OUT(Tcontrol_t         )  ** out_UPDATE_RAS_VAL                      ; //[nb_inst_branch_update]
  public    : SC_IN (Tcontrol_t         )  **  in_UPDATE_RAS_ACK                      ; //[nb_inst_branch_update]
//public    : SC_OUT(Tcontext_t         )  ** out_UPDATE_RAS_CONTEXT_ID               ; //[nb_inst_branch_update] UPT.CONTEXT_ID
//public    : SC_OUT(Tcontrol_t         )  ** out_UPDATE_RAS_PUSH                     ; //[nb_inst_branch_update] UPT.RAS_PUSH
//public    : SC_OUT(Taddress_t         )  ** out_UPDATE_RAS_ADDRESS                  ; //[nb_inst_branch_update] UPT.RAS_ADDRESS
//public    : SC_OUT(Tptr_t             )  ** out_UPDATE_RAS_INDEX                    ; //[nb_inst_branch_update] UPT.RAS_INDEX
//public    : SC_OUT(Tcontrol_t         )  ** out_UPDATE_RAS_MISS_PREDICTION          ; //[nb_inst_branch_update] UPT.MISS_PREDICTION
//public    : SC_OUT(Tcontrol_t         )  ** out_UPDATE_RAS_PREDICTION_IFETCH        ; //[nb_inst_branch_update] UPT.RAS_PREDICTION_IFETCH
										      
  public    : SC_IN (Tcontrol_t         )  **  in_UPDATE_UPT_VAL                      ; //[nb_inst_branch_update]
  public    : SC_OUT(Tcontrol_t         )  ** out_UPDATE_UPT_ACK                      ; //[nb_inst_branch_update]
//public    : SC_IN (Tcontext_t         )  **  in_UPDATE_UPT_CONTEXT_ID               ; //[nb_inst_branch_update] BTB.CONTEXT_ID, RAS.CONTEXT_ID
//public    : SC_IN (Tcontrol_t         )  **  in_UPDATE_UPT_MISS_PREDICTION          ; //[nb_inst_branch_update] BTB.MISS_PREDICTION, RAS.MISS_PREDICTION
//public    : SC_IN (Tcontrol_t         )  **  in_UPDATE_UPT_DIRECTION_GOOD           ; //[nb_inst_branch_update] BTB.LAST_TAKE, DIR.DIRECTION
  public    : SC_IN (Tcontrol_t         )  **  in_UPDATE_UPT_BTB_VAL                  ; //[nb_inst_branch_update]
//public    : SC_IN (Taddress_t         )  **  in_UPDATE_UPT_BTB_ADDRESS_SRC          ; //[nb_inst_branch_update] DIR.ADDRESS, BTB.ADDRESS_SRC
//public    : SC_IN (Taddress_t         )  **  in_UPDATE_UPT_BTB_ADDRESS_DEST         ; //[nb_inst_branch_update] BTB.ADDRESS_DEST
//public    : SC_IN (Tbranch_condition_t)  **  in_UPDATE_UPT_BTB_CONDITION            ; //[nb_inst_branch_update]*BTB.CONDITION
  public    : SC_IN (Tcontrol_t         )  **  in_UPDATE_UPT_DIR_VAL                  ; //[nb_inst_branch_update]
//public    : SC_IN (Thistory_t         )  **  in_UPDATE_UPT_DIR_HISTORY              ; //[nb_inst_branch_update] DIR.HISTORY
  public    : SC_IN (Tcontrol_t         )  **  in_UPDATE_UPT_RAS_VAL                  ; //[nb_inst_branch_update]
//public    : SC_IN (Taddress_t         )  **  in_UPDATE_UPT_RAS_ADDRESS              ; //[nb_inst_branch_update] RAS.ADDRESS
//public    : SC_IN (Tcontrol_t         )  **  in_UPDATE_UPT_RAS_PUSH                 ; //[nb_inst_branch_update] RAS.PUSH
//public    : SC_IN (Tptr_t             )  **  in_UPDATE_UPT_RAS_INDEX                ; //[nb_inst_branch_update] RAS.INDEX
//public    : SC_IN (Tcontrol_t         )  **  in_UPDATE_UPT_RAS_PREDICTION_IFETCH    ; //[nb_inst_branch_update] RAS.PREDICTION_IFETCH
										      
//  // ~~~~~[ Interface : "depth" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	      
//public    : SC_IN (Tdepth_t           )  **  in_DEPTH_UPT_NB_BRANCH                 ; //[nb_context]
//public    : SC_IN (Tdepth_t           )  **  in_DEPTH_UPT_TAIL                      ; //[nb_context]
//public    : SC_OUT(Tdepth_t           )  ** out_DEPTH_NB_BRANCH                     ; //[nb_context]
//public    : SC_OUT(Tdepth_t           )  ** out_DEPTH_TAIL                          ; //[nb_context]

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[ Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
  private   : uint32_t                         reg_PREDICT_PRIORITY;
  private   : uint32_t                         reg_DECOD_PRIORITY;

    // ~~~~~[ Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#endif

    // -----[ Methods ]---------------------------------------------------

#ifdef SYSTEMC
    SC_HAS_PROCESS (Prediction_unit_Glue);
#endif
  public  :          Prediction_unit_Glue              
  (
#ifdef SYSTEMC
   sc_module_name                                name,
#else					       
   std::string                                   name,
#endif					       
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   Parameters                                  * param,
   morpheo::behavioural::Tusage_t                usage
   );
  public  :          ~Prediction_unit_Glue             (void);
					       
  private : void        allocation                (
#ifdef STATISTICS
						   morpheo::behavioural::Parameters_Statistics * param_statistics
#else
						   void
#endif
						   );
  private : void        deallocation              (void);
					       
#ifdef SYSTEMC				       
  public  : void        transition                (void);
//public  : void        genMoore                  (void);
  public  : void        genMealy_predict          (void);
  public  : void        genMealy_decod            (void);
  public  : void        genMealy_update           (void);
#endif					       

#if VHDL				       
  public  : void        vhdl                      (void);
  private : void        vhdl_declaration          (Vhdl * & vhdl);
  private : void        vhdl_body                 (Vhdl * & vhdl);
#endif					       

#ifdef STATISTICS
  public  : void        statistics_allocation     (morpheo::behavioural::Parameters_Statistics * param_statistics);
  public  : void        statistics_deallocation   (void);
#endif
#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
  private : void        end_cycle                 (void);
#endif
  };

}; // end namespace prediction_unit_glue
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
