#ifndef morpheo_behavioural_core_multi_ooo_engine_ooo_engine_ooo_engine_glue_Parameters_h
#define morpheo_behavioural_core_multi_ooo_engine_ooo_engine_ooo_engine_glue_Parameters_h

/*
 * $Id: Parameters.h 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/OOO_Engine_Glue/include/Types.h"
#include "Behavioural/include/Parameters.h"
#include "Common/include/Debug.h"
#include <vector>

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace ooo_engine_glue {

// #define translateFrontEndIdToRenameUnit(front_end_id)                   _param->_translate_front_end_id_to_rename_unit[front_end_id]
// #define translateFrontEndIdFromRenameUnit(num_rename_unit,front_end_id) _param->_translate_front_end_id_from_rename_unit[num_rename_unit][front_end_id]

  class Parameters : public morpheo::behavioural::Parameters
  {
    //-----[ fields ]------------------------------------------------------------
  public : uint32_t                _nb_front_end                           ;
  public : uint32_t              * _nb_context                             ;//[nb_front_end]
  public : uint32_t                _nb_rename_unit                         ;
  public : uint32_t              * _nb_inst_decod                          ;//[nb_front_end]
  public : uint32_t              * _nb_inst_insert                         ;//[nb_rename_unit]
  public : uint32_t              * _nb_inst_retire                         ;//[nb_rename_unit]
//public : uint32_t                _size_general_data                      ;
//public : uint32_t                _size_special_data                      ;
  public : uint32_t              * _link_rename_unit_with_front_end        ;//[nb_front_end]
  public : std::vector<uint32_t> * _translate_front_end_id_from_rename_unit;//[nb_rename_unit]
//public : uint32_t                _size_packet_id                         ;
//public : uint32_t                _size_general_register                  ;
//public : uint32_t                _size_special_register                  ;
//public : uint32_t                _size_store_queue_ptr                   ;
//public : uint32_t                _size_load_queue_ptr                    ;
                                                                           
//public : uint32_t              * _rename_unit_nb_front_end               ;//[nb_rename_unit]
//public : uint32_t             ** _rename_unit_nb_context                 ;//[nb_rename_unit][nb_front_end]
//public : uint32_t              * _rename_unit_size_front_end_id          ;//[nb_rename_unit]
//public : uint32_t              * _rename_unit_size_context_id            ;//[nb_rename_unit]
//public : uint32_t                _size_front_end_id                      ;
//public : uint32_t                _size_context_id                        ;
  public : uint32_t                _size_rename_id                         ;
  public : uint32_t                _sum_inst_insert                        ;
//public : uint32_t                _sum_inst_retire                        ;
  public : uint32_t              * _translate_front_end_id_to_rename_unit  ;//[nb_front_end]
  public : Tgeneral_address_t      _mask_num_general_register              ;
  public : Tspecial_address_t      _mask_num_special_register              ;

//public : bool                    _have_port_front_end_id                 ;
//public : bool                    _have_port_context_id                   ;
//public : bool                    _have_port_packet_id                    ;
//public : bool                    _have_port_load_queue_ptr               ;

    //-----[ methods ]-----------------------------------------------------------
  public : Parameters  (uint32_t                nb_front_end                           ,
                        uint32_t              * nb_context                             ,
                        uint32_t                nb_rename_unit                         ,
                        uint32_t              * nb_inst_decod                          ,
                        uint32_t              * nb_inst_insert                         ,
                        uint32_t              * nb_inst_retire                         ,
                        uint32_t                size_general_data                      ,
                        uint32_t                size_special_data                      ,
                        uint32_t              * link_rename_unit_with_front_end        ,
                        std::vector<uint32_t> * translate_front_end_id_from_rename_unit,
                        uint32_t                size_packet_id                         ,
                        uint32_t                size_general_register                  ,
                        uint32_t                size_special_register                  ,
                        uint32_t                size_store_queue_ptr                   ,
                        uint32_t                size_load_queue_ptr                    ,
                        bool                    is_toplevel=false);
//   public : Parameters  (Parameters & param) ;
  public : ~Parameters () ;

  public :        void            copy       (void);

  public :        Parameters_test msg_error  (void);

  public :        std::string     print      (uint32_t depth);
  public : friend std::ostream&   operator<< (std::ostream& output_stream,
					    morpheo::behavioural::core::multi_ooo_engine::ooo_engine::ooo_engine_glue::Parameters & x);
  };

}; // end namespace ooo_engine_glue
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
