/*
 * $Id: Core_Glue_deallocation.cpp 122 2009-06-03 08:15:51Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Core_Glue/include/Core_Glue.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace core_glue {


#undef  FUNCTION
#define FUNCTION "Core_Glue::deallocation"
  void Core_Glue::deallocation (void)
  {
    log_begin(Core_Glue,FUNCTION);

    if (usage_is_set(_usage,USE_SYSTEMC))
      {
	delete    in_CLOCK ;
	delete    in_NRESET;

        DELETE2_SIGNAL(out_RENAME_FRONT_END_ID                       ,_param->_nb_front_end,_param->_nb_inst_decod[it1],_param->_size_front_end_id);

        DELETE2_SIGNAL(out_BRANCH_COMPLETE_FRONT_END_VAL             ,_param->_nb_front_end,_param->_front_end_nb_inst_branch_complete[it1],1);
        DELETE2_SIGNAL( in_BRANCH_COMPLETE_FRONT_END_ACK             ,_param->_nb_front_end,_param->_front_end_nb_inst_branch_complete[it1],1);
        DELETE2_SIGNAL(out_BRANCH_COMPLETE_FRONT_END_CONTEXT_ID      ,_param->_nb_front_end,_param->_front_end_nb_inst_branch_complete[it1],_param->_size_context_id);
        DELETE2_SIGNAL(out_BRANCH_COMPLETE_FRONT_END_DEPTH           ,_param->_nb_front_end,_param->_front_end_nb_inst_branch_complete[it1],_param->_size_depth);
        DELETE2_SIGNAL(out_BRANCH_COMPLETE_FRONT_END_ADDRESS         ,_param->_nb_front_end,_param->_front_end_nb_inst_branch_complete[it1],_param->_size_instruction_address);
        DELETE2_SIGNAL(out_BRANCH_COMPLETE_FRONT_END_NO_SEQUENCE     ,_param->_nb_front_end,_param->_front_end_nb_inst_branch_complete[it1],1);
        DELETE2_SIGNAL( in_BRANCH_COMPLETE_FRONT_END_MISS_PREDICTION ,_param->_nb_front_end,_param->_front_end_nb_inst_branch_complete[it1],1);

        DELETE2_SIGNAL( in_BRANCH_COMPLETE_OOO_ENGINE_VAL            ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_inst_branch_complete[it1],1);
        DELETE2_SIGNAL(out_BRANCH_COMPLETE_OOO_ENGINE_ACK            ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_inst_branch_complete[it1],1);
        DELETE2_SIGNAL( in_BRANCH_COMPLETE_OOO_ENGINE_FRONT_END_ID   ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_inst_branch_complete[it1],_param->_size_front_end_id);
        DELETE2_SIGNAL( in_BRANCH_COMPLETE_OOO_ENGINE_CONTEXT_ID     ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_inst_branch_complete[it1],_param->_size_context_id);         
        DELETE2_SIGNAL( in_BRANCH_COMPLETE_OOO_ENGINE_DEPTH          ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_inst_branch_complete[it1],_param->_size_depth);              
        DELETE2_SIGNAL( in_BRANCH_COMPLETE_OOO_ENGINE_ADDRESS        ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_inst_branch_complete[it1],_param->_size_instruction_address);
        DELETE2_SIGNAL( in_BRANCH_COMPLETE_OOO_ENGINE_NO_SEQUENCE    ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_inst_branch_complete[it1],1);
        DELETE2_SIGNAL(out_BRANCH_COMPLETE_OOO_ENGINE_MISS_PREDICTION,_param->_nb_ooo_engine,_param->_ooo_engine_nb_inst_branch_complete[it1],1);

        DELETE1_SIGNAL(out_COMMIT_EVENT_FRONT_END_VAL                ,_param->_nb_front_end,1);
        DELETE1_SIGNAL( in_COMMIT_EVENT_FRONT_END_ACK                ,_param->_nb_front_end,1);
        DELETE1_SIGNAL(out_COMMIT_EVENT_FRONT_END_CONTEXT_ID         ,_param->_nb_front_end,_param->_size_context_id);
        DELETE1_SIGNAL(out_COMMIT_EVENT_FRONT_END_DEPTH              ,_param->_nb_front_end,_param->_size_depth);
        DELETE1_SIGNAL(out_COMMIT_EVENT_FRONT_END_TYPE               ,_param->_nb_front_end,_param->_size_event_type);
        DELETE1_SIGNAL(out_COMMIT_EVENT_FRONT_END_IS_DELAY_SLOT      ,_param->_nb_front_end,1);
        DELETE1_SIGNAL(out_COMMIT_EVENT_FRONT_END_ADDRESS            ,_param->_nb_front_end,_param->_size_instruction_address);
        DELETE1_SIGNAL(out_COMMIT_EVENT_FRONT_END_ADDRESS_EPCR_VAL   ,_param->_nb_front_end,1);
        DELETE1_SIGNAL(out_COMMIT_EVENT_FRONT_END_ADDRESS_EPCR       ,_param->_nb_front_end,_param->_size_spr);
        DELETE1_SIGNAL(out_COMMIT_EVENT_FRONT_END_ADDRESS_EEAR_VAL   ,_param->_nb_front_end,1);
        DELETE1_SIGNAL(out_COMMIT_EVENT_FRONT_END_ADDRESS_EEAR       ,_param->_nb_front_end,_param->_size_spr);

        DELETE1_SIGNAL( in_COMMIT_EVENT_OOO_ENGINE_VAL               ,_param->_nb_ooo_engine,1);
        DELETE1_SIGNAL(out_COMMIT_EVENT_OOO_ENGINE_ACK               ,_param->_nb_ooo_engine,1);
        DELETE1_SIGNAL( in_COMMIT_EVENT_OOO_ENGINE_FRONT_END_ID      ,_param->_nb_ooo_engine,_param->_size_front_end_id);
        DELETE1_SIGNAL( in_COMMIT_EVENT_OOO_ENGINE_CONTEXT_ID        ,_param->_nb_ooo_engine,_param->_size_context_id);
        DELETE1_SIGNAL( in_COMMIT_EVENT_OOO_ENGINE_DEPTH             ,_param->_nb_ooo_engine,_param->_size_depth);
        DELETE1_SIGNAL( in_COMMIT_EVENT_OOO_ENGINE_TYPE              ,_param->_nb_ooo_engine,_param->_size_event_type);
        DELETE1_SIGNAL( in_COMMIT_EVENT_OOO_ENGINE_IS_DELAY_SLOT     ,_param->_nb_ooo_engine,1);
        DELETE1_SIGNAL( in_COMMIT_EVENT_OOO_ENGINE_ADDRESS           ,_param->_nb_ooo_engine,_param->_size_instruction_address);
        DELETE1_SIGNAL( in_COMMIT_EVENT_OOO_ENGINE_ADDRESS_EPCR_VAL  ,_param->_nb_ooo_engine,1);
        DELETE1_SIGNAL( in_COMMIT_EVENT_OOO_ENGINE_ADDRESS_EPCR      ,_param->_nb_ooo_engine,_param->_size_spr);
        DELETE1_SIGNAL( in_COMMIT_EVENT_OOO_ENGINE_ADDRESS_EEAR_VAL  ,_param->_nb_ooo_engine,1);
        DELETE1_SIGNAL( in_COMMIT_EVENT_OOO_ENGINE_ADDRESS_EEAR      ,_param->_nb_ooo_engine,_param->_size_spr);

        DELETE2_SIGNAL( in_ISSUE_OOO_ENGINE_VAL                      ,_param->_nb_ooo_engine,_param->_nb_inst_issue_queue[it1],1);
        DELETE2_SIGNAL(out_ISSUE_OOO_ENGINE_ACK                      ,_param->_nb_ooo_engine,_param->_nb_inst_issue_queue[it1],1);
        DELETE2_SIGNAL( in_ISSUE_OOO_ENGINE_FRONT_END_ID             ,_param->_nb_ooo_engine,_param->_nb_inst_issue_queue[it1],_param->_size_front_end_id);
        DELETE2_SIGNAL( in_ISSUE_OOO_ENGINE_CONTEXT_ID               ,_param->_nb_ooo_engine,_param->_nb_inst_issue_queue[it1],_param->_size_context_id);
        DELETE2_SIGNAL( in_ISSUE_OOO_ENGINE_PACKET_ID                ,_param->_nb_ooo_engine,_param->_nb_inst_issue_queue[it1],_param->_size_rob_ptr);
        DELETE2_SIGNAL( in_ISSUE_OOO_ENGINE_TYPE                     ,_param->_nb_ooo_engine,_param->_nb_inst_issue_queue[it1],_param->_size_type);
        DELETE2_SIGNAL( in_ISSUE_OOO_ENGINE_OPERATION                ,_param->_nb_ooo_engine,_param->_nb_inst_issue_queue[it1],_param->_size_operation);
        DELETE2_SIGNAL( in_ISSUE_OOO_ENGINE_STORE_QUEUE_PTR_WRITE    ,_param->_nb_ooo_engine,_param->_nb_inst_issue_queue[it1],_param->_size_store_queue_ptr);
        DELETE2_SIGNAL( in_ISSUE_OOO_ENGINE_STORE_QUEUE_PTR_READ     ,_param->_nb_ooo_engine,_param->_nb_inst_issue_queue[it1],_param->_size_store_queue_ptr);
        DELETE2_SIGNAL( in_ISSUE_OOO_ENGINE_STORE_QUEUE_EMPTY        ,_param->_nb_ooo_engine,_param->_nb_inst_issue_queue[it1],1);
        DELETE2_SIGNAL( in_ISSUE_OOO_ENGINE_LOAD_QUEUE_PTR_WRITE     ,_param->_nb_ooo_engine,_param->_nb_inst_issue_queue[it1],_param->_size_load_queue_ptr);
        DELETE2_SIGNAL( in_ISSUE_OOO_ENGINE_HAS_IMMEDIAT             ,_param->_nb_ooo_engine,_param->_nb_inst_issue_queue[it1],1);
        DELETE2_SIGNAL( in_ISSUE_OOO_ENGINE_IMMEDIAT                 ,_param->_nb_ooo_engine,_param->_nb_inst_issue_queue[it1],_param->_size_general_data);
        DELETE2_SIGNAL( in_ISSUE_OOO_ENGINE_READ_RA                  ,_param->_nb_ooo_engine,_param->_nb_inst_issue_queue[it1],1);
        DELETE2_SIGNAL( in_ISSUE_OOO_ENGINE_NUM_REG_RA               ,_param->_nb_ooo_engine,_param->_nb_inst_issue_queue[it1],_param->_size_general_register);
        DELETE2_SIGNAL( in_ISSUE_OOO_ENGINE_READ_RB                  ,_param->_nb_ooo_engine,_param->_nb_inst_issue_queue[it1],1);
        DELETE2_SIGNAL( in_ISSUE_OOO_ENGINE_NUM_REG_RB               ,_param->_nb_ooo_engine,_param->_nb_inst_issue_queue[it1],_param->_size_general_register);
        DELETE2_SIGNAL( in_ISSUE_OOO_ENGINE_READ_RC                  ,_param->_nb_ooo_engine,_param->_nb_inst_issue_queue[it1],1);
        DELETE2_SIGNAL( in_ISSUE_OOO_ENGINE_NUM_REG_RC               ,_param->_nb_ooo_engine,_param->_nb_inst_issue_queue[it1],_param->_size_special_register);
        DELETE2_SIGNAL( in_ISSUE_OOO_ENGINE_WRITE_RD                 ,_param->_nb_ooo_engine,_param->_nb_inst_issue_queue[it1],1);
        DELETE2_SIGNAL( in_ISSUE_OOO_ENGINE_NUM_REG_RD               ,_param->_nb_ooo_engine,_param->_nb_inst_issue_queue[it1],_param->_size_general_register);
        DELETE2_SIGNAL( in_ISSUE_OOO_ENGINE_WRITE_RE                 ,_param->_nb_ooo_engine,_param->_nb_inst_issue_queue[it1],1);
        DELETE2_SIGNAL( in_ISSUE_OOO_ENGINE_NUM_REG_RE               ,_param->_nb_ooo_engine,_param->_nb_inst_issue_queue[it1],_param->_size_special_register);

        DELETE2_SIGNAL(out_ISSUE_EXECUTE_LOOP_VAL                    ,_param->_nb_execute_loop,_param->_nb_read_unit[it1],1);
        DELETE2_SIGNAL( in_ISSUE_EXECUTE_LOOP_ACK                    ,_param->_nb_execute_loop,_param->_nb_read_unit[it1],1);
        DELETE2_SIGNAL(out_ISSUE_EXECUTE_LOOP_CONTEXT_ID             ,_param->_nb_execute_loop,_param->_nb_read_unit[it1],_param->_size_context_id);
        DELETE2_SIGNAL(out_ISSUE_EXECUTE_LOOP_FRONT_END_ID           ,_param->_nb_execute_loop,_param->_nb_read_unit[it1],_param->_size_front_end_id);
        DELETE2_SIGNAL(out_ISSUE_EXECUTE_LOOP_OOO_ENGINE_ID          ,_param->_nb_execute_loop,_param->_nb_read_unit[it1],_param->_size_ooo_engine_id);
        DELETE2_SIGNAL(out_ISSUE_EXECUTE_LOOP_PACKET_ID              ,_param->_nb_execute_loop,_param->_nb_read_unit[it1],_param->_size_rob_ptr);
        DELETE2_SIGNAL(out_ISSUE_EXECUTE_LOOP_OPERATION              ,_param->_nb_execute_loop,_param->_nb_read_unit[it1],_param->_size_operation);
        DELETE2_SIGNAL(out_ISSUE_EXECUTE_LOOP_TYPE                   ,_param->_nb_execute_loop,_param->_nb_read_unit[it1],_param->_size_type);
        DELETE2_SIGNAL(out_ISSUE_EXECUTE_LOOP_STORE_QUEUE_PTR_WRITE  ,_param->_nb_execute_loop,_param->_nb_read_unit[it1],_param->_size_store_queue_ptr);
        DELETE2_SIGNAL(out_ISSUE_EXECUTE_LOOP_STORE_QUEUE_PTR_READ   ,_param->_nb_execute_loop,_param->_nb_read_unit[it1],_param->_size_store_queue_ptr);
        DELETE2_SIGNAL(out_ISSUE_EXECUTE_LOOP_STORE_QUEUE_EMPTY      ,_param->_nb_execute_loop,_param->_nb_read_unit[it1],1);
        DELETE2_SIGNAL(out_ISSUE_EXECUTE_LOOP_LOAD_QUEUE_PTR_WRITE   ,_param->_nb_execute_loop,_param->_nb_read_unit[it1],_param->_size_load_queue_ptr);
        DELETE2_SIGNAL(out_ISSUE_EXECUTE_LOOP_HAS_IMMEDIAT           ,_param->_nb_execute_loop,_param->_nb_read_unit[it1],1);
        DELETE2_SIGNAL(out_ISSUE_EXECUTE_LOOP_IMMEDIAT               ,_param->_nb_execute_loop,_param->_nb_read_unit[it1],_param->_size_general_data);
        DELETE2_SIGNAL(out_ISSUE_EXECUTE_LOOP_READ_RA                ,_param->_nb_execute_loop,_param->_nb_read_unit[it1],1);
        DELETE2_SIGNAL(out_ISSUE_EXECUTE_LOOP_NUM_REG_RA             ,_param->_nb_execute_loop,_param->_nb_read_unit[it1],_param->_size_general_register);
        DELETE2_SIGNAL(out_ISSUE_EXECUTE_LOOP_READ_RB                ,_param->_nb_execute_loop,_param->_nb_read_unit[it1],1);
        DELETE2_SIGNAL(out_ISSUE_EXECUTE_LOOP_NUM_REG_RB             ,_param->_nb_execute_loop,_param->_nb_read_unit[it1],_param->_size_general_register);
        DELETE2_SIGNAL(out_ISSUE_EXECUTE_LOOP_READ_RC                ,_param->_nb_execute_loop,_param->_nb_read_unit[it1],1);
        DELETE2_SIGNAL(out_ISSUE_EXECUTE_LOOP_NUM_REG_RC             ,_param->_nb_execute_loop,_param->_nb_read_unit[it1],_param->_size_special_register);
        DELETE2_SIGNAL(out_ISSUE_EXECUTE_LOOP_WRITE_RD               ,_param->_nb_execute_loop,_param->_nb_read_unit[it1],1);
        DELETE2_SIGNAL(out_ISSUE_EXECUTE_LOOP_NUM_REG_RD             ,_param->_nb_execute_loop,_param->_nb_read_unit[it1],_param->_size_general_register);
        DELETE2_SIGNAL(out_ISSUE_EXECUTE_LOOP_WRITE_RE               ,_param->_nb_execute_loop,_param->_nb_read_unit[it1],1);
        DELETE2_SIGNAL(out_ISSUE_EXECUTE_LOOP_NUM_REG_RE             ,_param->_nb_execute_loop,_param->_nb_read_unit[it1],_param->_size_special_register);

        DELETE3_SIGNAL(out_EXECUTE_OOO_ENGINE_VAL                    ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_execute_loop[it1],_param->_nb_inst_execute[it1][it2],1);
        DELETE3_SIGNAL( in_EXECUTE_OOO_ENGINE_ACK                    ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_execute_loop[it1],_param->_nb_inst_execute[it1][it2],1);
        DELETE3_SIGNAL(out_EXECUTE_OOO_ENGINE_FRONT_END_ID           ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_execute_loop[it1],_param->_nb_inst_execute[it1][it2],_param->_size_front_end_id);
        DELETE3_SIGNAL(out_EXECUTE_OOO_ENGINE_CONTEXT_ID             ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_execute_loop[it1],_param->_nb_inst_execute[it1][it2],_param->_size_context_id);
        DELETE3_SIGNAL(out_EXECUTE_OOO_ENGINE_PACKET_ID              ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_execute_loop[it1],_param->_nb_inst_execute[it1][it2],_param->_size_rob_ptr);
//      DELETE3_SIGNAL(out_EXECUTE_OOO_ENGINE_TYPE                   ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_execute_loop[it1],_param->_nb_inst_execute[it1][it2],_param->_size_type);
//      DELETE3_SIGNAL(out_EXECUTE_OOO_ENGINE_OPERATION              ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_execute_loop[it1],_param->_nb_inst_execute[it1][it2],_param->_size_operation);
        DELETE3_SIGNAL(out_EXECUTE_OOO_ENGINE_FLAGS                  ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_execute_loop[it1],_param->_nb_inst_execute[it1][it2],_param->_size_special_data);
        DELETE3_SIGNAL(out_EXECUTE_OOO_ENGINE_EXCEPTION              ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_execute_loop[it1],_param->_nb_inst_execute[it1][it2],_param->_size_exception);
        DELETE3_SIGNAL(out_EXECUTE_OOO_ENGINE_NO_SEQUENCE            ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_execute_loop[it1],_param->_nb_inst_execute[it1][it2],1);
        DELETE3_SIGNAL(out_EXECUTE_OOO_ENGINE_ADDRESS                ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_execute_loop[it1],_param->_nb_inst_execute[it1][it2],_param->_size_general_data);
        DELETE3_SIGNAL(out_EXECUTE_OOO_ENGINE_DATA                   ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_execute_loop[it1],_param->_nb_inst_execute[it1][it2],_param->_size_general_data);

        DELETE2_SIGNAL( in_EXECUTE_EXECUTE_LOOP_VAL                  ,_param->_nb_execute_loop,_param->_nb_write_unit[it1],1);
        DELETE2_SIGNAL(out_EXECUTE_EXECUTE_LOOP_ACK                  ,_param->_nb_execute_loop,_param->_nb_write_unit[it1],1);
        DELETE2_SIGNAL( in_EXECUTE_EXECUTE_LOOP_CONTEXT_ID           ,_param->_nb_execute_loop,_param->_nb_write_unit[it1],_param->_size_context_id);
        DELETE2_SIGNAL( in_EXECUTE_EXECUTE_LOOP_FRONT_END_ID         ,_param->_nb_execute_loop,_param->_nb_write_unit[it1],_param->_size_front_end_id);
        DELETE2_SIGNAL( in_EXECUTE_EXECUTE_LOOP_OOO_ENGINE_ID        ,_param->_nb_execute_loop,_param->_nb_write_unit[it1],_param->_size_ooo_engine_id);
        DELETE2_SIGNAL( in_EXECUTE_EXECUTE_LOOP_PACKET_ID            ,_param->_nb_execute_loop,_param->_nb_write_unit[it1],_param->_size_rob_ptr);
//      DELETE2_SIGNAL( in_EXECUTE_EXECUTE_LOOP_TYPE                 ,_param->_nb_execute_loop,_param->_nb_write_unit[it1],_param->_size_type);
//      DELETE2_SIGNAL( in_EXECUTE_EXECUTE_LOOP_OPERATION            ,_param->_nb_execute_loop,_param->_nb_write_unit[it1],_param->_size_operation);
        DELETE2_SIGNAL( in_EXECUTE_EXECUTE_LOOP_FLAGS                ,_param->_nb_execute_loop,_param->_nb_write_unit[it1],_param->_size_special_data);
        DELETE2_SIGNAL( in_EXECUTE_EXECUTE_LOOP_EXCEPTION            ,_param->_nb_execute_loop,_param->_nb_write_unit[it1],_param->_size_exception);
        DELETE2_SIGNAL( in_EXECUTE_EXECUTE_LOOP_NO_SEQUENCE          ,_param->_nb_execute_loop,_param->_nb_write_unit[it1],1);
        DELETE2_SIGNAL( in_EXECUTE_EXECUTE_LOOP_ADDRESS              ,_param->_nb_execute_loop,_param->_nb_write_unit[it1],_param->_size_general_data);
        DELETE2_SIGNAL( in_EXECUTE_EXECUTE_LOOP_DATA                 ,_param->_nb_execute_loop,_param->_nb_write_unit[it1],_param->_size_general_data);

        DELETE2_SIGNAL( in_INSERT_OOO_ENGINE_VAL                     ,_param->_nb_ooo_engine,_param->_nb_inst_insert[it1],1                             );
        DELETE2_SIGNAL(out_INSERT_OOO_ENGINE_ACK                     ,_param->_nb_ooo_engine,_param->_nb_inst_insert[it1],1                             );
        DELETE2_SIGNAL( in_INSERT_OOO_ENGINE_RD_USE                  ,_param->_nb_ooo_engine,_param->_nb_inst_insert[it1],1                             );
        DELETE2_SIGNAL( in_INSERT_OOO_ENGINE_RD_NUM_REG              ,_param->_nb_ooo_engine,_param->_nb_inst_insert[it1],_param->_size_general_register);
        DELETE2_SIGNAL( in_INSERT_OOO_ENGINE_RE_USE                  ,_param->_nb_ooo_engine,_param->_nb_inst_insert[it1],1                             );
        DELETE2_SIGNAL( in_INSERT_OOO_ENGINE_RE_NUM_REG              ,_param->_nb_ooo_engine,_param->_nb_inst_insert[it1],_param->_size_special_register);

        DELETE3_SIGNAL(out_INSERT_EXECUTE_LOOP_VAL                   ,_param->_nb_execute_loop,_param->_execute_loop_nb_ooo_engine[it1],_param->_execute_loop_nb_inst_insert[it1][it2],1                             );
        DELETE3_SIGNAL( in_INSERT_EXECUTE_LOOP_ACK                   ,_param->_nb_execute_loop,_param->_execute_loop_nb_ooo_engine[it1],_param->_execute_loop_nb_inst_insert[it1][it2],1                             );
        DELETE3_SIGNAL(out_INSERT_EXECUTE_LOOP_RD_USE                ,_param->_nb_execute_loop,_param->_execute_loop_nb_ooo_engine[it1],_param->_execute_loop_nb_inst_insert[it1][it2],1                             );
        DELETE3_SIGNAL(out_INSERT_EXECUTE_LOOP_RD_NUM_REG            ,_param->_nb_execute_loop,_param->_execute_loop_nb_ooo_engine[it1],_param->_execute_loop_nb_inst_insert[it1][it2],_param->_size_general_register);
        DELETE3_SIGNAL(out_INSERT_EXECUTE_LOOP_RE_USE                ,_param->_nb_execute_loop,_param->_execute_loop_nb_ooo_engine[it1],_param->_execute_loop_nb_inst_insert[it1][it2],1                             );
        DELETE3_SIGNAL(out_INSERT_EXECUTE_LOOP_RE_NUM_REG            ,_param->_nb_execute_loop,_param->_execute_loop_nb_ooo_engine[it1],_param->_execute_loop_nb_inst_insert[it1][it2],_param->_size_special_register);
      }

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
    for (uint32_t i=0; i<_param->_nb_execute_loop; ++i)
    delete    _priority_read_unit  [i];
    delete [] _priority_read_unit ;
    delete    _priority_ooo_engine;

    delete _component;

    log_end(Core_Glue,FUNCTION);
  };

}; // end namespace core_glue
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
