/*
 * $Id: Issue_queue_deallocation.cpp 128 2009-06-26 08:43:23Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Issue_queue/include/Issue_queue.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace issue_queue {


#undef  FUNCTION
#define FUNCTION "Issue_queue::deallocation"
  void Issue_queue::deallocation (void)
  {
    log_begin(Issue_queue,FUNCTION);

    if (usage_is_set(_usage,USE_SYSTEMC))
      {
	delete    in_CLOCK ;
	delete    in_NRESET;

	DELETE2_SIGNAL( in_ISSUE_IN_VAL                  ,_param->_nb_rename_unit, _param->_nb_inst_rename[it1],1                             );
	DELETE2_SIGNAL(out_ISSUE_IN_ACK                  ,_param->_nb_rename_unit, _param->_nb_inst_rename[it1],1                             );
	DELETE2_SIGNAL( in_ISSUE_IN_CONTEXT_ID           ,_param->_nb_rename_unit, _param->_nb_inst_rename[it1],_param->_size_context_id      );
	DELETE2_SIGNAL( in_ISSUE_IN_FRONT_END_ID         ,_param->_nb_rename_unit, _param->_nb_inst_rename[it1],_param->_size_front_end_id    );
	DELETE2_SIGNAL( in_ISSUE_IN_PACKET_ID            ,_param->_nb_rename_unit, _param->_nb_inst_rename[it1],_param->_size_rob_ptr         );
	DELETE2_SIGNAL( in_ISSUE_IN_OPERATION            ,_param->_nb_rename_unit, _param->_nb_inst_rename[it1],_param->_size_operation       );
	DELETE2_SIGNAL( in_ISSUE_IN_TYPE                 ,_param->_nb_rename_unit, _param->_nb_inst_rename[it1],_param->_size_type            );
	DELETE2_SIGNAL( in_ISSUE_IN_STORE_QUEUE_PTR_WRITE,_param->_nb_rename_unit, _param->_nb_inst_rename[it1],_param->_size_store_queue_ptr );
	DELETE2_SIGNAL( in_ISSUE_IN_STORE_QUEUE_PTR_READ ,_param->_nb_rename_unit, _param->_nb_inst_rename[it1],_param->_size_store_queue_ptr );
	DELETE2_SIGNAL( in_ISSUE_IN_STORE_QUEUE_EMPTY    ,_param->_nb_rename_unit, _param->_nb_inst_rename[it1],1);
	DELETE2_SIGNAL( in_ISSUE_IN_LOAD_QUEUE_PTR_WRITE ,_param->_nb_rename_unit, _param->_nb_inst_rename[it1],_param->_size_load_queue_ptr  );
	DELETE2_SIGNAL( in_ISSUE_IN_HAS_IMMEDIAT         ,_param->_nb_rename_unit, _param->_nb_inst_rename[it1],1                             );
	DELETE2_SIGNAL( in_ISSUE_IN_IMMEDIAT             ,_param->_nb_rename_unit, _param->_nb_inst_rename[it1],_param->_size_general_data    );
	DELETE2_SIGNAL( in_ISSUE_IN_READ_RA              ,_param->_nb_rename_unit, _param->_nb_inst_rename[it1],1                             );
	DELETE2_SIGNAL( in_ISSUE_IN_NUM_REG_RA           ,_param->_nb_rename_unit, _param->_nb_inst_rename[it1],_param->_size_general_register);
	DELETE2_SIGNAL( in_ISSUE_IN_READ_RB              ,_param->_nb_rename_unit, _param->_nb_inst_rename[it1],1                             );
	DELETE2_SIGNAL( in_ISSUE_IN_NUM_REG_RB           ,_param->_nb_rename_unit, _param->_nb_inst_rename[it1],_param->_size_general_register);
	DELETE2_SIGNAL( in_ISSUE_IN_READ_RC              ,_param->_nb_rename_unit, _param->_nb_inst_rename[it1],1                             );
	DELETE2_SIGNAL( in_ISSUE_IN_NUM_REG_RC           ,_param->_nb_rename_unit, _param->_nb_inst_rename[it1],_param->_size_special_register);
	DELETE2_SIGNAL( in_ISSUE_IN_WRITE_RD             ,_param->_nb_rename_unit, _param->_nb_inst_rename[it1],1                             );
	DELETE2_SIGNAL( in_ISSUE_IN_NUM_REG_RD           ,_param->_nb_rename_unit, _param->_nb_inst_rename[it1],_param->_size_general_register);
	DELETE2_SIGNAL( in_ISSUE_IN_WRITE_RE             ,_param->_nb_rename_unit, _param->_nb_inst_rename[it1],1                             );
	DELETE2_SIGNAL( in_ISSUE_IN_NUM_REG_RE           ,_param->_nb_rename_unit, _param->_nb_inst_rename[it1],_param->_size_special_register);
      
        DELETE1_SIGNAL( in_REEXECUTE_VAL                  ,_param->_nb_inst_reexecute,1                             );
        DELETE1_SIGNAL(out_REEXECUTE_ACK                  ,_param->_nb_inst_reexecute,1                             );
        DELETE1_SIGNAL( in_REEXECUTE_CONTEXT_ID           ,_param->_nb_inst_reexecute,_param->_size_context_id      );
        DELETE1_SIGNAL( in_REEXECUTE_FRONT_END_ID         ,_param->_nb_inst_reexecute,_param->_size_front_end_id    );
        DELETE1_SIGNAL( in_REEXECUTE_PACKET_ID            ,_param->_nb_inst_reexecute,_param->_size_rob_ptr         );
        DELETE1_SIGNAL( in_REEXECUTE_OPERATION            ,_param->_nb_inst_reexecute,_param->_size_operation       );
        DELETE1_SIGNAL( in_REEXECUTE_TYPE                 ,_param->_nb_inst_reexecute,_param->_size_type            );
        DELETE1_SIGNAL( in_REEXECUTE_STORE_QUEUE_PTR_WRITE,_param->_nb_inst_reexecute,_param->_size_store_queue_ptr );
        DELETE1_SIGNAL( in_REEXECUTE_STORE_QUEUE_PTR_READ ,_param->_nb_inst_reexecute,_param->_size_store_queue_ptr );
        DELETE1_SIGNAL( in_REEXECUTE_STORE_QUEUE_EMPTY    ,_param->_nb_inst_reexecute,1);
        DELETE1_SIGNAL( in_REEXECUTE_LOAD_QUEUE_PTR_WRITE ,_param->_nb_inst_reexecute,_param->_size_load_queue_ptr  );
        DELETE1_SIGNAL( in_REEXECUTE_HAS_IMMEDIAT         ,_param->_nb_inst_reexecute,1                             );
        DELETE1_SIGNAL( in_REEXECUTE_IMMEDIAT             ,_param->_nb_inst_reexecute,_param->_size_general_data    );
        DELETE1_SIGNAL( in_REEXECUTE_READ_RA              ,_param->_nb_inst_reexecute,1                             );
        DELETE1_SIGNAL( in_REEXECUTE_NUM_REG_RA           ,_param->_nb_inst_reexecute,_param->_size_general_register);
        DELETE1_SIGNAL( in_REEXECUTE_READ_RB              ,_param->_nb_inst_reexecute,1                             );
        DELETE1_SIGNAL( in_REEXECUTE_NUM_REG_RB           ,_param->_nb_inst_reexecute,_param->_size_general_register);
        DELETE1_SIGNAL( in_REEXECUTE_READ_RC              ,_param->_nb_inst_reexecute,1                             );
        DELETE1_SIGNAL( in_REEXECUTE_NUM_REG_RC           ,_param->_nb_inst_reexecute,_param->_size_special_register);
        DELETE1_SIGNAL( in_REEXECUTE_WRITE_RD             ,_param->_nb_inst_reexecute,1                             );
        DELETE1_SIGNAL( in_REEXECUTE_NUM_REG_RD           ,_param->_nb_inst_reexecute,_param->_size_general_register);
        DELETE1_SIGNAL( in_REEXECUTE_WRITE_RE             ,_param->_nb_inst_reexecute,1                             );
        DELETE1_SIGNAL( in_REEXECUTE_NUM_REG_RE           ,_param->_nb_inst_reexecute,_param->_size_special_register);

        DELETE1_SIGNAL(out_ISSUE_OUT_VAL                  ,_param->_nb_inst_issue,1                             );
        DELETE1_SIGNAL( in_ISSUE_OUT_ACK                  ,_param->_nb_inst_issue,1                             );
        DELETE1_SIGNAL(out_ISSUE_OUT_CONTEXT_ID           ,_param->_nb_inst_issue,_param->_size_context_id      );
        DELETE1_SIGNAL(out_ISSUE_OUT_FRONT_END_ID         ,_param->_nb_inst_issue,_param->_size_front_end_id    );
        DELETE1_SIGNAL(out_ISSUE_OUT_PACKET_ID            ,_param->_nb_inst_issue,_param->_size_rob_ptr         );
        DELETE1_SIGNAL(out_ISSUE_OUT_OPERATION            ,_param->_nb_inst_issue,_param->_size_operation       );
        DELETE1_SIGNAL(out_ISSUE_OUT_TYPE                 ,_param->_nb_inst_issue,_param->_size_type            );
        DELETE1_SIGNAL(out_ISSUE_OUT_STORE_QUEUE_PTR_WRITE,_param->_nb_inst_issue,_param->_size_store_queue_ptr );
        DELETE1_SIGNAL(out_ISSUE_OUT_STORE_QUEUE_PTR_READ ,_param->_nb_inst_issue,_param->_size_store_queue_ptr );
        DELETE1_SIGNAL(out_ISSUE_OUT_STORE_QUEUE_EMPTY    ,_param->_nb_inst_issue,1);
        DELETE1_SIGNAL(out_ISSUE_OUT_LOAD_QUEUE_PTR_WRITE ,_param->_nb_inst_issue,_param->_size_load_queue_ptr  );
        DELETE1_SIGNAL(out_ISSUE_OUT_HAS_IMMEDIAT         ,_param->_nb_inst_issue,1                             );
        DELETE1_SIGNAL(out_ISSUE_OUT_IMMEDIAT             ,_param->_nb_inst_issue,_param->_size_general_data    );
        DELETE1_SIGNAL(out_ISSUE_OUT_READ_RA              ,_param->_nb_inst_issue,1                             );
        DELETE1_SIGNAL(out_ISSUE_OUT_NUM_REG_RA           ,_param->_nb_inst_issue,_param->_size_general_register);
        DELETE1_SIGNAL(out_ISSUE_OUT_READ_RB              ,_param->_nb_inst_issue,1                             );
        DELETE1_SIGNAL(out_ISSUE_OUT_NUM_REG_RB           ,_param->_nb_inst_issue,_param->_size_general_register);
        DELETE1_SIGNAL(out_ISSUE_OUT_READ_RC              ,_param->_nb_inst_issue,1                             );
        DELETE1_SIGNAL(out_ISSUE_OUT_NUM_REG_RC           ,_param->_nb_inst_issue,_param->_size_special_register);
        DELETE1_SIGNAL(out_ISSUE_OUT_WRITE_RD             ,_param->_nb_inst_issue,1                             );
        DELETE1_SIGNAL(out_ISSUE_OUT_NUM_REG_RD           ,_param->_nb_inst_issue,_param->_size_general_register);
        DELETE1_SIGNAL(out_ISSUE_OUT_WRITE_RE             ,_param->_nb_inst_issue,1                             );
        DELETE1_SIGNAL(out_ISSUE_OUT_NUM_REG_RE           ,_param->_nb_inst_issue,_param->_size_special_register);

        // ~~~~~[ Registers ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
	while (not _reexecute_queue.empty())
	  {
	    delete _reexecute_queue.front();
	    _reexecute_queue.pop_front();
	  }

        DELETE1(_issue_queue                     ,_param->_nb_bank);
        
        // ~~~~~[ Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        DELETE1(internal_ISSUE_OUT_VAL           ,_param->_nb_inst_issue);
        DELETE1(internal_ISSUE_OUT_FROM_REEXECUTE,_param->_nb_inst_issue);
        DELETE1(internal_ISSUE_OUT_NUM_BANK      ,_param->_nb_inst_issue);
        DELETE1(internal_ISSUE_OUT_ENTRY         ,_param->_nb_inst_issue);

        DELETE1(internal_REEXECUTE_ACK           ,_param->_nb_inst_reexecute);

        if (_param->_queue_scheme == ISSUE_QUEUE_SCHEME_OUT_OF_ORDER)
          {
        DELETE1(internal_BANK_IN_ACK             ,_param->_nb_bank);
        DELETE1(internal_BANK_IN_NUM_RENAME_UNIT ,_param->_nb_bank);
        DELETE1(internal_BANK_IN_NUM_INST        ,_param->_nb_bank);
          }
        if (_param->_queue_scheme == ISSUE_QUEUE_SCHEME_IN_ORDER)
          {
        DELETE2(internal_ISSUE_IN_ACK            ,_param->_nb_rename_unit,_param->_nb_inst_rename[it1]);
          }
      }
    
    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
    
    delete    _priority_in ;
    if (_param->_queue_scheme == ISSUE_QUEUE_SCHEME_OUT_OF_ORDER)
      {
        delete    _priority_out;
        delete    _priority_reg;
      }
    delete    _component;

    log_end(Issue_queue,FUNCTION);
  };

}; // end namespace issue_queue
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
