/*
 * $Id: test.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 * Test
 */

#include "TopLevel/SelfTest/include/test.h"
#include "Behavioural/include/Allocation.h"

void test (std::string            name,
           std::string            filename_simulator, 
           std::string            filename_generator, 
           std::string            filename_instance ,
           custom_information_t (*get_custom_information) (void)
           )
{
  msg(_("<%s> : Simulation SystemC.\n"),name.c_str());

  if (setlocale (LC_ALL, "") == NULL)
    msg(_("setlocale ko.\n"));
  else
    msg(_("setlocale ok : %s.\n"),setlocale (LC_ALL, ""));
  
  Morpheo * _Morpheo = new Morpheo 
    (name.c_str(),
     filename_simulator, 
     filename_generator, 
     filename_instance ,
     get_custom_information
     );
  
#ifdef SYSTEMC
  if (1)
    {
  /*********************************************************************
   * Dclarations des signaux
   *********************************************************************/
  string rename;

  sc_clock              *  in_CLOCK  = new sc_clock ("clock", 1.0, 0.5);	 
  sc_signal<Tcontrol_t> *  in_NRESET = new sc_signal<Tcontrol_t> ("NRESET");

  ALLOC1_SC_SIGNAL(out_ICACHE_REQ_VAL         ,"out_ICACHE_REQ_VAL        ",Tcontrol_t           ,_Morpheo->_nb_icache_port);
  ALLOC1_SC_SIGNAL( in_ICACHE_REQ_ACK         ," in_ICACHE_REQ_ACK        ",Tcontrol_t           ,_Morpheo->_nb_icache_port);
  ALLOC1_SC_SIGNAL(out_ICACHE_REQ_THREAD_ID   ,"out_ICACHE_REQ_THREAD_ID  ",Ticache_context_t    ,_Morpheo->_nb_icache_port);
  ALLOC1_SC_SIGNAL(out_ICACHE_REQ_PACKET_ID   ,"out_ICACHE_REQ_PACKET_ID  ",Ticache_packet_t     ,_Morpheo->_nb_icache_port);
  ALLOC1_SC_SIGNAL(out_ICACHE_REQ_ADDRESS     ,"out_ICACHE_REQ_ADDRESS    ",Ticache_address_t    ,_Morpheo->_nb_icache_port);
  ALLOC1_SC_SIGNAL(out_ICACHE_REQ_TYPE        ,"out_ICACHE_REQ_TYPE       ",Ticache_type_t       ,_Morpheo->_nb_icache_port);

  ALLOC1_SC_SIGNAL( in_ICACHE_RSP_VAL         ," in_ICACHE_RSP_VAL        ",Tcontrol_t           ,_Morpheo->_nb_icache_port);
  ALLOC1_SC_SIGNAL(out_ICACHE_RSP_ACK         ,"out_ICACHE_RSP_ACK        ",Tcontrol_t           ,_Morpheo->_nb_icache_port);
  ALLOC1_SC_SIGNAL( in_ICACHE_RSP_THREAD_ID   ," in_ICACHE_RSP_THREAD_ID  ",Ticache_context_t    ,_Morpheo->_nb_icache_port);
  ALLOC1_SC_SIGNAL( in_ICACHE_RSP_PACKET_ID   ," in_ICACHE_RSP_PACKET_ID  ",Ticache_packet_t     ,_Morpheo->_nb_icache_port);
  ALLOC2_SC_SIGNAL( in_ICACHE_RSP_INSTRUCTION ," in_ICACHE_RSP_INSTRUCTION",Ticache_instruction_t,_Morpheo->_nb_icache_port,_Morpheo->_icache_nb_instruction[it1]);
  ALLOC1_SC_SIGNAL( in_ICACHE_RSP_ERROR       ," in_ICACHE_RSP_ERROR      ",Ticache_error_t      ,_Morpheo->_nb_icache_port);

  ALLOC1_SC_SIGNAL(out_DCACHE_REQ_VAL         ,"out_DCACHE_REQ_VAL        ",Tcontrol_t           ,_Morpheo->_nb_dcache_port);
  ALLOC1_SC_SIGNAL( in_DCACHE_REQ_ACK         ," in_DCACHE_REQ_ACK        ",Tcontrol_t           ,_Morpheo->_nb_dcache_port);
  ALLOC1_SC_SIGNAL(out_DCACHE_REQ_THREAD_ID   ,"out_DCACHE_REQ_THREAD_ID  ",Tdcache_context_t    ,_Morpheo->_nb_dcache_port);
  ALLOC1_SC_SIGNAL(out_DCACHE_REQ_PACKET_ID   ,"out_DCACHE_REQ_PACKET_ID  ",Tdcache_packet_t     ,_Morpheo->_nb_dcache_port);
  ALLOC1_SC_SIGNAL(out_DCACHE_REQ_ADDRESS     ,"out_DCACHE_REQ_ADDRESS    ",Tdcache_address_t    ,_Morpheo->_nb_dcache_port);
  ALLOC1_SC_SIGNAL(out_DCACHE_REQ_WDATA       ,"out_DCACHE_REQ_WDATA      ",Tdcache_data_t       ,_Morpheo->_nb_dcache_port);
  ALLOC1_SC_SIGNAL(out_DCACHE_REQ_TYPE        ,"out_DCACHE_REQ_TYPE       ",Tdcache_type_t       ,_Morpheo->_nb_dcache_port);
                                                                                                 
  ALLOC1_SC_SIGNAL( in_DCACHE_RSP_VAL         ," in_DCACHE_RSP_VAL        ",Tcontrol_t           ,_Morpheo->_nb_dcache_port);
  ALLOC1_SC_SIGNAL(out_DCACHE_RSP_ACK         ,"out_DCACHE_RSP_ACK        ",Tcontrol_t           ,_Morpheo->_nb_dcache_port);
  ALLOC1_SC_SIGNAL( in_DCACHE_RSP_THREAD_ID   ," in_DCACHE_RSP_THREAD_ID  ",Tdcache_context_t    ,_Morpheo->_nb_dcache_port);
  ALLOC1_SC_SIGNAL( in_DCACHE_RSP_PACKET_ID   ," in_DCACHE_RSP_PACKET_ID  ",Tdcache_packet_t     ,_Morpheo->_nb_dcache_port);
  ALLOC1_SC_SIGNAL( in_DCACHE_RSP_RDATA       ," in_DCACHE_RSP_RDATA      ",Tdcache_data_t       ,_Morpheo->_nb_dcache_port);
  ALLOC1_SC_SIGNAL( in_DCACHE_RSP_ERROR       ," in_DCACHE_RSP_ERROR      ",Tdcache_error_t      ,_Morpheo->_nb_dcache_port);
                                                                                                 
  ALLOC1_SC_SIGNAL( in_INTERRUPT_ENABLE       ," in_INTERRUPT_ENABLE      ",Tcontrol_t           ,_Morpheo->_nb_thread);
  
  /********************************************************
   * Instanciation
   ********************************************************/
  
  msg(_("<%s> : Instanciation of _Morpheo.\n"),name.c_str());

  (*(_Morpheo->in_CLOCK))        (*(in_CLOCK));
  (*(_Morpheo->in_NRESET))       (*(in_NRESET));

  INSTANCE1_SC_SIGNAL(_Morpheo,out_ICACHE_REQ_VAL         ,_Morpheo->_nb_icache_port);
  INSTANCE1_SC_SIGNAL(_Morpheo, in_ICACHE_REQ_ACK         ,_Morpheo->_nb_icache_port);
  if (_Morpheo->_have_port_icache_thread_id)
  INSTANCE1_SC_SIGNAL(_Morpheo,out_ICACHE_REQ_THREAD_ID   ,_Morpheo->_nb_icache_port);
  if (_Morpheo->_have_port_icache_packet_id)
  INSTANCE1_SC_SIGNAL(_Morpheo,out_ICACHE_REQ_PACKET_ID   ,_Morpheo->_nb_icache_port);
  INSTANCE1_SC_SIGNAL(_Morpheo,out_ICACHE_REQ_ADDRESS     ,_Morpheo->_nb_icache_port);
  INSTANCE1_SC_SIGNAL(_Morpheo,out_ICACHE_REQ_TYPE        ,_Morpheo->_nb_icache_port);

  INSTANCE1_SC_SIGNAL(_Morpheo, in_ICACHE_RSP_VAL         ,_Morpheo->_nb_icache_port);
  INSTANCE1_SC_SIGNAL(_Morpheo,out_ICACHE_RSP_ACK         ,_Morpheo->_nb_icache_port);
  if (_Morpheo->_have_port_icache_thread_id)
  INSTANCE1_SC_SIGNAL(_Morpheo, in_ICACHE_RSP_THREAD_ID   ,_Morpheo->_nb_icache_port);
  if (_Morpheo->_have_port_icache_packet_id)
  INSTANCE1_SC_SIGNAL(_Morpheo, in_ICACHE_RSP_PACKET_ID   ,_Morpheo->_nb_icache_port);
  INSTANCE2_SC_SIGNAL(_Morpheo, in_ICACHE_RSP_INSTRUCTION ,_Morpheo->_nb_icache_port,_Morpheo->_icache_nb_instruction[it1]);
  INSTANCE1_SC_SIGNAL(_Morpheo, in_ICACHE_RSP_ERROR       ,_Morpheo->_nb_icache_port);

  INSTANCE1_SC_SIGNAL(_Morpheo,out_DCACHE_REQ_VAL         ,_Morpheo->_nb_dcache_port);
  INSTANCE1_SC_SIGNAL(_Morpheo, in_DCACHE_REQ_ACK         ,_Morpheo->_nb_dcache_port);
  if (_Morpheo->_have_port_dcache_thread_id)
  INSTANCE1_SC_SIGNAL(_Morpheo,out_DCACHE_REQ_THREAD_ID   ,_Morpheo->_nb_dcache_port);
  if (_Morpheo->_have_port_dcache_packet_id)
  INSTANCE1_SC_SIGNAL(_Morpheo,out_DCACHE_REQ_PACKET_ID   ,_Morpheo->_nb_dcache_port);
  INSTANCE1_SC_SIGNAL(_Morpheo,out_DCACHE_REQ_ADDRESS     ,_Morpheo->_nb_dcache_port);
  INSTANCE1_SC_SIGNAL(_Morpheo,out_DCACHE_REQ_WDATA       ,_Morpheo->_nb_dcache_port);
  INSTANCE1_SC_SIGNAL(_Morpheo,out_DCACHE_REQ_TYPE        ,_Morpheo->_nb_dcache_port);

  INSTANCE1_SC_SIGNAL(_Morpheo, in_DCACHE_RSP_VAL         ,_Morpheo->_nb_dcache_port);
  INSTANCE1_SC_SIGNAL(_Morpheo,out_DCACHE_RSP_ACK         ,_Morpheo->_nb_dcache_port);
  if (_Morpheo->_have_port_dcache_thread_id)
  INSTANCE1_SC_SIGNAL(_Morpheo, in_DCACHE_RSP_THREAD_ID   ,_Morpheo->_nb_dcache_port);
  if (_Morpheo->_have_port_dcache_packet_id)
  INSTANCE1_SC_SIGNAL(_Morpheo, in_DCACHE_RSP_PACKET_ID   ,_Morpheo->_nb_dcache_port);
  INSTANCE1_SC_SIGNAL(_Morpheo, in_DCACHE_RSP_RDATA       ,_Morpheo->_nb_dcache_port);
  INSTANCE1_SC_SIGNAL(_Morpheo, in_DCACHE_RSP_ERROR       ,_Morpheo->_nb_dcache_port);

  INSTANCE1_SC_SIGNAL(_Morpheo, in_INTERRUPT_ENABLE       ,_Morpheo->_nb_thread);

  msg(_("<%s> : Start Simulation ............\n"),name.c_str());
    
  Time * _time = new Time();

  /********************************************************
   * Simulation - Begin
   ********************************************************/

  // Initialisation

  const uint32_t seed = 0;
//const uint32_t seed = static_cast<uint32_t>(time(NULL));

  srand(seed);

  SC_START(0);
  LABEL("Initialisation");

  LABEL("Reset");
  in_NRESET->write(0);
  SC_START(5);
  in_NRESET->write(1);  

  for (uint32_t i=0; i<_Morpheo->_nb_icache_port; ++i)
    {
      in_ICACHE_REQ_ACK   [i]->write(0);
      in_ICACHE_RSP_VAL   [i]->write(0);
    }
  for (uint32_t i=0; i<_Morpheo->_nb_dcache_port; ++i)
    {
      in_DCACHE_REQ_ACK   [i]->write(0);
      in_DCACHE_RSP_VAL   [i]->write(0);
    }
  for (uint32_t i=0; i<_Morpheo->_nb_thread; ++i)
    in_INTERRUPT_ENABLE [i]->write(0);

  LABEL("Loop of Test");

  for (uint32_t iteration=0; iteration<NB_ITERATION; iteration ++)
    {
      LABEL("Iteration %d",iteration);

      SC_START(1);
    }

  /********************************************************
   * Simulation - End
   ********************************************************/

  TEST_OK ("End of Simulation");
  delete _time;

  msg(_("<%s> : ............ Stop Simulation\n"),name.c_str());

  delete in_CLOCK;
  delete in_NRESET;

  DELETE1_SC_SIGNAL(out_ICACHE_REQ_VAL         ,_Morpheo->_nb_icache_port);
  DELETE1_SC_SIGNAL( in_ICACHE_REQ_ACK         ,_Morpheo->_nb_icache_port);
  DELETE1_SC_SIGNAL(out_ICACHE_REQ_THREAD_ID   ,_Morpheo->_nb_icache_port);
  DELETE1_SC_SIGNAL(out_ICACHE_REQ_PACKET_ID   ,_Morpheo->_nb_icache_port);
  DELETE1_SC_SIGNAL(out_ICACHE_REQ_ADDRESS     ,_Morpheo->_nb_icache_port);
  DELETE1_SC_SIGNAL(out_ICACHE_REQ_TYPE        ,_Morpheo->_nb_icache_port);
  
  DELETE1_SC_SIGNAL( in_ICACHE_RSP_VAL         ,_Morpheo->_nb_icache_port);
  DELETE1_SC_SIGNAL(out_ICACHE_RSP_ACK         ,_Morpheo->_nb_icache_port);
  DELETE1_SC_SIGNAL( in_ICACHE_RSP_THREAD_ID   ,_Morpheo->_nb_icache_port);
  DELETE1_SC_SIGNAL( in_ICACHE_RSP_PACKET_ID   ,_Morpheo->_nb_icache_port);
  DELETE1_SC_SIGNAL( in_ICACHE_RSP_ERROR       ,_Morpheo->_nb_icache_port);
  DELETE2_SC_SIGNAL( in_ICACHE_RSP_INSTRUCTION ,_Morpheo->_nb_icache_port,_Morpheo->_icache_nb_instruction[it1]);
  
  DELETE1_SC_SIGNAL(out_DCACHE_REQ_VAL         ,_Morpheo->_nb_dcache_port);
  DELETE1_SC_SIGNAL( in_DCACHE_REQ_ACK         ,_Morpheo->_nb_dcache_port);
  DELETE1_SC_SIGNAL(out_DCACHE_REQ_THREAD_ID   ,_Morpheo->_nb_dcache_port);
  DELETE1_SC_SIGNAL(out_DCACHE_REQ_PACKET_ID   ,_Morpheo->_nb_dcache_port);
  DELETE1_SC_SIGNAL(out_DCACHE_REQ_ADDRESS     ,_Morpheo->_nb_dcache_port);
  DELETE1_SC_SIGNAL(out_DCACHE_REQ_WDATA       ,_Morpheo->_nb_dcache_port);
  DELETE1_SC_SIGNAL(out_DCACHE_REQ_TYPE        ,_Morpheo->_nb_dcache_port);
  
  DELETE1_SC_SIGNAL( in_DCACHE_RSP_VAL         ,_Morpheo->_nb_dcache_port);
  DELETE1_SC_SIGNAL(out_DCACHE_RSP_ACK         ,_Morpheo->_nb_dcache_port);
  DELETE1_SC_SIGNAL( in_DCACHE_RSP_THREAD_ID   ,_Morpheo->_nb_dcache_port);
  DELETE1_SC_SIGNAL( in_DCACHE_RSP_PACKET_ID   ,_Morpheo->_nb_dcache_port);
  DELETE1_SC_SIGNAL( in_DCACHE_RSP_RDATA       ,_Morpheo->_nb_dcache_port);
  DELETE1_SC_SIGNAL( in_DCACHE_RSP_ERROR       ,_Morpheo->_nb_dcache_port);
  
  DELETE1_SC_SIGNAL( in_INTERRUPT_ENABLE       ,_Morpheo->_nb_thread);
    }
#endif

  delete _Morpheo;
}
