/*
 * Test_045
 *
 * end_ko : infinite_loop
 * end_ok : Write in R1 the stop address and stop an data
 *          The store in the destination of an jump
 * start  : Test l.sub
 */
	
	.file	"crt0.s"
	/*
	.section .vector
	*/
	.section .text
	.align	4	

/* ---[ 0x0  : Print a error ]------------------------------------------- */

	.org 0x0
_end_ko        :        
	l.movhi r1,     hi(_tty)
	l.ori   r1, r1, lo(_tty)
        l.sw    4(r1), r1 /* stop address */
_infinite_loop :        
        l.j	_infinite_loop
        l.nop

_end_ok :
	l.movhi r1,     hi(_tty)
	l.ori   r1, r1, lo(_tty)
        l.sw    4(r1), r0 /* stop address */


/* ---[ 0x100: RESET exception ]----------------------------------------- */
        .org 0x100
	.global _start
_start:
        /*
             A (r1)     B (r2)     - D (r3 wait)CY OV (SR = r6, mask SR = r5)
                                       (r4)                (r7)
          1) 0x00000000 0x00000000 - 0x00000000 0  0
          2) 0x12344321 0x00000001 - 0x12344320 0  0
          3) 0x12345678 0xffffffff - 0x12345679 0  0
          4) 0x70000000 0x90000000 - 0xe0000000 0  0
          5) 0x80001000 0x80000000 - 0x00001000 0  0
          6) 0x00000001 0x7fffffff - 0x80000002 0  1
          7) 0x12345678 0x12345678 - 0x00000000 0  0
          */


        
        /* Mask to read OV (SR[11]), CY (SR[10]) and not F (SR[9]) */
	l.movhi r5,     hi(0x00000c00)
	l.ori   r5, r5, lo(0x00000c00)
        
        /**********/
        /* Test 1 */
        /**********/
	l.movhi r1,     hi(0x00000000) /* RA */
	l.ori   r1, r1, lo(0x00000000)
	l.movhi r2,     hi(0x00000000) /* RB */
	l.ori   r2, r2, lo(0x00000000)
	l.movhi r3,     hi(0x00000000) /* RD wait */
	l.ori   r3, r3, lo(0x00000000)
	l.movhi r6,     hi(0x00000000) /* SR wait */
	l.ori   r6, r6, lo(0x00000000)
        
        l.sub   r4, r1, r2

        /* Test flag */
        l.mfspr r7, r0, 17
        l.and   r7, r7, r5

        l.sfeq  r6, r7
        l.bnf   _end_ko
        l.nop

        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop

        /**********/
        /* Test 2 */
        /**********/
	l.movhi r1,     hi(0x12344321) /* RA */
	l.ori   r1, r1, lo(0x12344321)
	l.movhi r2,     hi(0x00000001) /* RB */
	l.ori   r2, r2, lo(0x00000001)
	l.movhi r3,     hi(0x12344320) /* RD wait */
	l.ori   r3, r3, lo(0x12344320)
	l.movhi r6,     hi(0x00000000) /* SR wait */
	l.ori   r6, r6, lo(0x00000000)
        
        l.sub   r4, r1, r2

        /* Test flag */
        l.mfspr r7, r0, 17
        l.and   r7, r7, r5

        l.sfeq  r6, r7
        l.bnf   _end_ko
        l.nop

        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop

        /**********/
        /* Test 3 */
        /**********/
	l.movhi r1,     hi(0x12345678) /* RA */
	l.ori   r1, r1, lo(0x12345678)
	l.movhi r2,     hi(0xffffffff) /* RB */
	l.ori   r2, r2, lo(0xffffffff)
	l.movhi r3,     hi(0x12345679) /* RD wait */
	l.ori   r3, r3, lo(0x12345679)
	l.movhi r6,     hi(0x00000000) /* SR wait */
	l.ori   r6, r6, lo(0x00000000)
        
        l.sub   r4, r1, r2

        /* Test flag */
        l.mfspr r7, r0, 17
        l.and   r7, r7, r5

        l.sfeq  r6, r7
        l.bnf   _end_ko
        l.nop

        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop

        /**********/
        /* Test 4 */
        /**********/
	l.movhi r1,     hi(0x70000000) /* RA */
	l.ori   r1, r1, lo(0x70000000)
	l.movhi r2,     hi(0x90000000) /* RB */
	l.ori   r2, r2, lo(0x90000000)
	l.movhi r3,     hi(0xe0000000) /* RD wait */
	l.ori   r3, r3, lo(0xe0000000)
	l.movhi r6,     hi(0x00000800) /* SR wait */
	l.ori   r6, r6, lo(0x00000800)
        
        l.sub   r4, r1, r2

        /* Test flag */
        l.mfspr r7, r0, 17
        l.and   r7, r7, r5

        l.sfeq  r6, r7
        l.bnf   _end_ko
        l.nop

        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop

        /**********/
        /* Test 5 */
        /**********/
	l.movhi r1,     hi(0x80001000) /* RA */
	l.ori   r1, r1, lo(0x80001000)
	l.movhi r2,     hi(0x80000000) /* RB */
	l.ori   r2, r2, lo(0x80000000)
	l.movhi r3,     hi(0x00001000) /* RD wait */
	l.ori   r3, r3, lo(0x00001000)
	l.movhi r6,     hi(0x00000800) /* SR wait */
	l.ori   r6, r6, lo(0x00000800)
        
        l.sub   r4, r1, r2

        /* Test flag */
        l.mfspr r7, r0, 17
        l.and   r7, r7, r5

        l.sfeq  r6, r7
        l.bnf   _end_ko
        l.nop

        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop
        
        /**********/
        /* Test 6 */
        /**********/
	l.movhi r1,     hi(0x00000001) /* RA */
	l.ori   r1, r1, lo(0x00000001)
	l.movhi r2,     hi(0x7fffffff) /* RB */
	l.ori   r2, r2, lo(0x7fffffff)
	l.movhi r3,     hi(0x80000002) /* RD wait */
	l.ori   r3, r3, lo(0x80000002)
	l.movhi r6,     hi(0x00000000) /* SR wait */
	l.ori   r6, r6, lo(0x00000000)
        
        l.sub   r4, r1, r2

        /* Test flag */
        l.mfspr r7, r0, 17
        l.and   r7, r7, r5

        l.sfeq  r6, r7
        l.bnf   _end_ko
        l.nop

        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop

        /**********/
        /* Test 7 */
        /**********/
	l.movhi r1,     hi(0x12345678) /* RA */
	l.ori   r1, r1, lo(0x12345678)
	l.movhi r2,     hi(0x12345678) /* RB */
	l.ori   r2, r2, lo(0x12345678)
	l.movhi r3,     hi(0x00000000) /* RD wait */
	l.ori   r3, r3, lo(0x00000000)
	l.movhi r6,     hi(0x00000000) /* SR wait */
	l.ori   r6, r6, lo(0x00000000)
        
        l.sub   r4, r1, r2

        /* Test flag */
        l.mfspr r7, r0, 17
        l.and   r7, r7, r5

        l.sfeq  r6, r7
        l.bnf   _end_ko
        l.nop

        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop
        
        /**********/
        /* End */
        /**********/

        l.j     _end_ok
        l.nop
