/*
 * $Id: Rename_select.cpp 132 2009-07-11 16:39:35Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Rename_select/include/Rename_select.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace rename_unit {
namespace rename_select {


#undef  FUNCTION
#define FUNCTION "Rename_select::Rename_select"
  Rename_select::Rename_select 
  (
#ifdef SYSTEMC
   sc_module_name name,
#else
   string name,
#endif
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   morpheo::behavioural::core::multi_ooo_engine::ooo_engine::rename_unit::rename_select::Parameters * param,
   morpheo::behavioural::Tusage_t usage
   ):
    _name              (name)
    ,_param            (param)
    ,_usage            (usage)
  {
    log_printf(FUNC,Rename_select,FUNCTION,"Begin");

// #if DEBUG_Core == true
//     log_printf(INFO,Core,FUNCTION,_("<%s> Parameters"),_name.c_str());

//     std::cout << *param << std::endl;
// #endif    

    log_printf(INFO,Rename_select,FUNCTION,"Allocation");

    allocation (
#ifdef STATISTICS
		param_statistics
#endif
		);

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {	
	log_printf(INFO,Rename_select,FUNCTION,"Allocation of statistics");

	statistics_declaration(param_statistics);
      }
#endif

#ifdef VHDL
    if (usage_is_set(_usage,USE_VHDL))
      {
	// generate the vhdl
	log_printf(INFO,Rename_select,FUNCTION,"Generate the vhdl");
	
	vhdl();
      }
#endif

#ifdef SYSTEMC
    if (usage_is_set(_usage,USE_SYSTEMC))
      {
	log_printf(INFO,Rename_select,FUNCTION,"Method - transition");

	SC_METHOD (transition);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).pos();
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    

	log_printf(INFO,Rename_select,FUNCTION,"Method - genMealy");

	SC_METHOD (genMealy);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).neg()
		  << (*(in_NRESET));

	for (uint32_t i=0; i<_param->_nb_front_end; i++)
	  for (uint32_t j=0; j<_param->_nb_inst_decod [i]; j++)
	    {
	      sensitive << (*(in_RENAME_IN_VAL           [i][j]))
			<< (*(in_RENAME_IN_TYPE          [i][j]))
			<< (*(in_RENAME_IN_OPERATION     [i][j]))
			<< (*(in_RENAME_IN_NO_EXECUTE    [i][j]))
// 			<< (*(in_RENAME_IN_HAVE_EVENT    [i][j]))
			<< (*(in_RENAME_IN_LAST_EVENT    [i][j]))
			<< (*(in_RENAME_IN_IS_DELAY_SLOT [i][j]))
#ifdef DEBUG
			<< (*(in_RENAME_IN_ADDRESS       [i][j]))
#endif
			<< (*(in_RENAME_IN_ADDRESS_NEXT  [i][j]))
			<< (*(in_RENAME_IN_HAS_IMMEDIAT  [i][j]))
			<< (*(in_RENAME_IN_IMMEDIAT      [i][j]))
			<< (*(in_RENAME_IN_READ_RA       [i][j]))
			<< (*(in_RENAME_IN_NUM_REG_RA    [i][j]))
			<< (*(in_RENAME_IN_READ_RB       [i][j]))
			<< (*(in_RENAME_IN_NUM_REG_RB    [i][j]))
			<< (*(in_RENAME_IN_READ_RC       [i][j]))
			<< (*(in_RENAME_IN_NUM_REG_RC    [i][j]))
			<< (*(in_RENAME_IN_WRITE_RD      [i][j]))
			<< (*(in_RENAME_IN_NUM_REG_RD    [i][j]))
			<< (*(in_RENAME_IN_WRITE_RE      [i][j]))
			<< (*(in_RENAME_IN_NUM_REG_RE    [i][j]))
			<< (*(in_RENAME_IN_EXCEPTION_USE [i][j]))
			<< (*(in_RENAME_IN_EXCEPTION     [i][j]));
	      if (_param->_have_port_front_end_id)
	      sensitive << (*(in_RENAME_IN_FRONT_END_ID  [i][j]));
	      if (_param->_have_port_context_id)
	      sensitive << (*(in_RENAME_IN_CONTEXT_ID    [i][j]));
	      if (_param->_have_port_depth)
	      sensitive << (*(in_RENAME_IN_DEPTH         [i][j]));
	    }

	for (uint32_t i=0; i<_param->_nb_front_end; i++)
	  for (uint32_t j=0; j<_param->_nb_context [i]; j++)
            sensitive // << (*(in_RETIRE_EVENT_FLUSH [i][j]))
                      << (*(in_RETIRE_EVENT_STOP  [i][j]));

	for (uint32_t i=0; i<_param->_nb_inst_rename; i++)
	  sensitive << (*(in_RENAME_OUT_ACK          [i]));
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
	
	for (uint32_t i=0; i<_param->_nb_front_end; i++)
	  for (uint32_t j=0; j<_param->_nb_inst_decod [i]; j++)
	    for (uint32_t x=0; x<_param->_nb_inst_rename; x++)
	      {
		(*(out_RENAME_IN_ACK            [i][j])) (*(in_RENAME_IN_VAL           [i][j]));
		(*(out_RENAME_IN_ACK            [i][j])) (*(in_RENAME_OUT_ACK          [x]   ));
	      }

	for (uint32_t x=0; x<_param->_nb_inst_rename; x++)
	  {
	    for (uint32_t i=0; i<_param->_nb_front_end; i++)
	      for (uint32_t j=0; j<_param->_nb_inst_decod [i]; j++)
		{
		  (*(out_RENAME_OUT_VAL           [x])) (*(in_RENAME_IN_VAL           [i][j]));

		  if (_param->_have_port_front_end_id)
		    {
		  (*(out_RENAME_OUT_FRONT_END_ID  [x])) (*(in_RENAME_IN_VAL           [i][j]));
		  (*(out_RENAME_OUT_FRONT_END_ID  [x])) (*(in_RENAME_IN_FRONT_END_ID  [i][j]));
		    }
		  if (_param->_have_port_context_id)
		    {
		  (*(out_RENAME_OUT_CONTEXT_ID    [x])) (*(in_RENAME_IN_VAL           [i][j]));
		  (*(out_RENAME_OUT_CONTEXT_ID    [x])) (*(in_RENAME_IN_CONTEXT_ID    [i][j]));
		    }
		  if (_param->_have_port_depth)
		    {
		  (*(out_RENAME_OUT_DEPTH         [x])) (*(in_RENAME_IN_VAL           [i][j]));
		  (*(out_RENAME_OUT_DEPTH         [x])) (*(in_RENAME_IN_DEPTH         [i][j]));
		    }
		  (*(out_RENAME_OUT_TYPE          [x])) (*(in_RENAME_IN_VAL           [i][j]));
		  (*(out_RENAME_OUT_TYPE          [x])) (*(in_RENAME_IN_TYPE          [i][j]));
		  (*(out_RENAME_OUT_OPERATION     [x])) (*(in_RENAME_IN_VAL           [i][j]));
		  (*(out_RENAME_OUT_OPERATION     [x])) (*(in_RENAME_IN_OPERATION     [i][j]));
		  (*(out_RENAME_OUT_NO_EXECUTE    [x])) (*(in_RENAME_IN_VAL           [i][j]));
		  (*(out_RENAME_OUT_NO_EXECUTE    [x])) (*(in_RENAME_IN_NO_EXECUTE    [i][j]));
		  (*(out_RENAME_OUT_IS_DELAY_SLOT [x])) (*(in_RENAME_IN_VAL           [i][j]));
		  (*(out_RENAME_OUT_IS_DELAY_SLOT [x])) (*(in_RENAME_IN_IS_DELAY_SLOT [i][j]));
#ifdef DEBUG
		  (*(out_RENAME_OUT_ADDRESS       [x])) (*(in_RENAME_IN_VAL           [i][j]));
		  (*(out_RENAME_OUT_ADDRESS       [x])) (*(in_RENAME_IN_ADDRESS       [i][j]));
#endif
		  (*(out_RENAME_OUT_ADDRESS_NEXT  [x])) (*(in_RENAME_IN_VAL           [i][j]));
		  (*(out_RENAME_OUT_ADDRESS_NEXT  [x])) (*(in_RENAME_IN_ADDRESS_NEXT  [i][j]));
		  (*(out_RENAME_OUT_HAS_IMMEDIAT  [x])) (*(in_RENAME_IN_VAL           [i][j]));
		  (*(out_RENAME_OUT_HAS_IMMEDIAT  [x])) (*(in_RENAME_IN_HAS_IMMEDIAT  [i][j]));
		  (*(out_RENAME_OUT_IMMEDIAT      [x])) (*(in_RENAME_IN_VAL           [i][j]));
		  (*(out_RENAME_OUT_IMMEDIAT      [x])) (*(in_RENAME_IN_IMMEDIAT      [i][j]));
		  (*(out_RENAME_OUT_READ_RA       [x])) (*(in_RENAME_IN_VAL           [i][j]));
		  (*(out_RENAME_OUT_READ_RA       [x])) (*(in_RENAME_IN_READ_RA       [i][j]));
		  (*(out_RENAME_OUT_NUM_REG_RA    [x])) (*(in_RENAME_IN_VAL           [i][j]));
		  (*(out_RENAME_OUT_NUM_REG_RA    [x])) (*(in_RENAME_IN_NUM_REG_RA    [i][j]));
		  (*(out_RENAME_OUT_READ_RB       [x])) (*(in_RENAME_IN_VAL           [i][j]));
		  (*(out_RENAME_OUT_READ_RB       [x])) (*(in_RENAME_IN_READ_RB       [i][j]));
		  (*(out_RENAME_OUT_NUM_REG_RB    [x])) (*(in_RENAME_IN_VAL           [i][j]));
		  (*(out_RENAME_OUT_NUM_REG_RB    [x])) (*(in_RENAME_IN_NUM_REG_RB    [i][j]));
		  (*(out_RENAME_OUT_READ_RC       [x])) (*(in_RENAME_IN_VAL           [i][j]));
		  (*(out_RENAME_OUT_READ_RC       [x])) (*(in_RENAME_IN_READ_RC       [i][j]));
		  (*(out_RENAME_OUT_NUM_REG_RC    [x])) (*(in_RENAME_IN_VAL           [i][j]));
		  (*(out_RENAME_OUT_NUM_REG_RC    [x])) (*(in_RENAME_IN_NUM_REG_RC    [i][j]));
		  (*(out_RENAME_OUT_WRITE_RD      [x])) (*(in_RENAME_IN_VAL           [i][j]));
		  (*(out_RENAME_OUT_WRITE_RD      [x])) (*(in_RENAME_IN_WRITE_RD      [i][j]));
		  (*(out_RENAME_OUT_NUM_REG_RD    [x])) (*(in_RENAME_IN_VAL           [i][j]));
		  (*(out_RENAME_OUT_NUM_REG_RD    [x])) (*(in_RENAME_IN_NUM_REG_RD    [i][j]));
		  (*(out_RENAME_OUT_WRITE_RE      [x])) (*(in_RENAME_IN_VAL           [i][j]));
		  (*(out_RENAME_OUT_WRITE_RE      [x])) (*(in_RENAME_IN_WRITE_RE      [i][j]));
		  (*(out_RENAME_OUT_NUM_REG_RE    [x])) (*(in_RENAME_IN_VAL           [i][j]));
		  (*(out_RENAME_OUT_NUM_REG_RE    [x])) (*(in_RENAME_IN_NUM_REG_RE    [i][j]));
		  (*(out_RENAME_OUT_EXCEPTION_USE [x])) (*(in_RENAME_IN_VAL           [i][j]));
		  (*(out_RENAME_OUT_EXCEPTION_USE [x])) (*(in_RENAME_IN_EXCEPTION_USE [i][j]));
		  (*(out_RENAME_OUT_EXCEPTION     [x])) (*(in_RENAME_IN_VAL           [i][j]));
		  (*(out_RENAME_OUT_EXCEPTION     [x])) (*(in_RENAME_IN_EXCEPTION     [i][j]));
		}
	  }
# endif    
	
#endif
      }
    log_printf(FUNC,Rename_select,FUNCTION,"End");
  };
    
#undef  FUNCTION
#define FUNCTION "Rename_select::~Rename_select"
  Rename_select::~Rename_select (void)
  {
    log_printf(FUNC,Rename_select,FUNCTION,"Begin");

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {
	log_printf(INFO,Rename_select,FUNCTION,"Generate Statistics file");
	
	delete _stat;
      }
#endif

    log_printf(INFO,Rename_select,FUNCTION,"Deallocation");
    deallocation ();

    log_printf(FUNC,Rename_select,FUNCTION,"End");
  };

}; // end namespace rename_select
}; // end namespace rename_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
