#ifndef morpheo_behavioural_generic_comparator_Parameters_h
#define morpheo_behavioural_generic_comparator_Parameters_h

/*
 * $Id: Parameters.h 113 2009-04-14 18:39:12Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/include/Parameters.h"
#include "Behavioural/Generic/Comparator/include/Types.h"
#include "Common/include/Debug.h"

namespace morpheo {
namespace behavioural {
namespace generic {
namespace comparator {


  class Parameters : public morpheo::behavioural::Parameters
  {
    //-----[ fields ]------------------------------------------------------------
  public : uint32_t             _size_data;
  public : bool                 _is_signed;
  public : Tcomparator_scheme_t _type;

  public : int64_t              _extends;
  public : int64_t              _mask_sign;

    //-----[ methods ]-----------------------------------------------------------
  public : Parameters  (uint32_t             size_data,
                        bool                 is_signed,
                        Tcomparator_scheme_t type     ,
                        bool is_toplevel=false);
//public : Parameters  (Parameters & param) ;
  public : ~Parameters (void);

  public :        void            copy       (void);

  public :        Parameters_test msg_error  (void);

  public :        std::string     print      (uint32_t depth);
  public : friend std::ostream&   operator<< (std::ostream& output_stream,
                                              morpheo::behavioural::generic::comparator::Parameters & x);
  };

}; // end namespace comparator
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
