#ifndef morpheo_behavioural_generic_shifter_Parameters_h
#define morpheo_behavioural_generic_shifter_Parameters_h

/*
 * $Id: Parameters.h 112 2009-03-18 22:36:26Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/include/Parameters.h"
#include "Behavioural/Generic/Shifter/include/Types.h"
#include <math.h>

namespace morpheo {
namespace behavioural {
namespace generic {
namespace shifter {

  class Parameters : public morpheo::behavioural::Parameters
  {
    //-----[ fields ]------------------------------------------------------------
  public : const uint32_t    _size_data           ;
  public : const uint32_t    _nb_port             ;
  public : const uint32_t    _shift_value         ; // 0 = external shifter's value 
  public : const rotate_t    _rotate              ;
  public : const direction_t _direction           ;
  public : const carry_t     _carry               ;
  public : const uint32_t    _size_data_completion;
  public : const bool        _type_completion_bool;

  public : const uint32_t    _size_shift        ;

  public : const bool        _internal_direction;
  public : const bool        _internal_type     ;
  public : const bool        _internal_carry    ;

  public : const bool        _have_shift_logic_left        ;
  public : const bool        _have_shift_logic_right       ;
  public : const bool        _have_shift_logic             ;
  public : const bool        _have_shift_arithmetic_left   ;
  public : const bool        _have_shift_arithmetic_right  ;
  public : const bool        _have_shift_arithmetic        ;
  public : const bool        _have_shift                   ;
  public : const bool        _have_rotate_left             ;
  public : const bool        _have_rotate_right            ;
  public : const bool        _have_rotate                  ;
    
  public : const bool        _have_direction_left          ;
  public : const bool        _have_direction_right         ;

    //-----[ methods ]-----------------------------------------------------------
  public : Parameters  (uint32_t    size_data           ,
			uint32_t    nb_port             ,
			uint32_t    shift_value         ,
			rotate_t    rotate              ,
			direction_t direction           ,
			carry_t     carry               ,
			bool        type_completion_bool = false);
//   public : Parameters  (Parameters & param) ;
  public : ~Parameters () ;

  public :        void            copy       (void);

  public :        Parameters_test msg_error  (void);

  public :        std::string     print      (uint32_t depth);
  public : friend std::ostream&   operator<< (std::ostream& output_stream,
					      morpheo::behavioural::generic::shifter::Parameters & x);
  };

}; // end namespace shifter
}; // end namespace generic
}; // end namespace behavioural
}; // end namespace morpheo              

#endif
