/*
 * $Id: test.cpp 129 2009-06-29 16:38:40Z rosiere $
 *
 * [ Description ]
 * 
 * Test
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/SelfTest/include/test.h"
#include "Behavioural/include/Allocation.h"

void test (string name,
	   morpheo::behavioural::core::multi_ooo_engine::ooo_engine::rename_unit::Parameters * _param)
{
  msg(_("<%s> : Simulation SystemC.\n"),name.c_str());

#ifdef STATISTICS
  morpheo::behavioural::Parameters_Statistics * _parameters_statistics = new morpheo::behavioural::Parameters_Statistics (5,CYCLE_MAX);
#endif

  simulation_init(0,0,0,false,false);
  _model.set_model(NAME_Rename_unit                      , MODEL_SYSTEMC, true);
  _model.set_model(NAME_Load_Store_pointer_unit          , MODEL_SYSTEMC, true);
  _model.set_model(NAME_Register_translation_unit        , MODEL_SYSTEMC, true);
  _model.set_model(NAME_Dependency_checking_unit         , MODEL_SYSTEMC, true);
  _model.set_model(NAME_Free_List_unit                   , MODEL_SYSTEMC, true);
  _model.set_model(NAME_Register_Address_Translation_unit, MODEL_SYSTEMC, true);
  _model.set_model(NAME_Register_translation_unit_Glue   , MODEL_SYSTEMC, true);
  _model.set_model(NAME_Stat_List_unit                   , MODEL_SYSTEMC, true);
  _model.set_model(NAME_Rename_select                    , MODEL_SYSTEMC, true);
  _model.set_model(NAME_Rename_unit_Glue                 , MODEL_SYSTEMC, true);

  Tusage_t _usage = USE_ALL;

//   _usage = usage_unset(_usage,USE_SYSTEMC              );
//   _usage = usage_unset(_usage,USE_VHDL                 );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH       );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH_ASSERT);
//   _usage = usage_unset(_usage,USE_POSITION             );
//   _usage = usage_unset(_usage,USE_STATISTICS           );
//   _usage = usage_unset(_usage,USE_INFORMATION          );

  Rename_unit * _Rename_unit = new Rename_unit 
    (name.c_str(),
#ifdef STATISTICS
     _parameters_statistics,
#endif
     _param,
     _usage);
  
#ifdef SYSTEMC
  if (usage_is_set(_usage,USE_SYSTEMC))
    {
  /*********************************************************************
   * Dclarations des signaux
   *********************************************************************/
  string rename;

  sc_clock              *  in_CLOCK  = new sc_clock ("clock", 1.0, 0.5);	 
  sc_signal<Tcontrol_t> *  in_NRESET = new sc_signal<Tcontrol_t> ("NRESET");

  sc_signal<Tcontrol_t        > ***  in_RENAME_IN_VAL               ;
  sc_signal<Tcontrol_t        > *** out_RENAME_IN_ACK               ;
  sc_signal<Tcontext_t        > ***  in_RENAME_IN_FRONT_END_ID      ;
  sc_signal<Tcontext_t        > ***  in_RENAME_IN_CONTEXT_ID        ;
  sc_signal<Tdepth_t          > ***  in_RENAME_IN_DEPTH             ;
  sc_signal<Ttype_t           > ***  in_RENAME_IN_TYPE              ;
  sc_signal<Toperation_t      > ***  in_RENAME_IN_OPERATION         ;
  sc_signal<Tcontrol_t        > ***  in_RENAME_IN_NO_EXECUTE        ;
  sc_signal<Tcontrol_t        > ***  in_RENAME_IN_LAST_EVENT        ;
  sc_signal<Tcontrol_t        > ***  in_RENAME_IN_IS_DELAY_SLOT     ;
  sc_signal<Tgeneral_data_t   > ***  in_RENAME_IN_ADDRESS           ;
  sc_signal<Tgeneral_data_t   > ***  in_RENAME_IN_ADDRESS_NEXT      ;
  sc_signal<Tcontrol_t        > ***  in_RENAME_IN_HAS_IMMEDIAT      ;
  sc_signal<Tgeneral_data_t   > ***  in_RENAME_IN_IMMEDIAT          ;
  sc_signal<Tcontrol_t        > ***  in_RENAME_IN_READ_RA           ;
  sc_signal<Tgeneral_address_t> ***  in_RENAME_IN_NUM_REG_RA        ;
  sc_signal<Tcontrol_t        > ***  in_RENAME_IN_READ_RB           ;
  sc_signal<Tgeneral_address_t> ***  in_RENAME_IN_NUM_REG_RB        ;
  sc_signal<Tcontrol_t        > ***  in_RENAME_IN_READ_RC           ;
  sc_signal<Tspecial_address_t> ***  in_RENAME_IN_NUM_REG_RC        ;
  sc_signal<Tcontrol_t        > ***  in_RENAME_IN_WRITE_RD          ;
  sc_signal<Tgeneral_address_t> ***  in_RENAME_IN_NUM_REG_RD        ;
  sc_signal<Tcontrol_t        > ***  in_RENAME_IN_WRITE_RE          ;
  sc_signal<Tspecial_address_t> ***  in_RENAME_IN_NUM_REG_RE        ;
  sc_signal<Texception_t      > ***  in_RENAME_IN_EXCEPTION_USE     ;
  sc_signal<Texception_t      > ***  in_RENAME_IN_EXCEPTION         ;
  sc_signal<Tcontrol_t        >  ** out_INSERT_VAL                  ;
  sc_signal<Tcontrol_t        >  **  in_INSERT_ACK                  ;
  sc_signal<Tcontext_t        >  ** out_INSERT_FRONT_END_ID         ;
  sc_signal<Tcontext_t        >  ** out_INSERT_CONTEXT_ID           ;
  sc_signal<Tdepth_t          >  ** out_INSERT_DEPTH                ;
  sc_signal<Ttype_t           >  ** out_INSERT_TYPE                 ;
  sc_signal<Toperation_t      >  ** out_INSERT_OPERATION            ;
  sc_signal<Tcontrol_t        >  ** out_INSERT_NO_EXECUTE           ;
  sc_signal<Tcontrol_t        >  ** out_INSERT_LAST_EVENT           ;
  sc_signal<Tcontrol_t        >  ** out_INSERT_IS_DELAY_SLOT        ;
  sc_signal<Tgeneral_data_t   >  ** out_INSERT_ADDRESS              ;
  sc_signal<Tgeneral_data_t   >  ** out_INSERT_ADDRESS_NEXT         ;
  sc_signal<Tcontrol_t        >  ** out_INSERT_HAS_IMMEDIAT         ;
  sc_signal<Tgeneral_data_t   >  ** out_INSERT_IMMEDIAT             ;
  sc_signal<Tlsq_ptr_t        >  ** out_INSERT_STORE_QUEUE_PTR_WRITE;
  sc_signal<Tlsq_ptr_t        >  ** out_INSERT_STORE_QUEUE_PTR_READ ;
  sc_signal<Tcontrol_t        >  ** out_INSERT_STORE_QUEUE_EMPTY    ;
  sc_signal<Tlsq_ptr_t        >  ** out_INSERT_LOAD_QUEUE_PTR_WRITE ;
  sc_signal<Tcontrol_t        >  ** out_INSERT_READ_RA              ;
  sc_signal<Tgeneral_address_t>  ** out_INSERT_NUM_REG_RA_LOG       ;
  sc_signal<Tgeneral_address_t>  ** out_INSERT_NUM_REG_RA_PHY       ;
  sc_signal<Tcontrol_t        >  ** out_INSERT_READ_RB              ;
  sc_signal<Tgeneral_address_t>  ** out_INSERT_NUM_REG_RB_LOG       ;
  sc_signal<Tgeneral_address_t>  ** out_INSERT_NUM_REG_RB_PHY       ;
  sc_signal<Tcontrol_t        >  ** out_INSERT_READ_RC              ;
  sc_signal<Tspecial_address_t>  ** out_INSERT_NUM_REG_RC_LOG       ;
  sc_signal<Tspecial_address_t>  ** out_INSERT_NUM_REG_RC_PHY       ;
  sc_signal<Tcontrol_t        >  ** out_INSERT_WRITE_RD             ;
  sc_signal<Tgeneral_address_t>  ** out_INSERT_NUM_REG_RD_LOG       ;
  sc_signal<Tgeneral_address_t>  ** out_INSERT_NUM_REG_RD_PHY_OLD   ;
  sc_signal<Tgeneral_address_t>  ** out_INSERT_NUM_REG_RD_PHY_NEW   ;
  sc_signal<Tcontrol_t        >  ** out_INSERT_WRITE_RE             ;
  sc_signal<Tspecial_address_t>  ** out_INSERT_NUM_REG_RE_LOG       ;
  sc_signal<Tspecial_address_t>  ** out_INSERT_NUM_REG_RE_PHY_OLD   ;
  sc_signal<Tspecial_address_t>  ** out_INSERT_NUM_REG_RE_PHY_NEW   ;
  sc_signal<Texception_t      >  ** out_INSERT_EXCEPTION_USE        ;
  sc_signal<Texception_t      >  ** out_INSERT_EXCEPTION            ;
  sc_signal<Tcontrol_t        >  **  in_RETIRE_VAL                  ;
  sc_signal<Tcontrol_t        >  ** out_RETIRE_ACK                  ;
  sc_signal<Tcontext_t        >  **  in_RETIRE_FRONT_END_ID         ;
  sc_signal<Tcontext_t        >  **  in_RETIRE_CONTEXT_ID           ;
//sc_signal<Ttype_t           >  **  in_RETIRE_TYPE                 ;
//sc_signal<Toperation_t      >  **  in_RETIRE_OPERATION            ;
  sc_signal<Tcontrol_t        >  **  in_RETIRE_USE_STORE_QUEUE      ;
  sc_signal<Tcontrol_t        >  **  in_RETIRE_USE_LOAD_QUEUE       ;
  sc_signal<Tlsq_ptr_t        >  **  in_RETIRE_STORE_QUEUE_PTR_WRITE;
  sc_signal<Tlsq_ptr_t        >  **  in_RETIRE_LOAD_QUEUE_PTR_WRITE ;
  sc_signal<Tcontrol_t        >  **  in_RETIRE_READ_RA              ;
  sc_signal<Tgeneral_address_t>  **  in_RETIRE_NUM_REG_RA_PHY       ;
  sc_signal<Tcontrol_t        >  **  in_RETIRE_READ_RB              ;
  sc_signal<Tgeneral_address_t>  **  in_RETIRE_NUM_REG_RB_PHY       ;
  sc_signal<Tcontrol_t        >  **  in_RETIRE_READ_RC              ;
  sc_signal<Tspecial_address_t>  **  in_RETIRE_NUM_REG_RC_PHY       ;
  sc_signal<Tcontrol_t        >  **  in_RETIRE_WRITE_RD             ;
  sc_signal<Tgeneral_address_t>  **  in_RETIRE_NUM_REG_RD_LOG       ;
  sc_signal<Tgeneral_address_t>  **  in_RETIRE_NUM_REG_RD_PHY_OLD   ;
  sc_signal<Tgeneral_address_t>  **  in_RETIRE_NUM_REG_RD_PHY_NEW   ;
  sc_signal<Tcontrol_t        >  **  in_RETIRE_WRITE_RE             ;
  sc_signal<Tspecial_address_t>  **  in_RETIRE_NUM_REG_RE_LOG       ;
  sc_signal<Tspecial_address_t>  **  in_RETIRE_NUM_REG_RE_PHY_OLD   ;
  sc_signal<Tspecial_address_t>  **  in_RETIRE_NUM_REG_RE_PHY_NEW   ;
  sc_signal<Tcontrol_t        > ***  in_RETIRE_EVENT_VAL            ;
  sc_signal<Tcontrol_t        > *** out_RETIRE_EVENT_ACK            ;
  sc_signal<Tevent_state_t    > ***  in_RETIRE_EVENT_STATE          ;
  sc_signal<Tspr_t            > ***  in_SPR_READ_SR                 ;
  sc_signal<bool              >   *  in_INFO_ROB_EMPTY              ;

  ALLOC2_SC_SIGNAL( in_RENAME_IN_VAL               ," in_RENAME_IN_VAL               ",Tcontrol_t        ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL(out_RENAME_IN_ACK               ,"out_RENAME_IN_ACK               ",Tcontrol_t        ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL( in_RENAME_IN_FRONT_END_ID      ," in_RENAME_IN_FRONT_END_ID      ",Tcontext_t        ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL( in_RENAME_IN_CONTEXT_ID        ," in_RENAME_IN_CONTEXT_ID        ",Tcontext_t        ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL( in_RENAME_IN_DEPTH             ," in_RENAME_IN_DEPTH             ",Tdepth_t          ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL( in_RENAME_IN_TYPE              ," in_RENAME_IN_TYPE              ",Ttype_t           ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL( in_RENAME_IN_OPERATION         ," in_RENAME_IN_OPERATION         ",Toperation_t      ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL( in_RENAME_IN_NO_EXECUTE        ," in_RENAME_IN_NO_EXECUTE        ",Tcontrol_t        ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL( in_RENAME_IN_LAST_EVENT        ," in_RENAME_IN_LAST_EVENT        ",Tcontrol_t        ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL( in_RENAME_IN_IS_DELAY_SLOT     ," in_RENAME_IN_IS_DELAY_SLOT     ",Tcontrol_t        ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL( in_RENAME_IN_ADDRESS           ," in_RENAME_IN_ADDRESS           ",Tgeneral_data_t   ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL( in_RENAME_IN_ADDRESS_NEXT      ," in_RENAME_IN_ADDRESS_NEXT      ",Tgeneral_data_t   ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL( in_RENAME_IN_HAS_IMMEDIAT      ," in_RENAME_IN_HAS_IMMEDIAT      ",Tcontrol_t        ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL( in_RENAME_IN_IMMEDIAT          ," in_RENAME_IN_IMMEDIAT          ",Tgeneral_data_t   ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL( in_RENAME_IN_READ_RA           ," in_RENAME_IN_READ_RA           ",Tcontrol_t        ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL( in_RENAME_IN_NUM_REG_RA        ," in_RENAME_IN_NUM_REG_RA        ",Tgeneral_address_t,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL( in_RENAME_IN_READ_RB           ," in_RENAME_IN_READ_RB           ",Tcontrol_t        ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL( in_RENAME_IN_NUM_REG_RB        ," in_RENAME_IN_NUM_REG_RB        ",Tgeneral_address_t,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL( in_RENAME_IN_READ_RC           ," in_RENAME_IN_READ_RC           ",Tcontrol_t        ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL( in_RENAME_IN_NUM_REG_RC        ," in_RENAME_IN_NUM_REG_RC        ",Tspecial_address_t,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL( in_RENAME_IN_WRITE_RD          ," in_RENAME_IN_WRITE_RD          ",Tcontrol_t        ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL( in_RENAME_IN_NUM_REG_RD        ," in_RENAME_IN_NUM_REG_RD        ",Tgeneral_address_t,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL( in_RENAME_IN_WRITE_RE          ," in_RENAME_IN_WRITE_RE          ",Tcontrol_t        ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL( in_RENAME_IN_NUM_REG_RE        ," in_RENAME_IN_NUM_REG_RE        ",Tspecial_address_t,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL( in_RENAME_IN_EXCEPTION_USE     ," in_RENAME_IN_EXCEPTION_USE     ",Texception_t      ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL( in_RENAME_IN_EXCEPTION         ," in_RENAME_IN_EXCEPTION         ",Texception_t      ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  ALLOC1_SC_SIGNAL(out_INSERT_VAL                  ,"out_INSERT_VAL                  ",Tcontrol_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL( in_INSERT_ACK                  ," in_INSERT_ACK                  ",Tcontrol_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_FRONT_END_ID         ,"out_INSERT_FRONT_END_ID         ",Tcontext_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_CONTEXT_ID           ,"out_INSERT_CONTEXT_ID           ",Tcontext_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_DEPTH                ,"out_INSERT_DEPTH                ",Tdepth_t          ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_TYPE                 ,"out_INSERT_TYPE                 ",Ttype_t           ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_OPERATION            ,"out_INSERT_OPERATION            ",Toperation_t      ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_NO_EXECUTE           ,"out_INSERT_NO_EXECUTE           ",Tcontrol_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_LAST_EVENT           ,"out_INSERT_LAST_EVENT           ",Tcontrol_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_IS_DELAY_SLOT        ,"out_INSERT_IS_DELAY_SLOT        ",Tcontrol_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_ADDRESS              ,"out_INSERT_ADDRESS              ",Tgeneral_data_t   ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_ADDRESS_NEXT         ,"out_INSERT_ADDRESS_NEXT         ",Tgeneral_data_t   ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_HAS_IMMEDIAT         ,"out_INSERT_HAS_IMMEDIAT         ",Tcontrol_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_IMMEDIAT             ,"out_INSERT_IMMEDIAT             ",Tgeneral_data_t   ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_STORE_QUEUE_PTR_WRITE,"out_INSERT_STORE_QUEUE_PTR_WRITE",Tlsq_ptr_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_STORE_QUEUE_PTR_READ ,"out_INSERT_STORE_QUEUE_PTR_READ ",Tlsq_ptr_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_STORE_QUEUE_EMPTY    ,"out_INSERT_STORE_QUEUE_EMPTY    ",Tcontrol_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_LOAD_QUEUE_PTR_WRITE ,"out_INSERT_LOAD_QUEUE_PTR_WRITE ",Tlsq_ptr_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_READ_RA              ,"out_INSERT_READ_RA              ",Tcontrol_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_NUM_REG_RA_LOG       ,"out_INSERT_NUM_REG_RA_LOG       ",Tgeneral_address_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_NUM_REG_RA_PHY       ,"out_INSERT_NUM_REG_RA_PHY       ",Tgeneral_address_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_READ_RB              ,"out_INSERT_READ_RB              ",Tcontrol_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_NUM_REG_RB_LOG       ,"out_INSERT_NUM_REG_RB_LOG       ",Tgeneral_address_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_NUM_REG_RB_PHY       ,"out_INSERT_NUM_REG_RB_PHY       ",Tgeneral_address_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_READ_RC              ,"out_INSERT_READ_RC              ",Tcontrol_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_NUM_REG_RC_LOG       ,"out_INSERT_NUM_REG_RC_LOG       ",Tspecial_address_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_NUM_REG_RC_PHY       ,"out_INSERT_NUM_REG_RC_PHY       ",Tspecial_address_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_WRITE_RD             ,"out_INSERT_WRITE_RD             ",Tcontrol_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_NUM_REG_RD_LOG       ,"out_INSERT_NUM_REG_RD_LOG       ",Tgeneral_address_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_NUM_REG_RD_PHY_OLD   ,"out_INSERT_NUM_REG_RD_PHY_OLD   ",Tgeneral_address_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_NUM_REG_RD_PHY_NEW   ,"out_INSERT_NUM_REG_RD_PHY_NEW   ",Tgeneral_address_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_WRITE_RE             ,"out_INSERT_WRITE_RE             ",Tcontrol_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_NUM_REG_RE_LOG       ,"out_INSERT_NUM_REG_RE_LOG       ",Tspecial_address_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_NUM_REG_RE_PHY_OLD   ,"out_INSERT_NUM_REG_RE_PHY_OLD   ",Tspecial_address_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_NUM_REG_RE_PHY_NEW   ,"out_INSERT_NUM_REG_RE_PHY_NEW   ",Tspecial_address_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_EXCEPTION_USE        ,"out_INSERT_EXCEPTION_USE        ",Texception_t      ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_EXCEPTION            ,"out_INSERT_EXCEPTION            ",Texception_t      ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL( in_RETIRE_VAL                  ," in_RETIRE_VAL                  ",Tcontrol_t        ,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL(out_RETIRE_ACK                  ,"out_RETIRE_ACK                  ",Tcontrol_t        ,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL( in_RETIRE_FRONT_END_ID         ," in_RETIRE_FRONT_END_ID         ",Tcontext_t        ,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL( in_RETIRE_CONTEXT_ID           ," in_RETIRE_CONTEXT_ID           ",Tcontext_t        ,_param->_nb_inst_retire);
//ALLOC1_SC_SIGNAL( in_RETIRE_TYPE                 ," in_RETIRE_TYPE                 ",Ttype_t           ,_param->_nb_inst_retire);
//ALLOC1_SC_SIGNAL( in_RETIRE_OPERATION            ," in_RETIRE_OPERATION            ",Toperation_t      ,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL( in_RETIRE_USE_STORE_QUEUE      ," in_RETIRE_USE_STORE_QUEUE      ",Tcontrol_t        ,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL( in_RETIRE_USE_LOAD_QUEUE       ," in_RETIRE_USE_LOAD_QUEUE       ",Tcontrol_t        ,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL( in_RETIRE_STORE_QUEUE_PTR_WRITE," in_RETIRE_STORE_QUEUE_PTR_WRITE",Tlsq_ptr_t        ,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL( in_RETIRE_LOAD_QUEUE_PTR_WRITE ," in_RETIRE_LOAD_QUEUE_PTR_WRITE ",Tlsq_ptr_t        ,_param->_nb_inst_retire);
//   ALLOC1_SC_SIGNAL( in_RETIRE_READ_RA              ," in_RETIRE_READ_RA              ",Tcontrol_t        ,_param->_nb_inst_retire);
//   ALLOC1_SC_SIGNAL( in_RETIRE_NUM_REG_RA_PHY       ," in_RETIRE_NUM_REG_RA_PHY       ",Tgeneral_address_t,_param->_nb_inst_retire);
//   ALLOC1_SC_SIGNAL( in_RETIRE_READ_RB              ," in_RETIRE_READ_RB              ",Tcontrol_t        ,_param->_nb_inst_retire);
//   ALLOC1_SC_SIGNAL( in_RETIRE_NUM_REG_RB_PHY       ," in_RETIRE_NUM_REG_RB_PHY       ",Tgeneral_address_t,_param->_nb_inst_retire);
//   ALLOC1_SC_SIGNAL( in_RETIRE_READ_RC              ," in_RETIRE_READ_RC              ",Tcontrol_t        ,_param->_nb_inst_retire);
//   ALLOC1_SC_SIGNAL( in_RETIRE_NUM_REG_RC_PHY       ," in_RETIRE_NUM_REG_RC_PHY       ",Tspecial_address_t,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL( in_RETIRE_WRITE_RD             ," in_RETIRE_WRITE_RD             ",Tcontrol_t        ,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL( in_RETIRE_NUM_REG_RD_LOG       ," in_RETIRE_NUM_REG_RD_LOG       ",Tgeneral_address_t,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL( in_RETIRE_NUM_REG_RD_PHY_OLD   ," in_RETIRE_NUM_REG_RD_PHY_OLD   ",Tgeneral_address_t,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL( in_RETIRE_NUM_REG_RD_PHY_NEW   ," in_RETIRE_NUM_REG_RD_PHY_NEW   ",Tgeneral_address_t,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL( in_RETIRE_WRITE_RE             ," in_RETIRE_WRITE_RE             ",Tcontrol_t        ,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL( in_RETIRE_NUM_REG_RE_LOG       ," in_RETIRE_NUM_REG_RE_LOG       ",Tspecial_address_t,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL( in_RETIRE_NUM_REG_RE_PHY_OLD   ," in_RETIRE_NUM_REG_RE_PHY_OLD   ",Tspecial_address_t,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL( in_RETIRE_NUM_REG_RE_PHY_NEW   ," in_RETIRE_NUM_REG_RE_PHY_NEW   ",Tspecial_address_t,_param->_nb_inst_retire);
  ALLOC2_SC_SIGNAL( in_RETIRE_EVENT_VAL            ," in_RETIRE_EVENT_VAL            ",Tcontrol_t        ,_param->_nb_front_end,_param->_nb_context[it1]);
  ALLOC2_SC_SIGNAL(out_RETIRE_EVENT_ACK            ,"out_RETIRE_EVENT_ACK            ",Tcontrol_t        ,_param->_nb_front_end,_param->_nb_context[it1]);
  ALLOC2_SC_SIGNAL( in_RETIRE_EVENT_STATE          ," in_RETIRE_EVENT_STATE          ",Tevent_state_t    ,_param->_nb_front_end,_param->_nb_context[it1]);
  ALLOC2_SC_SIGNAL( in_SPR_READ_SR                 ," in_SPR_READ_SR                 ",Tspr_t            ,_param->_nb_front_end,_param->_nb_context[it1]);
  ALLOC0_SC_SIGNAL( in_INFO_ROB_EMPTY              ," in_INFO_ROB_EMPTY              ",bool              );
  
  /********************************************************
   * Instanciation
   ********************************************************/
  
  msg(_("<%s> : Instanciation of _Rename_unit.\n"),name.c_str());

  (*(_Rename_unit->in_CLOCK))        (*(in_CLOCK));
  (*(_Rename_unit->in_NRESET))       (*(in_NRESET));

  INSTANCE2_SC_SIGNAL(_Rename_unit, in_RENAME_IN_VAL               ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  INSTANCE2_SC_SIGNAL(_Rename_unit,out_RENAME_IN_ACK               ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  if (_param->_have_port_front_end_id)
  INSTANCE2_SC_SIGNAL(_Rename_unit, in_RENAME_IN_FRONT_END_ID      ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  if (_param->_have_port_context_id)
  INSTANCE2_SC_SIGNAL(_Rename_unit, in_RENAME_IN_CONTEXT_ID        ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  if (_param->_have_port_depth)
  INSTANCE2_SC_SIGNAL(_Rename_unit, in_RENAME_IN_DEPTH             ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  INSTANCE2_SC_SIGNAL(_Rename_unit, in_RENAME_IN_TYPE              ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  INSTANCE2_SC_SIGNAL(_Rename_unit, in_RENAME_IN_OPERATION         ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  INSTANCE2_SC_SIGNAL(_Rename_unit, in_RENAME_IN_NO_EXECUTE        ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  INSTANCE2_SC_SIGNAL(_Rename_unit, in_RENAME_IN_LAST_EVENT        ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  INSTANCE2_SC_SIGNAL(_Rename_unit, in_RENAME_IN_IS_DELAY_SLOT     ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
#ifdef DEBUG
  INSTANCE2_SC_SIGNAL(_Rename_unit, in_RENAME_IN_ADDRESS           ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
#endif
  INSTANCE2_SC_SIGNAL(_Rename_unit, in_RENAME_IN_ADDRESS_NEXT      ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  INSTANCE2_SC_SIGNAL(_Rename_unit, in_RENAME_IN_HAS_IMMEDIAT      ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  INSTANCE2_SC_SIGNAL(_Rename_unit, in_RENAME_IN_IMMEDIAT          ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  INSTANCE2_SC_SIGNAL(_Rename_unit, in_RENAME_IN_READ_RA           ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  INSTANCE2_SC_SIGNAL(_Rename_unit, in_RENAME_IN_NUM_REG_RA        ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  INSTANCE2_SC_SIGNAL(_Rename_unit, in_RENAME_IN_READ_RB           ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  INSTANCE2_SC_SIGNAL(_Rename_unit, in_RENAME_IN_NUM_REG_RB        ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  INSTANCE2_SC_SIGNAL(_Rename_unit, in_RENAME_IN_READ_RC           ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  INSTANCE2_SC_SIGNAL(_Rename_unit, in_RENAME_IN_NUM_REG_RC        ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  INSTANCE2_SC_SIGNAL(_Rename_unit, in_RENAME_IN_WRITE_RD          ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  INSTANCE2_SC_SIGNAL(_Rename_unit, in_RENAME_IN_NUM_REG_RD        ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  INSTANCE2_SC_SIGNAL(_Rename_unit, in_RENAME_IN_WRITE_RE          ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  INSTANCE2_SC_SIGNAL(_Rename_unit, in_RENAME_IN_NUM_REG_RE        ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  INSTANCE2_SC_SIGNAL(_Rename_unit, in_RENAME_IN_EXCEPTION_USE     ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  INSTANCE2_SC_SIGNAL(_Rename_unit, in_RENAME_IN_EXCEPTION         ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);

  INSTANCE1_SC_SIGNAL(_Rename_unit,out_INSERT_VAL                  ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Rename_unit, in_INSERT_ACK                  ,_param->_nb_inst_insert);
  if (_param->_have_port_front_end_id)
  INSTANCE1_SC_SIGNAL(_Rename_unit,out_INSERT_FRONT_END_ID         ,_param->_nb_inst_insert);
  if (_param->_have_port_context_id)
  INSTANCE1_SC_SIGNAL(_Rename_unit,out_INSERT_CONTEXT_ID           ,_param->_nb_inst_insert);
  if (_param->_have_port_depth)
  INSTANCE1_SC_SIGNAL(_Rename_unit,out_INSERT_DEPTH                ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Rename_unit,out_INSERT_TYPE                 ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Rename_unit,out_INSERT_OPERATION            ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Rename_unit,out_INSERT_NO_EXECUTE           ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Rename_unit,out_INSERT_LAST_EVENT           ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Rename_unit,out_INSERT_IS_DELAY_SLOT        ,_param->_nb_inst_insert);
#ifdef DEBUG
  INSTANCE1_SC_SIGNAL(_Rename_unit,out_INSERT_ADDRESS              ,_param->_nb_inst_insert);
#endif
  INSTANCE1_SC_SIGNAL(_Rename_unit,out_INSERT_ADDRESS_NEXT         ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Rename_unit,out_INSERT_HAS_IMMEDIAT         ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Rename_unit,out_INSERT_IMMEDIAT             ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Rename_unit,out_INSERT_STORE_QUEUE_PTR_WRITE,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Rename_unit,out_INSERT_STORE_QUEUE_PTR_READ ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Rename_unit,out_INSERT_STORE_QUEUE_EMPTY    ,_param->_nb_inst_insert);
  if (_param->_have_port_load_queue_ptr)
  INSTANCE1_SC_SIGNAL(_Rename_unit,out_INSERT_LOAD_QUEUE_PTR_WRITE ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Rename_unit,out_INSERT_EXCEPTION_USE        ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Rename_unit,out_INSERT_EXCEPTION            ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Rename_unit,out_INSERT_READ_RA              ,_param->_nb_inst_insert);
#ifdef DEBUG
  INSTANCE1_SC_SIGNAL(_Rename_unit,out_INSERT_NUM_REG_RA_LOG       ,_param->_nb_inst_insert);
#endif
  INSTANCE1_SC_SIGNAL(_Rename_unit,out_INSERT_NUM_REG_RA_PHY       ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Rename_unit,out_INSERT_READ_RB              ,_param->_nb_inst_insert);
#ifdef DEBUG
  INSTANCE1_SC_SIGNAL(_Rename_unit,out_INSERT_NUM_REG_RB_LOG       ,_param->_nb_inst_insert);
#endif
  INSTANCE1_SC_SIGNAL(_Rename_unit,out_INSERT_NUM_REG_RB_PHY       ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Rename_unit,out_INSERT_READ_RC              ,_param->_nb_inst_insert);
#ifdef DEBUG
  INSTANCE1_SC_SIGNAL(_Rename_unit,out_INSERT_NUM_REG_RC_LOG       ,_param->_nb_inst_insert);
#endif
  INSTANCE1_SC_SIGNAL(_Rename_unit,out_INSERT_NUM_REG_RC_PHY       ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Rename_unit,out_INSERT_WRITE_RD             ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Rename_unit,out_INSERT_NUM_REG_RD_LOG       ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Rename_unit,out_INSERT_NUM_REG_RD_PHY_OLD   ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Rename_unit,out_INSERT_NUM_REG_RD_PHY_NEW   ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Rename_unit,out_INSERT_WRITE_RE             ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Rename_unit,out_INSERT_NUM_REG_RE_LOG       ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Rename_unit,out_INSERT_NUM_REG_RE_PHY_OLD   ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Rename_unit,out_INSERT_NUM_REG_RE_PHY_NEW   ,_param->_nb_inst_insert);

  INSTANCE1_SC_SIGNAL(_Rename_unit, in_RETIRE_VAL                  ,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Rename_unit,out_RETIRE_ACK                  ,_param->_nb_inst_retire);
  if (_param->_have_port_front_end_id)
  INSTANCE1_SC_SIGNAL(_Rename_unit, in_RETIRE_FRONT_END_ID         ,_param->_nb_inst_retire);
  if (_param->_have_port_context_id)
  INSTANCE1_SC_SIGNAL(_Rename_unit, in_RETIRE_CONTEXT_ID           ,_param->_nb_inst_retire);
//INSTANCE1_SC_SIGNAL(_Rename_unit, in_RETIRE_TYPE                 ,_param->_nb_inst_retire);
//INSTANCE1_SC_SIGNAL(_Rename_unit, in_RETIRE_OPERATION            ,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Rename_unit, in_RETIRE_USE_STORE_QUEUE      ,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Rename_unit, in_RETIRE_USE_LOAD_QUEUE       ,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Rename_unit, in_RETIRE_STORE_QUEUE_PTR_WRITE,_param->_nb_inst_retire);
  if (_param->_have_port_load_queue_ptr)
  INSTANCE1_SC_SIGNAL(_Rename_unit, in_RETIRE_LOAD_QUEUE_PTR_WRITE ,_param->_nb_inst_retire);
//   INSTANCE1_SC_SIGNAL(_Rename_unit, in_RETIRE_READ_RA              ,_param->_nb_inst_retire);
//   INSTANCE1_SC_SIGNAL(_Rename_unit, in_RETIRE_NUM_REG_RA_PHY       ,_param->_nb_inst_retire);
//   INSTANCE1_SC_SIGNAL(_Rename_unit, in_RETIRE_READ_RB              ,_param->_nb_inst_retire);
//   INSTANCE1_SC_SIGNAL(_Rename_unit, in_RETIRE_NUM_REG_RB_PHY       ,_param->_nb_inst_retire);
//   INSTANCE1_SC_SIGNAL(_Rename_unit, in_RETIRE_READ_RC              ,_param->_nb_inst_retire);
//   INSTANCE1_SC_SIGNAL(_Rename_unit, in_RETIRE_NUM_REG_RC_PHY       ,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Rename_unit, in_RETIRE_WRITE_RD             ,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Rename_unit, in_RETIRE_NUM_REG_RD_LOG       ,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Rename_unit, in_RETIRE_NUM_REG_RD_PHY_OLD   ,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Rename_unit, in_RETIRE_NUM_REG_RD_PHY_NEW   ,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Rename_unit, in_RETIRE_WRITE_RE             ,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Rename_unit, in_RETIRE_NUM_REG_RE_LOG       ,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Rename_unit, in_RETIRE_NUM_REG_RE_PHY_OLD   ,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Rename_unit, in_RETIRE_NUM_REG_RE_PHY_NEW   ,_param->_nb_inst_retire);

  INSTANCE2_SC_SIGNAL(_Rename_unit, in_RETIRE_EVENT_VAL            ,_param->_nb_front_end, _param->_nb_context[it1]);
  INSTANCE2_SC_SIGNAL(_Rename_unit,out_RETIRE_EVENT_ACK            ,_param->_nb_front_end, _param->_nb_context[it1]);
  INSTANCE2_SC_SIGNAL(_Rename_unit, in_RETIRE_EVENT_STATE          ,_param->_nb_front_end, _param->_nb_context[it1]);

  INSTANCE2_SC_SIGNAL(_Rename_unit,in_SPR_READ_SR                  ,_param->_nb_front_end, _param->_nb_context[it1]);

#ifdef DEBUG_TEST
  INSTANCE0_SC_SIGNAL(_Rename_unit,in_INFO_ROB_EMPTY               );
#endif

  msg(_("<%s> : Start Simulation ............\n"),name.c_str());
    
  Time * _time = new Time();

  /********************************************************
   * Simulation - Begin
   ********************************************************/

  // Initialisation

  const uint32_t seed = 0;
//const uint32_t seed = static_cast<uint32_t>(time(NULL));

  srand(seed);

  SC_START(0);
  LABEL("Initialisation");

  LABEL("Reset");
  in_NRESET->write(0);
  SC_START(5);
  in_NRESET->write(1);  

#ifdef SELFTEST
  LABEL("Loop of Test");

  for (uint32_t iteration=0; iteration<NB_ITERATION; iteration ++)
    {
      LABEL("Iteration %d",iteration);

      SC_START(1);
    }
#else
  SC_START(1000);
#endif

  /********************************************************
   * Simulation - End
   ********************************************************/

  TEST_OK ("End of Simulation");
  delete _time;

  msg(_("<%s> : ............ Stop Simulation\n"),name.c_str());

  delete in_CLOCK;
  delete in_NRESET;

  DELETE2_SC_SIGNAL( in_RENAME_IN_VAL               ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  DELETE2_SC_SIGNAL(out_RENAME_IN_ACK               ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  DELETE2_SC_SIGNAL( in_RENAME_IN_FRONT_END_ID      ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  DELETE2_SC_SIGNAL( in_RENAME_IN_CONTEXT_ID        ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  DELETE2_SC_SIGNAL( in_RENAME_IN_DEPTH             ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  DELETE2_SC_SIGNAL( in_RENAME_IN_TYPE              ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  DELETE2_SC_SIGNAL( in_RENAME_IN_OPERATION         ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  DELETE2_SC_SIGNAL( in_RENAME_IN_NO_EXECUTE        ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  DELETE2_SC_SIGNAL( in_RENAME_IN_LAST_EVENT        ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  DELETE2_SC_SIGNAL( in_RENAME_IN_IS_DELAY_SLOT     ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  DELETE2_SC_SIGNAL( in_RENAME_IN_ADDRESS           ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  DELETE2_SC_SIGNAL( in_RENAME_IN_ADDRESS_NEXT      ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  DELETE2_SC_SIGNAL( in_RENAME_IN_HAS_IMMEDIAT      ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  DELETE2_SC_SIGNAL( in_RENAME_IN_IMMEDIAT          ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  DELETE2_SC_SIGNAL( in_RENAME_IN_READ_RA           ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  DELETE2_SC_SIGNAL( in_RENAME_IN_NUM_REG_RA        ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  DELETE2_SC_SIGNAL( in_RENAME_IN_READ_RB           ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  DELETE2_SC_SIGNAL( in_RENAME_IN_NUM_REG_RB        ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  DELETE2_SC_SIGNAL( in_RENAME_IN_READ_RC           ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  DELETE2_SC_SIGNAL( in_RENAME_IN_NUM_REG_RC        ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  DELETE2_SC_SIGNAL( in_RENAME_IN_WRITE_RD          ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  DELETE2_SC_SIGNAL( in_RENAME_IN_NUM_REG_RD        ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  DELETE2_SC_SIGNAL( in_RENAME_IN_WRITE_RE          ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  DELETE2_SC_SIGNAL( in_RENAME_IN_NUM_REG_RE        ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  DELETE2_SC_SIGNAL( in_RENAME_IN_EXCEPTION_USE     ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  DELETE2_SC_SIGNAL( in_RENAME_IN_EXCEPTION         ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  
  DELETE1_SC_SIGNAL(out_INSERT_VAL                  ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL( in_INSERT_ACK                  ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_FRONT_END_ID         ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_CONTEXT_ID           ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_DEPTH                ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_TYPE                 ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_OPERATION            ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_NO_EXECUTE           ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_LAST_EVENT           ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_IS_DELAY_SLOT        ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_ADDRESS              ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_ADDRESS_NEXT         ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_HAS_IMMEDIAT         ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_IMMEDIAT             ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_STORE_QUEUE_PTR_WRITE,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_STORE_QUEUE_PTR_READ ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_STORE_QUEUE_EMPTY    ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_LOAD_QUEUE_PTR_WRITE ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_EXCEPTION_USE        ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_EXCEPTION            ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_READ_RA              ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_NUM_REG_RA_LOG       ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_NUM_REG_RA_PHY       ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_READ_RB              ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_NUM_REG_RB_LOG       ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_NUM_REG_RB_PHY       ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_READ_RC              ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_NUM_REG_RC_LOG       ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_NUM_REG_RC_PHY       ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_WRITE_RD             ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_NUM_REG_RD_LOG       ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_NUM_REG_RD_PHY_OLD   ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_NUM_REG_RD_PHY_NEW   ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_WRITE_RE             ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_NUM_REG_RE_LOG       ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_NUM_REG_RE_PHY_OLD   ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_NUM_REG_RE_PHY_NEW   ,_param->_nb_inst_insert);
  
  DELETE1_SC_SIGNAL( in_RETIRE_VAL                  ,_param->_nb_inst_retire);
  DELETE1_SC_SIGNAL(out_RETIRE_ACK                  ,_param->_nb_inst_retire);
  DELETE1_SC_SIGNAL( in_RETIRE_FRONT_END_ID         ,_param->_nb_inst_retire);
  DELETE1_SC_SIGNAL( in_RETIRE_CONTEXT_ID           ,_param->_nb_inst_retire);
//DELETE1_SC_SIGNAL( in_RETIRE_TYPE                 ,_param->_nb_inst_retire);
//DELETE1_SC_SIGNAL( in_RETIRE_OPERATION            ,_param->_nb_inst_retire);
  DELETE1_SC_SIGNAL( in_RETIRE_USE_STORE_QUEUE      ,_param->_nb_inst_retire);
  DELETE1_SC_SIGNAL( in_RETIRE_USE_LOAD_QUEUE       ,_param->_nb_inst_retire);
  DELETE1_SC_SIGNAL( in_RETIRE_STORE_QUEUE_PTR_WRITE,_param->_nb_inst_retire);
  DELETE1_SC_SIGNAL( in_RETIRE_LOAD_QUEUE_PTR_WRITE ,_param->_nb_inst_retire);
//   DELETE1_SC_SIGNAL( in_RETIRE_READ_RA              ,_param->_nb_inst_retire);
//   DELETE1_SC_SIGNAL( in_RETIRE_NUM_REG_RA_PHY       ,_param->_nb_inst_retire);
//   DELETE1_SC_SIGNAL( in_RETIRE_READ_RB              ,_param->_nb_inst_retire);
//   DELETE1_SC_SIGNAL( in_RETIRE_NUM_REG_RB_PHY       ,_param->_nb_inst_retire);
//   DELETE1_SC_SIGNAL( in_RETIRE_READ_RC              ,_param->_nb_inst_retire);
//   DELETE1_SC_SIGNAL( in_RETIRE_NUM_REG_RC_PHY       ,_param->_nb_inst_retire);
  DELETE1_SC_SIGNAL( in_RETIRE_WRITE_RD             ,_param->_nb_inst_retire);
  DELETE1_SC_SIGNAL( in_RETIRE_NUM_REG_RD_LOG       ,_param->_nb_inst_retire);
  DELETE1_SC_SIGNAL( in_RETIRE_NUM_REG_RD_PHY_OLD   ,_param->_nb_inst_retire);
  DELETE1_SC_SIGNAL( in_RETIRE_NUM_REG_RD_PHY_NEW   ,_param->_nb_inst_retire);
  DELETE1_SC_SIGNAL( in_RETIRE_WRITE_RE             ,_param->_nb_inst_retire);
  DELETE1_SC_SIGNAL( in_RETIRE_NUM_REG_RE_LOG       ,_param->_nb_inst_retire);
  DELETE1_SC_SIGNAL( in_RETIRE_NUM_REG_RE_PHY_OLD   ,_param->_nb_inst_retire);
  DELETE1_SC_SIGNAL( in_RETIRE_NUM_REG_RE_PHY_NEW   ,_param->_nb_inst_retire);
  
  DELETE2_SC_SIGNAL( in_RETIRE_EVENT_VAL            ,_param->_nb_front_end, _param->_nb_context[it1]);
  DELETE2_SC_SIGNAL(out_RETIRE_EVENT_ACK            ,_param->_nb_front_end, _param->_nb_context[it1]);
  DELETE2_SC_SIGNAL( in_RETIRE_EVENT_STATE          ,_param->_nb_front_end, _param->_nb_context[it1]);

  DELETE2_SC_SIGNAL(in_SPR_READ_SR                  ,_param->_nb_front_end, _param->_nb_context[it1]);

  DELETE0_SC_SIGNAL(in_INFO_ROB_EMPTY               );
    }
#endif

  delete _Rename_unit;
#ifdef STATISTICS
  delete _parameters_statistics;
#endif
}
