#ifndef morpheo_behavioural_core_multi_ooo_engine_ooo_engine_special_register_unit_Special_Register_unit_h
#define morpheo_behavioural_core_multi_ooo_engine_ooo_engine_special_register_unit_Special_Register_unit_h

/*
 * $Id: Special_Register_unit.h 131 2009-07-08 18:40:08Z rosiere $
 *
 * [ Description ]
 * 
 */

#ifdef SYSTEMC
#include "systemc.h"
#endif


#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Special_Register_unit/include/Parameters.h"
#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Special_Register_unit/include/Types.h"
#ifdef STATISTICS
#include "Behavioural/include/Stat.h"
#endif
#include "Behavioural/include/Component.h"
#ifdef VHDL
#include "Behavioural/include/Vhdl.h"
#endif
#include "Behavioural/include/Usage.h"

#include "Common/include/ToString.h"
#include "Common/include/Debug.h"

#include <iostream>

namespace morpheo {
namespace behavioural {

namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace special_register_unit {


  class Special_Register_unit 
#if SYSTEMC
    : public sc_module
#endif
  {
    // -----[ fields ]----------------------------------------------------
    // Parameters
  protected : const std::string  _name;
  protected : const Parameters * _param;
  private   : const Tusage_t     _usage;

#ifdef STATISTICS
  public    : Stat                           * _stat;
#endif

  public    : Component                      * _component;
  private   : Interfaces                     * _interfaces;

#ifdef SYSTEMC
    // ~~~~~[ Interface ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_CLOCK                      *  in_CLOCK        ;
  public    : SC_IN (Tcontrol_t)            *  in_NRESET       ;

    // ~~~~~[ Interface : "spr_access" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t         )  **  in_SPR_ACCESS_VAL          ;//[nb_inst_reexecute]
  public    : SC_OUT(Tcontrol_t         )  ** out_SPR_ACCESS_ACK          ;//[nb_inst_reexecute]
  public    : SC_IN (Tcontext_t         )  **  in_SPR_ACCESS_FRONT_END_ID ;//[nb_inst_reexecute]
  public    : SC_IN (Tcontext_t         )  **  in_SPR_ACCESS_CONTEXT_ID   ;//[nb_inst_reexecute]
  public    : SC_IN (Tcontrol_t         )  **  in_SPR_ACCESS_WEN          ;//[nb_inst_reexecute]
  public    : SC_IN (Tspr_address_t     )  **  in_SPR_ACCESS_NUM_GROUP    ;//[nb_inst_reexecute]
  public    : SC_IN (Tspr_address_t     )  **  in_SPR_ACCESS_NUM_REG      ;//[nb_inst_reexecute]
  public    : SC_IN (Tspr_t             )  **  in_SPR_ACCESS_WDATA        ;//[nb_inst_reexecute]
  public    : SC_OUT(Tspr_t             )  ** out_SPR_ACCESS_RDATA        ;//[nb_inst_reexecute]
  public    : SC_OUT(Tcontrol_t         )  ** out_SPR_ACCESS_INVALID      ;//[nb_inst_reexecute]

    // ~~~~~[ Interface : "spr_read" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_OUT(Tspr_t             ) *** out_SPR_READ_SR             ;//[nb_front_end][nb_context]

    // ~~~~~[ Interface : "spr_commit" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t         ) ***  in_SPR_COMMIT_VAL          ;//[nb_front_end][nb_context]
  public    : SC_OUT(Tcontrol_t         ) *** out_SPR_COMMIT_ACK          ;//[nb_front_end][nb_context]
  public    : SC_IN (Tcontrol_t         ) ***  in_SPR_COMMIT_SR_F_VAL     ;//[nb_front_end][nb_context]
  public    : SC_IN (Tcontrol_t         ) ***  in_SPR_COMMIT_SR_F         ;//[nb_front_end][nb_context]
  public    : SC_IN (Tcontrol_t         ) ***  in_SPR_COMMIT_SR_CY_VAL    ;//[nb_front_end][nb_context]
  public    : SC_IN (Tcontrol_t         ) ***  in_SPR_COMMIT_SR_CY        ;//[nb_front_end][nb_context]
  public    : SC_IN (Tcontrol_t         ) ***  in_SPR_COMMIT_SR_OV_VAL    ;//[nb_front_end][nb_context]
  public    : SC_IN (Tcontrol_t         ) ***  in_SPR_COMMIT_SR_OV        ;//[nb_front_end][nb_context]

    // ~~~~~[ Interface "spr_event" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t        )  ***  in_SPR_EVENT_VAL           ;//[nb_front_end][nb_context]
  public    : SC_OUT(Tcontrol_t        )  *** out_SPR_EVENT_ACK           ;//[nb_front_end][nb_context]
  public    : SC_IN (Tspr_t            )  ***  in_SPR_EVENT_EPCR          ;//[nb_front_end][nb_context]
  public    : SC_IN (Tcontrol_t        )  ***  in_SPR_EVENT_EEAR_WEN      ;//[nb_front_end][nb_context]
  public    : SC_IN (Tspr_t            )  ***  in_SPR_EVENT_EEAR          ;//[nb_front_end][nb_context]
  public    : SC_IN (Tcontrol_t        )  ***  in_SPR_EVENT_SR_DSX        ;//[nb_front_end][nb_context]
  public    : SC_IN (Tcontrol_t        )  ***  in_SPR_EVENT_SR_TO_ESR     ;//[nb_front_end][nb_context]

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
  private   : SPR                       ***** _spr                        ;//[nb_front_end][nb_context][NB_GROUP][NB_REG_GROUP]
  private   : SPR_access_mode             *** _spr_access_mode            ;//[nb_front_end][nb_context]

    // ~~~~~[ Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[ Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  private   : Tcontrol_t                    * internal_SPR_ACCESS_ACK     ;//[nb_inst_reexecute]
  private   : Tcontrol_t                   ** internal_SPR_COMMIT_ACK     ;//[nb_front_end][nb_context]
  private   : Tcontrol_t                   ** internal_SPR_EVENT_ACK      ;//[nb_front_end][nb_context]
#endif

    // -----[ Methods ]---------------------------------------------------

#ifdef SYSTEMC
    SC_HAS_PROCESS (Special_Register_unit);
#endif
  public  :          Special_Register_unit              
  (
#ifdef SYSTEMC
   sc_module_name                                name,
#else					       
   std::string                                   name,
#endif					       
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   Parameters                                  * param,
   morpheo::behavioural::Tusage_t                usage
   );
  public  :          ~Special_Register_unit             (void);
					       
  private : void        allocation                (
#ifdef STATISTICS
						   morpheo::behavioural::Parameters_Statistics * param_statistics
#else
						   void
#endif
						   );
  private : void        deallocation              (void);
					       
#ifdef SYSTEMC				       
  public  : void        constant                  (void);
  public  : void        transition                (void);
  public  : void        genMoore                  (void);
  public  : void        genMealy_spr_access       (void);
#endif					       

#if VHDL				       
  public  : void        vhdl                      (void);
  private : void        vhdl_declaration          (Vhdl * & vhdl);
  private : void        vhdl_body                 (Vhdl * & vhdl);
#endif					       

#ifdef STATISTICS
  public  : void        statistics_allocation     (morpheo::behavioural::Parameters_Statistics * param_statistics);
  public  : void        statistics_deallocation   (void);
#endif
#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
  private : void        end_cycle                 (void);
#endif
  };

}; // end namespace special_register_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
