#ifdef VHDL
/*
 * $Id: Counter_vhdl_body.cpp 113 2009-04-14 18:39:12Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/Counter/include/Counter.h"

namespace morpheo                    {
namespace behavioural {
namespace generic {
namespace counter {

  void Counter::vhdl_body (Vhdl * & vhdl)
  {
    log_printf(FUNC,Counter,"vhdl_body","Begin");
    vhdl->set_body ("");
    
    for (uint32_t i=0; i<_param->_nb_port; i++)
      {
	std::string counter_inc, counter_dec;

	if (_param->_size_data > 1)
	  {
	    counter_inc = "in_COUNTER_"+toString(i)+"_DATA+1";
	    counter_dec = "in_COUNTER_"+toString(i)+"_DATA-1";
	  }
	else
	  {
	    counter_inc = "in_COUNTER_"+toString(i)+"_DATA+1";
	    counter_dec = "in_COUNTER_"+toString(i)+"_DATA-1";
	  }

	vhdl->set_body ("out_COUNTER_"+toString(i)+"_DATA <=");
	if (_param->_size_data > 1)
	  {
	    vhdl->set_body ("\tin_COUNTER_"+toString(i)+"_DATA+1 when in_COUNTER_"+toString(i)+"_ADDSUB = '1' and in_COUNTER_"+toString(i)+"_DATA < cst_max else");
	    vhdl->set_body ("\tin_COUNTER_"+toString(i)+"_DATA-1 when in_COUNTER_"+toString(i)+"_ADDSUB = '0' and in_COUNTER_"+toString(i)+"_DATA > cst_min else");
	    vhdl->set_body ("\tin_COUNTER_"+toString(i)+"_DATA;");
	  }
	else
	  {
	    vhdl->set_body ("\tin_COUNTER_"+toString(i)+"_ADDSUB;");
	  }
      }

    log_printf(FUNC,Counter,"vhdl_body","End");
  };

}; // end namespace counter
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
