/*
 * $Id: Morpheo_configuration.cpp 115 2009-04-20 21:29:17Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "TopLevel/include/Morpheo.h"

namespace morpheo {

  using namespace behavioural;
//   using namespace behavioural::configuration;
//   using namespace behavioural::custom;

#undef  FUNCTION
#define FUNCTION "Morpheo::configuration"
  void Morpheo::configuration (std::string filename_simulator, 
                               std::string filename_generator, 
                               std::string filename_instance ,
                               behavioural::custom::custom_information_t (*get_custom_information) (void))
  {
    log_begin(Morpheo,FUNCTION);

    _config = new behavioural::configuration::Configuration (filename_simulator,
                                                             filename_generator,
                                                             filename_instance,
                                                             get_custom_information);
    
    _name             = _config->getName ();
    _usage            = _config->getUsage();

    // Test usage
    usage_environment(_usage);

#ifdef STATISTICS
    _param_statistics = _config->getParamStatistics();
#endif

    configuration::Parameters * param = _config->getParam();

    _param_core       = new core::Parameters
      (
       param->_size_general_data                             ,
       param->_size_special_data                             ,
       param->_get_custom_information                        ,

       param->_nb_thread                                     ,
       param->_size_ifetch_queue                             ,
       param->_nb_inst_fetch                                 ,
       param->_implement_group                               ,
       param->_ras_size_queue                                ,
       param->_upt_size_queue                                ,
       param->_ufpt_size_queue                               ,

       param->_nb_decod_bloc                                 ,
       param->_size_decod_queue                              ,
       param->_decod_queue_scheme                            ,
       param->_nb_inst_decod                                 ,
       param->_nb_context_select                             ,
       param->_context_select_priority                       ,
       param->_context_select_load_balancing                 ,

       param->_nb_rename_bloc                                ,
       param->_nb_inst_insert                                ,
       param->_nb_inst_retire                                ,
       param->_rename_select_priority                        ,
       param->_rename_select_load_balancing                  ,
       param->_rename_select_nb_front_end_select             ,
       param->_nb_general_register                           ,
       param->_nb_special_register                           ,
       param->_nb_reg_free                                   ,
       param->_nb_rename_unit_bank                           ,
//        param->_size_read_counter                             ,

       param->_nb_read_bloc                                  ,
       param->_size_read_queue                               ,
       param->_size_reservation_station                      ,
       param->_nb_inst_retire_reservation_station            ,

       param->_nb_write_bloc                                 ,
       param->_size_write_queue                              ,
       param->_size_execute_queue                            ,
       param->_nb_bypass_write                               ,
       param->_write_queue_scheme                            ,

       param->_nb_load_store_unit                            ,
       param->_size_store_queue                              ,
       param->_size_load_queue                               ,
       param->_size_speculative_access_queue                 ,
       param->_nb_port_check                                 ,
       param->_speculative_load                              ,
       param->_nb_bypass_memory                              ,
       param->_nb_cache_port                                 ,
       param->_nb_inst_memory                                ,

       param->_nb_functionnal_unit                           ,
       param->_nb_inst_functionnal_unit                      ,
       param->_timing                                        ,

       param->_nb_icache_port                                ,
       param->_icache_port_priority                          ,
       param->_icache_port_load_balancing                    ,

       param->_nb_dcache_port                                ,
       param->_dcache_port_priority                          ,
       param->_dcache_port_load_balancing                    ,

       param->_nb_front_end                                  ,
       param->_nb_context                                    ,
       param->_nb_decod_unit                                 ,
       param->_nb_inst_branch_predict                        ,
       param->_nb_inst_branch_decod                          ,
       param->_nb_inst_branch_update                         ,
       param->_btb_size_queue                                ,
       param->_btb_associativity                             ,
       param->_btb_size_counter                              ,
       param->_btb_victim_scheme                             ,
       param->_dir_predictor_scheme                          ,
       param->_dir_have_bht                                  ,
       param->_dir_bht_size_shifter                          ,
       param->_dir_bht_nb_shifter                            ,
       param->_dir_have_pht                                  ,
       param->_dir_pht_size_counter                          ,
       param->_dir_pht_nb_counter                            ,
       param->_dir_pht_size_address_share                    ,

       param->_nb_ooo_engine                                 ,
       param->_nb_rename_unit                                ,
       param->_nb_inst_issue                                 ,
       param->_nb_inst_reexecute                             ,
       param->_nb_inst_commit                                ,
       param->_nb_inst_branch_complete                       ,
       param->_nb_rename_unit_select                         ,
       param->_nb_execute_loop_select                        ,
       param->_size_re_order_buffer                          ,
       param->_nb_re_order_buffer_bank                       ,
       param->_commit_priority                               ,
       param->_commit_load_balancing                         ,
       param->_size_issue_queue                              ,
       param->_issue_queue_scheme                            ,
       param->_nb_issue_queue_bank                           ,
       param->_issue_priority                                ,
       param->_issue_load_balancing                          ,
       param->_size_reexecute_queue                          ,
       param->_reexecute_priority                            ,
       param->_reexecute_load_balancing                      ,

       param->_nb_execute_loop                               ,
       param->_nb_read_unit                                  ,
       param->_nb_execute_unit                               ,
       param->_nb_write_unit                                 ,
       param->_nb_gpr_bank                                   ,
       param->_nb_gpr_port_read_by_bank                      ,
       param->_nb_gpr_port_write_by_bank                     ,
       param->_nb_spr_bank                                   ,
       param->_nb_spr_port_read_by_bank                      ,
       param->_nb_spr_port_write_by_bank                     ,
       param->_execution_unit_to_write_unit_priority         ,
       param->_read_unit_to_execution_unit_priority          ,

       param->_link_context_with_thread                      ,
       param->_link_decod_unit_with_decod_bloc               ,
       param->_link_rename_unit_with_rename_bloc             ,
       param->_link_read_unit_with_read_bloc                 ,
       param->_link_write_unit_with_write_bloc               ,
       param->_link_execute_unit_with_functionnal_unit       ,
       param->_link_execute_unit_with_load_store_unit        ,
       param->_link_decod_bloc_with_thread                   ,
       param->_link_rename_bloc_with_front_end               ,
       param->_table_dispatch                                ,
       param->_link_read_bloc_and_load_store_unit            ,
       param->_link_read_bloc_and_functionnal_unit           ,
       param->_link_write_bloc_and_load_store_unit           ,
       param->_link_write_bloc_and_functionnal_unit          ,
       param->_link_load_store_unit_with_thread              ,
       param->_link_thread_and_functionnal_unit              ,
       param->_link_icache_port_with_thread                  ,
       param->_link_dcache_port_with_load_store_unit         ,

       param->_dispatch_priority                             ,
       param->_dispatch_load_balancing                       );

    // interface parameters
    _nb_thread                  = _param_core->_nb_thread                 ;
    _nb_icache_port             = _param_core->_nb_icache_port            ;
    _size_icache_thread_id      = _param_core->_size_icache_thread_id     ;
    _size_icache_packet_id      = _param_core->_size_icache_packet_id     ;
    _size_icache_address        = _param_core->_size_icache_address       ;
    _size_icache_type           = _param_core->_size_icache_type          ;
    _size_icache_error          = _param_core->_size_icache_error         ;
    _icache_nb_instruction      = _param_core->_icache_nb_instruction     ;
    _size_icache_instruction    = _param_core->_size_instruction          ;
    _nb_dcache_port             = _param_core->_nb_dcache_port            ;
    _size_dcache_thread_id      = _param_core->_size_dcache_thread_id     ;
    _size_dcache_packet_id      = _param_core->_size_dcache_packet_id     ;
    _size_dcache_address        = _param_core->_size_dcache_address       ;
    _size_dcache_data           = _param_core->_size_dcache_data          ;
    _size_dcache_type           = _param_core->_size_dcache_type          ;
    _size_dcache_error          = _param_core->_size_dcache_error         ;
    _have_port_icache_thread_id = _param_core->_have_port_icache_thread_id;
    _have_port_icache_packet_id = _param_core->_have_port_icache_packet_id;
    _have_port_dcache_thread_id = _param_core->_have_port_dcache_thread_id;
    _have_port_dcache_packet_id = _param_core->_have_port_dcache_packet_id;

    log_end(Morpheo,FUNCTION);
  };
}; // end namespace morpheo
