/*
 * Test_028
 *
 * end_ko : infinite_loop
 * end_ok : Write in R1 the stop address and stop an data
 *          The store in the destination of an jump
 * start  : Test l.sw / l.lws (l.lwz)
 */
	
	.file	"crt0.s"
	/*
	.section .vector
	*/
	.section .text
	.align	4	

/* ---[ 0x0  : Print a error ]------------------------------------------- */

	.org 0x0
_end_ko        :        
	l.movhi r1,     hi(_tty)
	l.ori   r1, r1, lo(_tty)
        l.sw    4(r1), r1 /* stop address */
_infinite_loop :        
        l.j	_infinite_loop
        l.nop

_end_ok :
	l.movhi r1,     hi(_tty)
	l.ori   r1, r1, lo(_tty)
        l.sw    4(r1), r0 /* stop address */


/* ---[ 0x100: RESET exception ]----------------------------------------- */
        .org 0x100
	.global _start
_start:
	l.movhi r1,     hi(_stack) /* address */
	l.ori   r1, r1, lo(_stack)

	l.movhi r2,     hi(0x1234beef) /* data */
	l.ori   r2, r2, lo(0x1234beef)

        /*            0x1234beef
         *              | | | |
         * 0 : 0x12 <---+ | | |
         * 1 : 0x34 <-----+ | |
         * 2 : 0xbe <-------+ |
         * 3 : 0xef <---------+
         */
        
        l.sw    - 0(r1), r2

        l.lws   r3, - 0(r1)
        l.sfeq  r3, r2
        l.bnf   _end_ko
        l.nop

        l.lwz   r3, - 0(r1)
        l.sfeq  r3, r2
        l.bnf   _end_ko
        l.nop
        
        /* end test */
        l.j     _end_ok
        l.nop
