#ifdef SYSTEMC
/*
 * $Id: Direction_Glue_constant.cpp 131 2009-07-08 18:40:08Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Direction/Direction_Glue/include/Direction_Glue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace direction {
namespace direction_glue {


#undef  FUNCTION
#define FUNCTION "Direction_Glue::constant"
  void Direction_Glue::constant (void)
  {
    log_printf(FUNC,Direction_Glue,FUNCTION,"Begin");
    
    if (not _param->_have_component_meta_predictor)
      {
        // no need update
        for (uint32_t i=0; i<_param->_nb_inst_update; i++)
          PORT_WRITE(out_UPDATE_ACK [i], 1);
        
        // always ack
        for (uint32_t i=0; i<_param->_nb_inst_predict; i++)
          {
            PORT_WRITE(out_PREDICT_ACK [i], 1);
            
            // constant direction : never / always 
            switch (_param->_predictor_scheme)
              {
              case PREDICTOR_NEVER_TAKE  :
                {
                  PORT_WRITE(out_PREDICT_DIRECTION [i], 0);
                  break;
                }
              case PREDICTOR_ALWAYS_TAKE :
                {
                  PORT_WRITE(out_PREDICT_DIRECTION [i], 1);
                  break;
                }
              default : break;
              }
          }
      }

    log_printf(FUNC,Direction_Glue,FUNCTION,"End");
  };

}; // end namespace direction_glue
}; // end namespace direction
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core
}; // end namespace behavioural
}; // end namespace morpheo              
#endif
