#ifdef SYSTEMC
# if defined(STATISTICS) or defined(VHDL_TESTBENCH)
/*
 * $Id: Register_translation_unit_Glue_transition.cpp 110 2009-02-19 16:31:47Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Register_translation_unit/Register_translation_unit_Glue/include/Register_translation_unit_Glue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace rename_unit {
namespace register_translation_unit {
namespace register_translation_unit_glue {


#undef  FUNCTION
#define FUNCTION "Register_translation_unit_Glue::transition"
  void Register_translation_unit_Glue::transition (void)
  {
    log_printf(FUNC,Register_translation_unit_Glue,FUNCTION,"Begin");

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {
        for (uint32_t i=0; i<_param->_nb_inst_insert; ++i)
          // Test request
          if (PORT_READ(in_INSERT_RENAME_VAL [i]))
            {
              (* _stat_nb_inst_issue_rename_select_req) ++;

              if (internal_INSERT_RENAME_ACK [i])
                (* _stat_nb_inst_issue_rename_select)++;
              if (PORT_READ(in_INSERT_INSERT_ACK     [i]) == 0)
                (*_stat_nb_inst_issue_stall_by_commit    ) ++;
              if (PORT_READ(in_INSERT_RAT_RENAME_ACK [i]) == 0)
                (*_stat_nb_inst_issue_stall_by_rat_rename) ++;
              if (PORT_READ(in_INSERT_RAT_INSERT_ACK [i]) == 0)
                (*_stat_nb_inst_issue_stall_by_rat_insert) ++;
              if (PORT_READ(in_INSERT_FREE_LIST_ACK  [i]) == 0)
                (*_stat_nb_inst_issue_stall_by_free_list ) ++;
              if (PORT_READ(in_INSERT_STAT_LIST_ACK  [i]) == 0)
                (*_stat_nb_inst_issue_stall_by_stat_list ) ++;
            }
      }
#endif

#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
    end_cycle ();
#endif

    log_printf(FUNC,Register_translation_unit_Glue,FUNCTION,"End");
  };

}; // end namespace register_translation_unit_glue
}; // end namespace register_translation_unit
}; // end namespace rename_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
# endif
#endif
