/*
 * $Id: Victim_Pseudo_LRU_deallocation.cpp 128 2009-06-26 08:43:23Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Generic/Victim/Victim_Pseudo_LRU/include/Victim_Pseudo_LRU.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace generic {
namespace victim {
namespace victim_pseudo_lru {

  void Victim_Pseudo_LRU::deallocation (void)
  {
    if (usage_is_set(_usage,USE_SYSTEMC))
      {
    delete     in_CLOCK;
    delete     in_NRESET;

    DELETE1_SIGNAL( in_ACCESS_VAL    ,_param->_nb_access,1);
    DELETE1_SIGNAL(out_ACCESS_ACK    ,_param->_nb_access,1);
    DELETE1_SIGNAL( in_ACCESS_HIT    ,_param->_nb_access,1);
    DELETE1_SIGNAL( in_ACCESS_ADDRESS,_param->_nb_access,log2(_param->_size_address));
    DELETE1_SIGNAL( in_ACCESS_ENTITY ,_param->_nb_access,log2(_param->_nb_entity   ));
    DELETE1_SIGNAL(out_ACCESS_VICTIM ,_param->_nb_access,log2(_param->_nb_entity   ));

    for (uint32_t i=0; i<_param->_size_table; i++)
    delete    reg_TABLE [i];
    delete [] reg_TABLE;
        
    DELETE1(internal_ACCESS_ACK   ,_param->_nb_access);
    DELETE1(internal_ACCESS_VICTIM,_param->_nb_access);
      }

    delete _component;
  };

}; // end namespace victim_pseudo_lru
}; // end namespace victim
}; // end namespace generic
}; // end namespace behavioural
}; // end namespace morpheo              
