#ifdef SYSTEMC
/*
 * $Id: Victim_Pseudo_LRU_genMealy.cpp 128 2009-06-26 08:43:23Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/Victim/Victim_Pseudo_LRU/include/Victim_Pseudo_LRU.h"

namespace morpheo {
namespace behavioural {
namespace generic {
namespace victim {
namespace victim_pseudo_lru {

  void Victim_Pseudo_LRU::genMealy (void)
  {
    if (PORT_READ(in_NRESET))
    for (uint32_t i=0; i<_param->_nb_access; i++)
      {
	Taddress_t address = (_param->_size_table>1)?PORT_READ(in_ACCESS_ADDRESS[i]):0;

#ifdef DEBUG_TEST
        if (address >= _param->_size_table)
          throw ERRORMORPHEO(FUNCTION,toString(_("Address (%d) is invalid (size : %d).\n"),address,_param->_size_table));
#endif

	internal_ACCESS_VICTIM[i] = reg_TABLE[address]->access();

	PORT_WRITE(out_ACCESS_VICTIM[i], internal_ACCESS_VICTIM[i]);
      }//end for i
  };

}; // end namespace victim_pseudo_lru
}; // end namespace victim
}; // end namespace generic
}; // end namespace behavioural
}; // end namespace morpheo              
#endif
