/*
 * $Id: Rename_unit_deallocation.cpp 123 2009-06-08 20:43:30Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/include/Rename_unit.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace rename_unit {


#undef  FUNCTION
#define FUNCTION "Rename_unit::deallocation"
  void Rename_unit::deallocation (void)
  {
    log_begin(Rename_unit,FUNCTION);

    if (usage_is_set(_usage,USE_SYSTEMC))
      {
	delete    in_CLOCK ;
	delete    in_NRESET;

        DELETE2_SIGNAL( in_RENAME_IN_VAL               ,_param->_nb_front_end, _param->_nb_inst_decod[it1],1                                   );
        DELETE2_SIGNAL(out_RENAME_IN_ACK               ,_param->_nb_front_end, _param->_nb_inst_decod[it1],1                                   );
        DELETE2_SIGNAL( in_RENAME_IN_FRONT_END_ID      ,_param->_nb_front_end, _param->_nb_inst_decod[it1],_param->_size_front_end_id          );
        DELETE2_SIGNAL( in_RENAME_IN_CONTEXT_ID        ,_param->_nb_front_end, _param->_nb_inst_decod[it1],_param->_size_context_id            );
        DELETE2_SIGNAL( in_RENAME_IN_DEPTH             ,_param->_nb_front_end, _param->_nb_inst_decod[it1],_param->_size_depth                 );
        DELETE2_SIGNAL( in_RENAME_IN_TYPE              ,_param->_nb_front_end, _param->_nb_inst_decod[it1],_param->_size_type                  );
        DELETE2_SIGNAL( in_RENAME_IN_OPERATION         ,_param->_nb_front_end, _param->_nb_inst_decod[it1],_param->_size_operation             );
        DELETE2_SIGNAL( in_RENAME_IN_NO_EXECUTE        ,_param->_nb_front_end, _param->_nb_inst_decod[it1],1                                   );
//      DELETE2_SIGNAL( in_RENAME_IN_HAVE_EVENT        ,_param->_nb_front_end, _param->_nb_inst_decod[it1],1                                   );
        DELETE2_SIGNAL( in_RENAME_IN_LAST_EVENT        ,_param->_nb_front_end, _param->_nb_inst_decod[it1],1                                   );
        DELETE2_SIGNAL( in_RENAME_IN_IS_DELAY_SLOT     ,_param->_nb_front_end, _param->_nb_inst_decod[it1],1                                   );
#ifdef DEBUG
        DELETE2_SIGNAL( in_RENAME_IN_ADDRESS           ,_param->_nb_front_end, _param->_nb_inst_decod[it1],_param->_size_instruction_address   );
#endif
        DELETE2_SIGNAL( in_RENAME_IN_ADDRESS_NEXT      ,_param->_nb_front_end, _param->_nb_inst_decod[it1],_param->_size_instruction_address   );
        DELETE2_SIGNAL( in_RENAME_IN_HAS_IMMEDIAT      ,_param->_nb_front_end, _param->_nb_inst_decod[it1],1                                   );
        DELETE2_SIGNAL( in_RENAME_IN_IMMEDIAT          ,_param->_nb_front_end, _param->_nb_inst_decod[it1],_param->_size_general_data          );
        DELETE2_SIGNAL( in_RENAME_IN_READ_RA           ,_param->_nb_front_end, _param->_nb_inst_decod[it1],1                                   );
        DELETE2_SIGNAL( in_RENAME_IN_NUM_REG_RA        ,_param->_nb_front_end, _param->_nb_inst_decod[it1],_param->_size_general_register_logic);
        DELETE2_SIGNAL( in_RENAME_IN_READ_RB           ,_param->_nb_front_end, _param->_nb_inst_decod[it1],1                                   );
        DELETE2_SIGNAL( in_RENAME_IN_NUM_REG_RB        ,_param->_nb_front_end, _param->_nb_inst_decod[it1],_param->_size_general_register_logic);
        DELETE2_SIGNAL( in_RENAME_IN_READ_RC           ,_param->_nb_front_end, _param->_nb_inst_decod[it1],1                                   );
        DELETE2_SIGNAL( in_RENAME_IN_NUM_REG_RC        ,_param->_nb_front_end, _param->_nb_inst_decod[it1],_param->_size_special_register_logic);
        DELETE2_SIGNAL( in_RENAME_IN_WRITE_RD          ,_param->_nb_front_end, _param->_nb_inst_decod[it1],1                                   );
        DELETE2_SIGNAL( in_RENAME_IN_NUM_REG_RD        ,_param->_nb_front_end, _param->_nb_inst_decod[it1],_param->_size_general_register_logic);
        DELETE2_SIGNAL( in_RENAME_IN_WRITE_RE          ,_param->_nb_front_end, _param->_nb_inst_decod[it1],1                                   );
        DELETE2_SIGNAL( in_RENAME_IN_NUM_REG_RE        ,_param->_nb_front_end, _param->_nb_inst_decod[it1],_param->_size_special_register_logic);
        DELETE2_SIGNAL( in_RENAME_IN_EXCEPTION_USE     ,_param->_nb_front_end, _param->_nb_inst_decod[it1],_param->_size_exception_use         );
        DELETE2_SIGNAL( in_RENAME_IN_EXCEPTION         ,_param->_nb_front_end, _param->_nb_inst_decod[it1],_param->_size_exception             );
        
        DELETE1_SIGNAL(out_INSERT_VAL                  ,_param->_nb_inst_insert,1                                   );
        DELETE1_SIGNAL( in_INSERT_ACK                  ,_param->_nb_inst_insert,1                                   );
        DELETE1_SIGNAL(out_INSERT_FRONT_END_ID         ,_param->_nb_inst_insert,_param->_size_front_end_id          );
        DELETE1_SIGNAL(out_INSERT_CONTEXT_ID           ,_param->_nb_inst_insert,_param->_size_context_id            );
        DELETE1_SIGNAL(out_INSERT_DEPTH                ,_param->_nb_inst_insert,_param->_size_depth                 );
        DELETE1_SIGNAL(out_INSERT_TYPE                 ,_param->_nb_inst_insert,_param->_size_type                  );
        DELETE1_SIGNAL(out_INSERT_OPERATION            ,_param->_nb_inst_insert,_param->_size_operation             );
        DELETE1_SIGNAL(out_INSERT_NO_EXECUTE           ,_param->_nb_inst_insert,1                                   );
        DELETE1_SIGNAL(out_INSERT_LAST_EVENT           ,_param->_nb_inst_insert,1                                   );
        DELETE1_SIGNAL(out_INSERT_IS_DELAY_SLOT        ,_param->_nb_inst_insert,1                                   );
#ifdef DEBUG
        DELETE1_SIGNAL(out_INSERT_ADDRESS              ,_param->_nb_inst_insert,_param->_size_instruction_address   );
#endif
        DELETE1_SIGNAL(out_INSERT_ADDRESS_NEXT         ,_param->_nb_inst_insert,_param->_size_instruction_address   );
        DELETE1_SIGNAL(out_INSERT_HAS_IMMEDIAT         ,_param->_nb_inst_insert,1                                   );
        DELETE1_SIGNAL(out_INSERT_IMMEDIAT             ,_param->_nb_inst_insert,_param->_size_general_data          );
        DELETE1_SIGNAL(out_INSERT_STORE_QUEUE_PTR_WRITE,_param->_nb_inst_insert,_param->_size_store_queue_ptr       );
        DELETE1_SIGNAL(out_INSERT_STORE_QUEUE_PTR_READ ,_param->_nb_inst_insert,_param->_size_store_queue_ptr       );
        DELETE1_SIGNAL(out_INSERT_STORE_QUEUE_EMPTY    ,_param->_nb_inst_insert,1                                   );
        DELETE1_SIGNAL(out_INSERT_LOAD_QUEUE_PTR_WRITE ,_param->_nb_inst_insert,_param->_size_load_queue_ptr        );
        DELETE1_SIGNAL(out_INSERT_EXCEPTION_USE        ,_param->_nb_inst_insert,_param->_size_exception_use         );
        DELETE1_SIGNAL(out_INSERT_EXCEPTION            ,_param->_nb_inst_insert,_param->_size_exception             );
        DELETE1_SIGNAL(out_INSERT_READ_RA              ,_param->_nb_inst_insert,1                                   );
#ifdef DEBUG
        DELETE1_SIGNAL(out_INSERT_NUM_REG_RA_LOG       ,_param->_nb_inst_insert,_param->_size_general_register_logic);
#endif
        DELETE1_SIGNAL(out_INSERT_NUM_REG_RA_PHY       ,_param->_nb_inst_insert,_param->_size_general_register      );
        DELETE1_SIGNAL(out_INSERT_READ_RB              ,_param->_nb_inst_insert,1                                   );
#ifdef DEBUG
        DELETE1_SIGNAL(out_INSERT_NUM_REG_RB_LOG       ,_param->_nb_inst_insert,_param->_size_general_register_logic);
#endif
        DELETE1_SIGNAL(out_INSERT_NUM_REG_RB_PHY       ,_param->_nb_inst_insert,_param->_size_general_register      );
        DELETE1_SIGNAL(out_INSERT_READ_RC              ,_param->_nb_inst_insert,1                                   );
#ifdef DEBUG
        DELETE1_SIGNAL(out_INSERT_NUM_REG_RC_LOG       ,_param->_nb_inst_insert,_param->_size_special_register_logic);
#endif
        DELETE1_SIGNAL(out_INSERT_NUM_REG_RC_PHY       ,_param->_nb_inst_insert,_param->_size_special_register      );
        DELETE1_SIGNAL(out_INSERT_WRITE_RD             ,_param->_nb_inst_insert,1                                   );
        DELETE1_SIGNAL(out_INSERT_NUM_REG_RD_LOG       ,_param->_nb_inst_insert,_param->_size_general_register_logic);
        DELETE1_SIGNAL(out_INSERT_NUM_REG_RD_PHY_OLD   ,_param->_nb_inst_insert,_param->_size_general_register      );
        DELETE1_SIGNAL(out_INSERT_NUM_REG_RD_PHY_NEW   ,_param->_nb_inst_insert,_param->_size_general_register      );
        DELETE1_SIGNAL(out_INSERT_WRITE_RE             ,_param->_nb_inst_insert,1                                   );
        DELETE1_SIGNAL(out_INSERT_NUM_REG_RE_LOG       ,_param->_nb_inst_insert,_param->_size_special_register_logic);
        DELETE1_SIGNAL(out_INSERT_NUM_REG_RE_PHY_OLD   ,_param->_nb_inst_insert,_param->_size_special_register      );
        DELETE1_SIGNAL(out_INSERT_NUM_REG_RE_PHY_NEW   ,_param->_nb_inst_insert,_param->_size_special_register      );
        
        DELETE1_SIGNAL( in_RETIRE_VAL                  ,_param->_nb_inst_retire,1                                   );
        DELETE1_SIGNAL(out_RETIRE_ACK                  ,_param->_nb_inst_retire,1                                   );
        DELETE1_SIGNAL( in_RETIRE_FRONT_END_ID         ,_param->_nb_inst_retire,_param->_size_front_end_id          );
        DELETE1_SIGNAL( in_RETIRE_CONTEXT_ID           ,_param->_nb_inst_retire,_param->_size_context_id            );
//      DELETE1_SIGNAL( in_RETIRE_TYPE                 ,_param->_nb_inst_retire,_param->_size_type                  );
//      DELETE1_SIGNAL( in_RETIRE_OPERATION            ,_param->_nb_inst_retire,_param->_size_operation             );
        DELETE1_SIGNAL( in_RETIRE_USE_STORE_QUEUE      ,_param->_nb_inst_retire,1                                   );
        DELETE1_SIGNAL( in_RETIRE_USE_LOAD_QUEUE       ,_param->_nb_inst_retire,1                                   );
        DELETE1_SIGNAL( in_RETIRE_STORE_QUEUE_PTR_WRITE,_param->_nb_inst_retire,_param->_size_store_queue_ptr       );
        DELETE1_SIGNAL( in_RETIRE_LOAD_QUEUE_PTR_WRITE ,_param->_nb_inst_retire,_param->_size_load_queue_ptr        );
//         DELETE1_SIGNAL( in_RETIRE_READ_RA              ,_param->_nb_inst_retire,1                                   );
//         DELETE1_SIGNAL( in_RETIRE_NUM_REG_RA_PHY       ,_param->_nb_inst_retire,_param->_size_general_register      );
//         DELETE1_SIGNAL( in_RETIRE_READ_RB              ,_param->_nb_inst_retire,1                                   );
//         DELETE1_SIGNAL( in_RETIRE_NUM_REG_RB_PHY       ,_param->_nb_inst_retire,_param->_size_general_register      );
//         DELETE1_SIGNAL( in_RETIRE_READ_RC              ,_param->_nb_inst_retire,1                                   );
//         DELETE1_SIGNAL( in_RETIRE_NUM_REG_RC_PHY       ,_param->_nb_inst_retire,_param->_size_special_register      );
        DELETE1_SIGNAL( in_RETIRE_WRITE_RD             ,_param->_nb_inst_retire,1                                   );
        DELETE1_SIGNAL( in_RETIRE_NUM_REG_RD_LOG       ,_param->_nb_inst_retire,_param->_size_general_register_logic);
        DELETE1_SIGNAL( in_RETIRE_NUM_REG_RD_PHY_OLD   ,_param->_nb_inst_retire,_param->_size_general_register      );
        DELETE1_SIGNAL( in_RETIRE_NUM_REG_RD_PHY_NEW   ,_param->_nb_inst_retire,_param->_size_general_register      );
        DELETE1_SIGNAL( in_RETIRE_WRITE_RE             ,_param->_nb_inst_retire,1                                   );
        DELETE1_SIGNAL( in_RETIRE_NUM_REG_RE_LOG       ,_param->_nb_inst_retire,_param->_size_special_register_logic);
        DELETE1_SIGNAL( in_RETIRE_NUM_REG_RE_PHY_OLD   ,_param->_nb_inst_retire,_param->_size_special_register      );
        DELETE1_SIGNAL( in_RETIRE_NUM_REG_RE_PHY_NEW   ,_param->_nb_inst_retire,_param->_size_special_register      );

        DELETE2_SIGNAL( in_RETIRE_EVENT_VAL            ,_param->_nb_front_end, _param->_nb_context[it1],1);
        DELETE2_SIGNAL(out_RETIRE_EVENT_ACK            ,_param->_nb_front_end, _param->_nb_context[it1],1);
        DELETE2_SIGNAL( in_RETIRE_EVENT_STATE          ,_param->_nb_front_end, _param->_nb_context[it1],_param->_size_event_state);
//         DELETE2_SIGNAL( in_RETIRE_EVENT_FLUSH          ,_param->_nb_front_end, _param->_nb_context[it1],1);
        DELETE2_SIGNAL( in_RETIRE_EVENT_STOP           ,_param->_nb_front_end, _param->_nb_context[it1],1);
        
        DELETE2_SIGNAL(in_SPR_READ_SR                  ,_param->_nb_front_end, _param->_nb_context[it1],_param->_size_spr);

#ifdef DEBUG_TEST
        DELETE0_SIGNAL( in_INFO_ROB_EMPTY  ,1);
#endif
      }
    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
    delete _component_rename_select            ;
    delete _component_register_translation_unit;
    delete _component_load_store_pointer_unit  ;
    delete _component_glue                     ;

    delete _component;

    log_end(Rename_unit,FUNCTION);
  };

}; // end namespace rename_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
