#ifdef SYSTEMC
/*
 * $Id: Icache_Access_transition.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Icache_Access/include/Icache_Access.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace icache_access {


#undef  FUNCTION
#define FUNCTION "Icache_Access::transition"
  void Icache_Access::transition (void)
  {
    log_begin(Icache_Access,FUNCTION);

    if (PORT_READ(in_NRESET) == 0)
      {
	_priority->reset();
      }
    else
      {
	// next priority
	_priority->transition();

#ifdef STATISTICS
        if (usage_is_set(_usage,USE_STATISTICS))
          for (uint32_t i=0; i<_param->_nb_icache_port;i++)
            {
              (*_stat_nb_access         [i]) += _internal_ICACHE_REQ_NB_ACCESS         [i];
              (*_stat_nb_access_conflit [i]) += _internal_ICACHE_REQ_NB_ACCESS_CONFLIT [i];
            }
#endif
      }

#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
    end_cycle ();
#endif

    log_end(Icache_Access,FUNCTION);
  };

}; // end namespace icache_access
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
