/*
 * $Id: Parameters_msg_error.cpp 111 2009-02-27 18:37:40Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/include/Types.h"
#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Direction/Meta_Predictor/Two_Level_Branch_Predictor/include/Parameters.h"
#include <sstream>

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace direction {
namespace meta_predictor {
namespace two_level_branch_predictor {


#undef  FUNCTION
#define FUNCTION "Two_Level_Branch_Predictor::msg_error"
  Parameters_test Parameters::msg_error(void)
  {
    log_begin(Two_Level_Branch_Predictor,FUNCTION);

    Parameters_test test ("Two_Level_Branch_Predictor");

    if ((_have_bht or _have_pht) == false)
      test.error(_("They have no Branch History Table and no Pattern History Table. You need a less of a BHT or a PHT\n"));

    if ( _have_bht and (_size_address < _bht_size_address))
      test.error(_("The address's size must to large to the number of shifter in the Branch History Table.\n"));

    if (_have_pht and (_size_address < _pht_size_address))
      test.error(_("The address's size must to large to the number of counter in the Pattern History Table.\n"));

    if (_have_pht and _have_bht and (_bht_size_address > _pht_nb_counter))
      test.error (_("The size of shifter don't must too large that the number of counter in the Pattern History Table.\n"));

    if (_have_pht and _have_bht and (_pht_size_address_share > _bht_size_shifter))
      test.error (_("The size of address share don't must too large that the size of shifter in the Branch History Table.\n"));

    log_end(Two_Level_Branch_Predictor,FUNCTION);

    return test;
  };

}; // end namespace two_level_branch_predictor
}; // end namespace meta_predictor
}; // end namespace direction
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
