#ifdef VHDL

/*
 * $Id: Vhdl_get_library.cpp 113 2009-04-14 18:39:12Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/include/Vhdl.h"
#include "Common/include/Tabulation.h"
#include <sstream>

namespace morpheo              {
namespace behavioural          {
  
#undef  FUNCTION
#define FUNCTION "Vhdl::get_library"
  std::string Vhdl::get_library (uint32_t depth)
  {
    log_printf(FUNC,Behavioural,FUNCTION,"Begin");

    std::list<std::string>::iterator i   = _list_library.begin();
    std::string                 tab = morpheo::tab(depth);
    std::ostringstream          text;

    if (i != _list_library.end())
      text << get_list(_list_library,depth,";",true);

    log_printf(FUNC,Behavioural,FUNCTION,"End");

    return text.str();
  };
  
}; // end namespace behavioural          
}; // end namespace morpheo              

#endif
