/*
 * Test_029
 *
 * end_ko : infinite_loop
 * end_ok : Write in R1 the stop address and stop an data
 *          The store in the destination of an jump
 * start  : Test l.msync
 */
	
	.file	"crt0.s"
	/*
	.section .vector
	*/
	.section .text
	.align	4	

/* ---[ 0x0  : Print a error ]------------------------------------------- */

	.org 0x0
_end_ko        :        
	l.movhi r1,     hi(_tty)
	l.ori   r1, r1, lo(_tty)
        l.sw    4(r1), r1 /* stop address */
_infinite_loop :        
        l.j	_infinite_loop
        l.nop

_end_ok :
	l.movhi r1,     hi(_tty)
	l.ori   r1, r1, lo(_tty)
        l.sw    4(r1), r0 /* stop address */


/* ---[ 0x100: RESET exception ]----------------------------------------- */
        .org 0x100
	.global _start
_start:
	l.movhi r1,       hi(_stack) /* address */
	l.ori   r1, r1,   lo(_stack)

        l.msync
        
	l.movhi r2,       hi(0xbebebeef) /* data */
	l.ori   r2, r2,   lo(0xbebebeef)
	l.movhi r11,      hi(0x00000010) /* iteration */
	l.ori   r11, r11, lo(0x00000010)

        l.and   r3, r1, r1
        l.and   r4, r2, r2
        l.j     _loop1_test
        l.add   r10, r0, r0
_loop1_do :
        l.sw    0(r3), r4
        l.msync
        l.addi  r3, r3,-4
        l.addi  r4, r4,+1
_loop1_test :
        l.sfeq  r10, r11
        l.bnf   _loop1_do
        l.addi  r10, r10, 1
        

        l.and   r3, r1, r1
        l.and   r4, r2, r2
        l.j     _loop2_test
        l.add   r10, r0, r0
_loop2_do :
        l.lwz   r5,  0(r3)
        l.msync
        l.sfeq  r5, r4
        l.bnf   _end_ko
        l.nop
        l.addi  r3, r3,-4
        l.addi  r4, r4,+1
_loop2_test :
        l.sfeq  r10, r11
        l.bnf   _loop2_do
        l.addi  r10, r10, 1
       
        /* end test */
        l.j     _end_ok
        l.nop
