#ifndef morpheo_behavioural_core_multi_front_end_front_end_decod_unit_decod_instruction_Types_h
#define morpheo_behavioural_core_multi_front_end_front_end_decod_unit_decod_instruction_Types_h

/*
 * $Id: Types.h 134 2009-07-15 08:41:01Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Common/include/BitManipulation.h"
#include "Common/include/Log2.h"
#include "Behavioural/include/Types.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace decod_unit {
namespace decod {

  typedef struct 
  {
    // set by ifetch
    Tinstruction_t      _instruction       ;
    Tgeneral_data_t     _address_previous  ;
    Tgeneral_data_t     _address           ;
    Tgeneral_data_t     _address_next      ; // if event, is address_epcr
    Tcontext_t          _context_id        ;
    Tcontrol_t          _is_delay_slot     ;
//  Tbranch_state_t     _branch_state               ;
//  Tprediction_ptr_t   _branch_update_prediction_id;
		        		   
    // set by predictor 		   
//  Tdepth_t            _depth             ;
		        		   
    // set by decod     		   
    Ttype_t             _type              ;
    Toperation_t        _operation         ;
    Tcontrol_t          _no_execute        ;
    Tcontrol_t          _has_immediat      ;
    Tgeneral_data_t     _immediat          ;
    Tcontrol_t          _read_ra           ;
    Tgeneral_address_t  _num_reg_ra        ;
    Tcontrol_t          _read_rb           ;
    Tgeneral_address_t  _num_reg_rb        ;
    Tcontrol_t          _read_rc           ;
    Tspecial_address_t  _num_reg_rc        ;
    Tcontrol_t          _write_rd          ;
    Tgeneral_address_t  _num_reg_rd        ;
    Tcontrol_t          _write_re          ;
    Tspecial_address_t  _num_reg_re        ;
    Texception_t        _exception_use     ;
    Texception_t        _exception         ;
    Tbranch_condition_t _branch_condition  ;
//  Tcontrol_t          _branch_stack_write;
    Tcontrol_t          _branch_direction  ;
    Tevent_type_t       _event_type        ;
  } decod_instruction_t;

  class decod_param_t
  {
  public : uint32_t           _size_data ;
  public : Tgeneral_data_t    _mask_data ;
  public : Tgeneral_data_t    _mask_shift;
  public : void (*** _function_decod ) (decod_instruction_t *, decod_param_t *); // [type][opcod]
  public : void (*** _function_custom) (decod_instruction_t *, decod_param_t *); // [type][opcod]
  
  public : decod_param_t (uint32_t size_data,
			  void (*** function_decod ) (decod_instruction_t *, decod_param_t *),
			  void (*** function_custom) (decod_instruction_t *, decod_param_t *))
    {
      _size_data       = size_data;
      _mask_data       = gen_mask<Tgeneral_data_t> (size_data);
      _mask_shift      = gen_mask<Tgeneral_data_t> (log2(size_data));
      _function_decod  = function_decod;
      _function_custom = function_custom;
    };
  public : ~decod_param_t (void)
    {
    };
  };


  typedef void function_decod_t 
  (morpheo::behavioural::core::multi_front_end::front_end::decod_unit::decod::decod_instruction_t *, 
   morpheo::behavioural::core::multi_front_end::front_end::decod_unit::decod::decod_param_t       *);
  

}; // end namespace decod
}; // end namespace decod_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core
}; // end namespace behavioural
}; // end namespace morpheo              

#endif
