#ifndef morpheo_behavioural_core_multi_ooo_engine_ooo_engine_reexecute_unit_Parameters_h
#define morpheo_behavioural_core_multi_ooo_engine_ooo_engine_reexecute_unit_Parameters_h

/*
 * $Id: Parameters.h 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/include/Parameters.h"
#include "Common/include/Debug.h"
#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Reexecute_unit/include/Types.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace reexecute_unit {


  class Parameters : public morpheo::behavioural::Parameters
  {
    //-----[ fields ]------------------------------------------------------------
//public : uint32_t            _size_context_id         ;
//public : uint32_t            _size_front_end_id       ;
//public : uint32_t            _size_packet_id          ;
  public : uint32_t            _size_queue              ;
  public : uint32_t            _nb_execute_loop         ;
  public : uint32_t          * _nb_inst_execute         ;//[nb_execute_loop]
  public : uint32_t            _nb_inst_commit          ;
  public : uint32_t            _nb_inst_reexecute       ;
  public : uint32_t            _nb_execute_loop_select  ;
  public : Tpriority_t         _priority_execute_loop   ;
  public : Tload_balancing_t   _load_balancing          ;
//public : uint32_t            _size_general_register_id;
//public : uint32_t            _size_special_register_id;
//public : uint32_t            _size_general_data       ;
//public : uint32_t            _size_special_data       ;
//public : uint32_t            _size_store_queue_ptr    ;
//public : uint32_t            _size_load_queue_ptr     ;
  public : static const Tpriority_t _priority_queue_in = PRIORITY_ROUND_ROBIN;

  public : uint32_t            _max_nb_inst_execute     ;
  public : uint32_t            _nb_bank                 ;
  public : uint32_t            _size_bank               ;

//public : bool                _have_port_context_id    ;
//public : bool                _have_port_front_end_id  ;
//public : bool                _have_port_packet_id     ;
//public : bool                _have_port_load_queue_ptr;
    
    //-----[ methods ]-----------------------------------------------------------
  public : Parameters  (uint32_t            size_context_id         ,
			uint32_t            size_front_end_id       ,
			uint32_t            size_packet_id          ,
			uint32_t            size_queue              ,
			uint32_t            nb_execute_loop         ,
			uint32_t          * nb_inst_execute         ,
			uint32_t            nb_inst_commit          ,
			uint32_t            nb_inst_reexecute       ,
			uint32_t            nb_execute_loop_select  ,
			Tpriority_t         priority_execute_loop   ,
			Tload_balancing_t   load_balancing          ,
			uint32_t            size_general_register_id,
			uint32_t            size_special_register_id,
			uint32_t            size_general_data       ,
			uint32_t            size_special_data       ,
			uint32_t            size_store_queue_ptr    ,
			uint32_t            size_load_queue_ptr     ,
                        bool                is_toplevel=false);

//   public : Parameters  (Parameters & param) ;
  public : ~Parameters () ;

  public :        void            copy       (void);

  public :        Parameters_test msg_error  (void);

  public :        std::string     print      (uint32_t depth);
  public : friend std::ostream&   operator<< (std::ostream& output_stream,
					    morpheo::behavioural::core::multi_ooo_engine::ooo_engine::reexecute_unit::Parameters & x);
  };

}; // end namespace reexecute_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
