#ifndef morpheo_behavioural_generic_queue_control_Queue_Control_h
#define morpheo_behavioural_generic_queue_control_Queue_Control_h

/*
 * $Id: Queue_Control.h 101 2009-01-15 17:19:08Z rosiere $
 *
 * [Description ]
 * 
 */

#include <iostream>
#include <vector>

#include "Common/include/ErrorMorpheo.h"
#include "Common/include/ToString.h"
#include "Common/include/Debug.h"

namespace morpheo {
namespace behavioural {
namespace generic {
namespace queue_control {

  class Queue_Control
  {
  private : const uint32_t     _nb_elt_max;
  private : uint32_t           _nb_elt;
  private : std::vector<uint32_t> * _tab;
    
  public  :          Queue_Control  (uint32_t nb_elt_max);
  public  :          ~Queue_Control (void);
    
  public  : uint32_t nb_elt   (void);
  public  : bool     full     (void);
  public  : bool     empty    (void);
  public  : void     clear    (void);

  public  : uint32_t ptr_pop  (uint32_t index=0);
  public  : uint32_t ptr_push (void);


  public  : uint32_t push     (void);
  public  : uint32_t push_ovf (void);
  public  : void     pop      (uint32_t index);
  public  : void     pop      (void);
  public  : void     pop_ovf  (uint32_t index);
  public  : void     pop_ovf  (void);
    
  public : uint32_t operator[] (uint32_t);
  public : std::ostream& operator<< (std::ostream& output_stream);
  };
  
}; // end namespace queue_control
}; // end namespace generic
}; // end namespace behavioural
}; // end namespace morpheo              

#endif
