/*
 * $Id: Interface.cpp 135 2009-07-17 08:59:05Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/include/Interface.h"

namespace morpheo              {
namespace behavioural          {

  Interface::Interface  (std::string                name         
#ifdef POSITION
			 ,direction_t           direction    
			 ,localisation_t        localisation 
#endif
			 ,Tusage_t             usage
			 ):
    _name         (name        )
#ifdef POSITION
    ,_direction    (direction   )
    ,_localisation (localisation)
#endif
    ,_usage        (usage)
  {
    log_printf(FUNC,Behavioural,"Interface","Begin");

    _list_signal   = new (std::list<Signal*>);

#ifdef POSITION
    _comment       = "";
    _is_map        = false;
    _entity_map    = NULL;
    _interface_map = NULL;
#endif

#ifdef VHDL_TESTBENCH
    _nb_cycle      = 0;
    _make_testbench= true;
#endif

    log_printf(FUNC,Behavioural,"Interface","End");
  };

  Interface::Interface  (const Interface & interface):
    _name         (interface._name        )
#ifdef POSITION
    ,_direction    (interface._direction   )
    ,_localisation (interface._localisation)
#endif
    ,_usage        (interface._usage)
  {
    log_printf(FUNC,Behavioural,"Interface (copy)","Begin");
    _list_signal   = interface._list_signal;
#ifdef POSITION
    _comment       = interface._comment    ;
    _is_map        = interface._is_map     ;
    _entity_map    = interface._entity_map   ;
    _interface_map = interface._interface_map;
#endif
#ifdef VHDL_TESTBENCH
    _nb_cycle      = interface._nb_cycle;
#endif

    log_printf(FUNC,Behavioural,"Interface (copy)","End");
  };
  
  Interface::~Interface ()
  {
    log_printf(FUNC,Behavioural,"~Interface","Begin");

    for (std::list<Signal*>::iterator it = _list_signal->begin();
         it != _list_signal->end();
         ++it)
      {
        if ((_usage & USE_SYSTEMC) and 
            ((*it)->get_direction() == INTERNAL))
          delete (*it)->get_sc_signal();
        delete (*it);
      }
    
    delete _list_signal;

    log_printf(FUNC,Behavioural,"~Interface","End");
  };
  

}; // end namespace behavioural          
}; // end namespace morpheo              
