/*
 * $Id: Ifetch_unit_deallocation.cpp 128 2009-06-26 08:43:23Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Ifetch_unit/include/Ifetch_unit.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace ifetch_unit {


#undef  FUNCTION
#define FUNCTION "Ifetch_unit::deallocation"
  void Ifetch_unit::deallocation (void)
  {
    log_printf(FUNC,Ifetch_unit,FUNCTION,"Begin");

    if (usage_is_set(_usage,USE_SYSTEMC))
      {
	delete     in_CLOCK ;
	delete     in_NRESET;

        DELETE0_SIGNAL(out_ICACHE_REQ_VAL      ,1);
        DELETE0_SIGNAL( in_ICACHE_REQ_ACK      ,1);
//      DELETE0_SIGNAL(out_ICACHE_REQ_THREAD_ID,_param->_size_context_id );
        DELETE0_SIGNAL(out_ICACHE_REQ_PACKET_ID,_param->_size_ifetch_queue_ptr  );
        DELETE0_SIGNAL(out_ICACHE_REQ_ADDRESS  ,_param->_size_instruction_address    );
        DELETE0_SIGNAL(out_ICACHE_REQ_TYPE     ,_param->_size_icache_type);

        DELETE0_SIGNAL( in_ICACHE_RSP_VAL        ,1);
        DELETE0_SIGNAL(out_ICACHE_RSP_ACK        ,1);
    //  DELETE0_SIGNAL( in_ICACHE_RSP_THREAD_ID  ,_param->_size_context_id  );
        DELETE0_SIGNAL( in_ICACHE_RSP_PACKET_ID  ,_param->_size_ifetch_queue_ptr   );
        DELETE0_SIGNAL( in_ICACHE_RSP_ERROR      ,_param->_size_icache_error);
        DELETE1_SIGNAL( in_ICACHE_RSP_INSTRUCTION,_param->_nb_instruction, _param->_size_instruction);

        DELETE0_SIGNAL(out_PREDICT_VAL                        ,1);
        DELETE0_SIGNAL( in_PREDICT_ACK                        ,1);
        DELETE0_SIGNAL(out_PREDICT_PC_PREVIOUS                ,_param->_size_instruction_address);
        DELETE0_SIGNAL(out_PREDICT_PC_CURRENT                 ,_param->_size_instruction_address);
        DELETE0_SIGNAL(out_PREDICT_PC_CURRENT_IS_DS_TAKE      ,1);
        DELETE0_SIGNAL( in_PREDICT_PC_NEXT                    ,_param->_size_instruction_address);
        DELETE0_SIGNAL( in_PREDICT_PC_NEXT_IS_DS_TAKE         ,1);
        DELETE0_SIGNAL( in_PREDICT_INST_IFETCH_PTR            ,_param->_size_inst_ifetch_ptr);
        DELETE0_SIGNAL( in_PREDICT_BRANCH_STATE               ,_param->_size_branch_state);
        DELETE0_SIGNAL( in_PREDICT_BRANCH_UPDATE_PREDICTION_ID,_param->_size_depth);
        DELETE1_SIGNAL( in_PREDICT_INSTRUCTION_ENABLE         ,_param->_nb_instruction,1);

    //  DELETE0_SIGNAL(out_DECOD_CONTEXT_ID                 ,_param->_size_context_id);
        DELETE0_SIGNAL(out_DECOD_ADDRESS                    ,_param->_size_instruction_address);
        DELETE0_SIGNAL(out_DECOD_INST_IFETCH_PTR            ,_param->_size_inst_ifetch_ptr);
        DELETE0_SIGNAL(out_DECOD_BRANCH_STATE               ,_param->_size_branch_state);
        DELETE0_SIGNAL(out_DECOD_BRANCH_UPDATE_PREDICTION_ID,_param->_size_depth);
        DELETE0_SIGNAL(out_DECOD_EXCEPTION                  ,_param->_size_exception_ifetch);
        DELETE1_SIGNAL(out_DECOD_VAL                        ,_param->_nb_instruction,1);
        DELETE1_SIGNAL( in_DECOD_ACK                        ,_param->_nb_instruction,1);
        DELETE1_SIGNAL(out_DECOD_INSTRUCTION                ,_param->_nb_instruction,_param->_size_instruction);

        DELETE0_SIGNAL( in_EVENT_VAL              ,1);
        DELETE0_SIGNAL(out_EVENT_ACK              ,1);
        DELETE0_SIGNAL( in_EVENT_ADDRESS          ,_param->_size_instruction_address);
        DELETE0_SIGNAL( in_EVENT_ADDRESS_NEXT     ,_param->_size_instruction_address);
        DELETE0_SIGNAL( in_EVENT_ADDRESS_NEXT_VAL ,1);
        DELETE0_SIGNAL( in_EVENT_IS_DS_TAKE       ,1);
      }

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
    delete _component_address_management;
    delete _component_ifetch_queue;
    delete _component_ifetch_unit_glue;
    delete _component;

    log_printf(FUNC,Ifetch_unit,FUNCTION,"End");
  };

}; // end namespace ifetch_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
