/*
 * $Id: main.cpp 112 2009-03-18 22:36:26Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Register_translation_unit/SelfTest/include/test.h"

#define NB_PARAMS 7

void usage (int argc, char * argv[])
{
  err (_("<Usage> %s name_instance list_params.\n"),argv[0]);
  err (_("list_params is :\n"));
  err (_(" * nb_front_end                       (uint32_t)\n"));
  err (_(" * nb_context          [nb_front_end] (uint32_t)\n"));
  err (_(" * nb_general_register                (uint32_t)\n"));
  err (_(" * nb_special_register                (uint32_t)\n"));
  err (_(" * nb_inst_insert                     (uint32_t)\n"));
  err (_(" * nb_inst_retire                     (uint32_t)\n"));
  err (_(" * nb_reg_free                        (uint32_t)\n"));
  err (_(" * nb_bank                            (uint32_t)\n"));
//   err (_(" * size_read_counter                  (uint32_t)\n"));

  exit (1);
}

#ifndef SYSTEMC
int main    (int argc, char * argv[])
#else
int sc_main (int argc, char * argv[])
#endif
{
  if (argc < 2+NB_PARAMS)
    usage (argc, argv);

  uint32_t x    = 1;
  string   name = argv[x++];

  uint32_t   _nb_front_end        = atoi(argv[x++]);
  uint32_t * _nb_context          = new uint32_t [_nb_front_end];

  for (uint32_t i=0; i<_nb_front_end; i++)
    _nb_context [i] = atoi(argv[x++]);

  uint32_t   _nb_general_register = atoi(argv[x++]);
  uint32_t   _nb_special_register = atoi(argv[x++]);
  uint32_t   _nb_inst_insert      = atoi(argv[x++]);
  uint32_t   _nb_inst_retire      = atoi(argv[x++]);
  uint32_t   _nb_reg_free         = atoi(argv[x++]);
  uint32_t   _nb_bank             = atoi(argv[x++]);
//   uint32_t   _size_read_counter   = atoi(argv[x++]);

  int _return = EXIT_SUCCESS;
  try 
    {
      morpheo::behavioural::core::multi_ooo_engine::ooo_engine::rename_unit::register_translation_unit::Parameters * param = new morpheo::behavioural::core::multi_ooo_engine::ooo_engine::rename_unit::register_translation_unit::Parameters
	(_nb_front_end          ,
	 _nb_context            ,
	 _nb_general_register   ,
	 _nb_special_register   ,
	 _nb_inst_insert        ,
	 _nb_inst_retire        ,
	 _nb_reg_free           ,
	 _nb_bank               ,
// 	 _size_read_counter     ,
         true //is_toplevel
         );
      
      msg(_("%s"),param->print(1).c_str());
      
      test (name,param);
    }
  catch (morpheo::ErrorMorpheo & error)
    {
      msg (_("<%s> : %s.\n"),name.c_str(), error.what ());
      _return = EXIT_FAILURE;
    }
  catch (...)
    {
      err (_("<%s> : This test must generate a error.\n"),name.c_str());
      _return = EXIT_FAILURE;
    }

  delete _nb_context;

  return (_return);
}

