/*
 * $Id: Return_Address_Stack_deallocation.cpp 112 2009-03-18 22:36:26Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Return_Address_Stack/include/Return_Address_Stack.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace return_address_stack {


#undef  FUNCTION
#define FUNCTION "Return_Address_Stack::deallocation"
  void Return_Address_Stack::deallocation (void)
  {
    log_printf(FUNC,Return_Address_Stack,FUNCTION,"Begin");

    if (usage_is_set(_usage,USE_SYSTEMC))
      {
	delete    in_CLOCK ;
	delete    in_NRESET;

        DELETE1_SIGNAL( in_PREDICT_VAL             ,_param->_nb_inst_predict,1);
        DELETE1_SIGNAL(out_PREDICT_ACK             ,_param->_nb_inst_predict,1);
        DELETE1_SIGNAL( in_PREDICT_CONTEXT_ID      ,_param->_nb_inst_predict,_param->_size_context_id); 
        DELETE1_SIGNAL(out_PREDICT_HIT             ,_param->_nb_inst_predict,1); 
        DELETE1_SIGNAL( in_PREDICT_PUSH            ,_param->_nb_inst_predict,1);
        DELETE1_SIGNAL( in_PREDICT_ADDRESS_PUSH    ,_param->_nb_inst_predict,_param->_size_instruction_address);
        DELETE1_SIGNAL(out_PREDICT_ADDRESS_POP     ,_param->_nb_inst_predict,_param->_size_instruction_address);
        DELETE1_SIGNAL(out_PREDICT_INDEX           ,_param->_nb_inst_predict,_param->_size_index);

        DELETE1_SIGNAL( in_DECOD_VAL               ,_param->_nb_inst_decod,1);
        DELETE1_SIGNAL(out_DECOD_ACK               ,_param->_nb_inst_decod,1);
        DELETE1_SIGNAL( in_DECOD_CONTEXT_ID        ,_param->_nb_inst_decod,_param->_size_context_id); 
        DELETE1_SIGNAL(out_DECOD_HIT               ,_param->_nb_inst_decod,1); 
        DELETE1_SIGNAL( in_DECOD_PUSH              ,_param->_nb_inst_decod,1);
        DELETE1_SIGNAL( in_DECOD_ADDRESS_PUSH      ,_param->_nb_inst_decod,_param->_size_instruction_address);
        DELETE1_SIGNAL(out_DECOD_ADDRESS_POP       ,_param->_nb_inst_decod,_param->_size_instruction_address);
        DELETE1_SIGNAL(out_DECOD_INDEX             ,_param->_nb_inst_decod,_param->_size_index);
        DELETE1_SIGNAL( in_DECOD_MISS_PREDICTION   ,_param->_nb_inst_decod,1);

        DELETE1_SIGNAL( in_UPDATE_VAL              ,_param->_nb_inst_update,1);
        DELETE1_SIGNAL(out_UPDATE_ACK              ,_param->_nb_inst_update,1);
        DELETE1_SIGNAL( in_UPDATE_CONTEXT_ID       ,_param->_nb_inst_update,_param->_size_context_id); 
        DELETE1_SIGNAL( in_UPDATE_PUSH             ,_param->_nb_inst_update,1);
        DELETE1_SIGNAL( in_UPDATE_FLUSH            ,_param->_nb_inst_update,1);
        DELETE1_SIGNAL( in_UPDATE_ADDRESS          ,_param->_nb_inst_update,_param->_size_instruction_address);
        DELETE1_SIGNAL( in_UPDATE_INDEX            ,_param->_nb_inst_update,_param->_size_index);
        DELETE1_SIGNAL( in_UPDATE_MISS_PREDICTION  ,_param->_nb_inst_update,1);
        DELETE1_SIGNAL( in_UPDATE_PREDICTION_IFETCH,_param->_nb_inst_update,1);
        
        // ~~~~~[ Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        DELETE2(reg_stack            ,_param->_nb_context,_param->_size_queue [it1]);

        DELETE1(reg_TOP              ,_param->_nb_context);
//      DELETE1(reg_BOTTOM           ,_param->_nb_context);
        DELETE1(reg_NB_ELT           ,_param->_nb_context);

        DELETE1(reg_PREDICT_TOP      ,_param->_nb_context);
//      DELETE1(reg_PREDICT_BOTTOM   ,_param->_nb_context);
        DELETE1(reg_PREDICT_NB_ELT   ,_param->_nb_context);

        DELETE1(internal_PREDICT_ACK ,_param->_nb_inst_predict);
        DELETE1(internal_PREDICT_HIT ,_param->_nb_inst_predict);
        DELETE1(internal_DECOD_ACK   ,_param->_nb_inst_decod  );
        DELETE1(internal_DECOD_HIT   ,_param->_nb_inst_decod  );
        DELETE1(internal_UPDATE_ACK  ,_param->_nb_inst_update );
      }

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    delete _component;

    log_printf(FUNC,Return_Address_Stack,FUNCTION,"End");
  };

}; // end namespace return_address_stack
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
