#ifdef SYSTEMC
/*
 * $Id: Simulation_test_end.cpp 124 2009-06-17 12:11:25Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/include/Simulation.h"
#include "Common/include/Systemc.h"
#include "Common/include/ErrorMorpheo.h"

namespace morpheo              {
namespace behavioural          {

  bool simulation_test_end (void)
  {
    msgInformation("##########[ cycle %.0f ]\n",static_cast<double>(simulation_cycle()));

    // Test if a stop condition is activate
    if ((_simulation_nb_cycle == 0) and
        (_simulation_nb_instruction == 0)
        )
      return false;

    bool end_cycle;
    bool end_inst ;

    if (_simulation_nb_cycle != 0)
      end_cycle = (_simulation_nb_cycle <= simulation_cycle());
    else
      end_cycle = true;

    if (_simulation_nb_instruction != 0)
      {
        end_inst = true;

        std::vector<double>::iterator it=_simulation_nb_instruction_commited.begin();
        
        // Scan all context and test if all can finish
        while (end_inst and it!=_simulation_nb_instruction_commited.end())
          {
            end_inst &= (_simulation_nb_instruction <= *it);
            it ++;
          }
      }
    else
      end_inst = true;
    
    if (end_cycle and _simulation_stop_exception)
      {
        throw ErrorMorpheo(_("Maximal cycles Reached"));
        return false;
      }
    else
      return end_cycle and end_inst;
  }

}; // end namespace behavioural          
}; // end namespace morpheo              

#endif
